/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.miniseed;

import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.seis.EquallySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.seis.TraceWriter;
import de.gfz_potsdam.gipp.common.seis.cube.BlockTag;
import de.gfz_potsdam.gipp.common.seis.cube.TraceInfo;
import de.gfz_potsdam.gipp.common.seis.miniseed.EncodingFormat;
import de.gfz_potsdam.gipp.common.seis.miniseed.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.miniseed.MiniseedException;
import de.gfz_potsdam.gipp.common.seis.miniseed.Record;
import de.gfz_potsdam.gipp.common.seis.miniseed.Trace;
import de.gfz_potsdam.gipp.common.seis.miniseed.UnsupportedException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeWindow;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;

public class MiniseedTraceWriter
extends TraceWriter {
    private static final int SAMPLE_BUFFER_LIMIT = 10000;
    private static final int RECORD_BUFFER_LOW = 1;
    private static final int RECORD_BUFFER_HIGH = 64;
    private static final Logger log = Logger.getLogger(MiniseedTraceWriter.class.getName());
    private final List<EquallySpacedTimeSeries> sampleBufferList;
    private final List<SortedSet<Record>> recordBufferList;
    private final List<OutputStream> outputStreamList;
    private final List<String> stationIdList;
    private final List<String> channelIdList;
    private final List<String> networkIdList;
    private final List<String> locationIdList;
    private final TimeWindow timeWindow;
    private final LinkedList<TimeMoment> splitTimes;
    private final File outputDir;
    private final boolean forceOverwrite;
    private boolean isClosed;
    private TimeMoment nextFileTime;
    private int outputRecordSize;
    private ByteOrder outputByteOrder;
    private EncodingFormat outputCodec;

    public static LinkedList<TimeMoment> generateCubeFileTimes(TraceInfo cubeTrace) {
        LinkedList<TimeMoment> result = new LinkedList<TimeMoment>();
        File currentFile = null;
        for (BlockTag tag : cubeTrace.getIndex()) {
            if (currentFile == tag.file()) continue;
            TimeMoment time = cubeTrace.getApproximateTimeAt(tag.number());
            if (time != null) {
                result.add(time);
            }
            currentFile = tag.file();
        }
        return result;
    }

    public static MiniseedTraceWriter newStreamWriter(OutputStream outStream, String stationId, String channelId, String networkId, String locationID) {
        TimeWindow largeWindow = new TimeWindow(TimeMoment.LONG_AGO, TimeMoment.FAR_FUTURE);
        boolean numberOfChannels = true;
        ArrayList<String> stationIds = new ArrayList<String>(1);
        ArrayList<String> channelIds = new ArrayList<String>(1);
        ArrayList<String> networkIds = new ArrayList<String>(1);
        ArrayList<String> locationIds = new ArrayList<String>(1);
        stationIds.add(stationId != null ? stationId : "GIPP");
        channelIds.add(channelId != null ? channelId : "EX1");
        networkIds.add(networkId != null ? networkId : "SY");
        locationIds.add(locationID != null ? locationID : "");
        MiniseedTraceWriter writer = new MiniseedTraceWriter(null, false, largeWindow, null, 1, stationIds, channelIds, networkIds, locationIds, 4096, ByteOrder.nativeOrder(), EncodingFormat.STEIM_1);
        if (outStream != null) {
            writer.outputStreamList.set(0, outStream);
            writer.nextFileTime = TimeMoment.MAX_VALUE;
            writer.splitTimes.clear();
        }
        return writer;
    }

    public static MiniseedTraceWriter newFromMiniseed(Record miniseedRecord, File outputDir, boolean forceOverwrite) {
        if (miniseedRecord == null) {
            throw new IllegalArgumentException("MiniSEED record argument must not be 'null'!");
        }
        TimeWindow largeWindow = new TimeWindow(TimeMoment.LONG_AGO, TimeMoment.FAR_FUTURE);
        boolean numberOfChannels = true;
        ArrayList<String> stationIds = new ArrayList<String>(1);
        ArrayList<String> channelIds = new ArrayList<String>(1);
        ArrayList<String> networkIds = new ArrayList<String>(1);
        ArrayList<String> locationIds = new ArrayList<String>(1);
        stationIds.add(miniseedRecord.getStationId());
        channelIds.add(miniseedRecord.getChannelId());
        networkIds.add(miniseedRecord.getNetworkId());
        locationIds.add(miniseedRecord.getLocationId());
        return new MiniseedTraceWriter(outputDir, forceOverwrite, largeWindow, null, 1, stationIds, channelIds, networkIds, locationIds, miniseedRecord.size(), miniseedRecord.getByteOrder(), miniseedRecord.getCodec());
    }

    public static MiniseedTraceWriter newFromCube(TraceInfo cubeTraceInfo, File outputDir, boolean forceOverwrite, TimeWindow requestWindow) {
        if (cubeTraceInfo == null) {
            throw new IllegalArgumentException("Cube trace info argument must not be 'null'!");
        }
        if (requestWindow == null) {
            throw new IllegalArgumentException("Request window argument must not be 'null'!");
        }
        int numberOfChannels = cubeTraceInfo.getNumberOfChannels();
        assert (numberOfChannels > 0) : "Impossible number of recording channels (" + numberOfChannels + ").";
        ArrayList<String> stationIds = new ArrayList<String>(numberOfChannels);
        ArrayList<String> channelIds = new ArrayList<String>(numberOfChannels);
        ArrayList<String> networkIds = new ArrayList<String>(numberOfChannels);
        ArrayList<String> locationIds = new ArrayList<String>(numberOfChannels);
        for (int channel = 0; channel < numberOfChannels; ++channel) {
            stationIds.add((cubeTraceInfo.getCubeName() + "     ").substring(0, 5));
            channelIds.add(("p" + channel + "   ").substring(0, 3));
            networkIds.add("");
            locationIds.add("");
        }
        LinkedList<TimeMoment> startFilesAtList = MiniseedTraceWriter.generateDayFileTimes(requestWindow);
        return new MiniseedTraceWriter(outputDir, forceOverwrite, requestWindow, startFilesAtList, numberOfChannels, stationIds, channelIds, networkIds, locationIds, 4096, ByteOrder.nativeOrder(), EncodingFormat.STEIM_1);
    }

    private MiniseedTraceWriter(File outputDir, boolean forceOverwrite, TimeWindow requestWindow, LinkedList<TimeMoment> splitTimes, int numberOfChannels, List<String> stationIds, List<String> channelIds, List<String> networkIds, List<String> locationIds, int recordSize, ByteOrder recordByteOrder, EncodingFormat recordEncoding) {
        assert (numberOfChannels > 0) : "Number of channels to write must be positive.";
        assert (stationIds.size() == numberOfChannels) : "Unexpected number miniSEED station ids.";
        assert (channelIds.size() == numberOfChannels) : "Unexpected number miniSEED channel ids.";
        assert (networkIds.size() == numberOfChannels) : "Unexpected number miniSEED network ids.";
        assert (locationIds.size() == numberOfChannels) : "Unexpected number miniSEED location ids.";
        this.outputStreamList = new ArrayList<OutputStream>(numberOfChannels);
        this.recordBufferList = new ArrayList<SortedSet<Record>>(numberOfChannels);
        this.sampleBufferList = new ArrayList<EquallySpacedTimeSeries>(numberOfChannels);
        for (int channel = 0; channel < numberOfChannels; ++channel) {
            this.outputStreamList.add(null);
            this.recordBufferList.add(new TreeSet());
            this.sampleBufferList.add(null);
        }
        this.stationIdList = stationIds;
        this.channelIdList = channelIds;
        this.networkIdList = networkIds;
        this.locationIdList = locationIds;
        this.timeWindow = requestWindow != null ? requestWindow : new TimeWindow(TimeMoment.LONG_AGO, TimeMoment.FAR_FUTURE);
        this.splitTimes = splitTimes != null ? splitTimes : new LinkedList();
        this.nextFileTime = this.splitTimes.size() > 0 ? this.splitTimes.poll() : TimeMoment.MAX_VALUE;
        this.outputDir = outputDir;
        this.forceOverwrite = forceOverwrite;
        this.isClosed = false;
        this.outputRecordSize = recordSize;
        this.outputByteOrder = recordByteOrder;
        this.outputCodec = recordEncoding;
    }

    private File getFilename(Record record) {
        String temp = record.getStationId();
        String stationId = temp == null || temp.length() == 0 ? "xyz" : temp.toLowerCase();
        temp = record.getChannelId();
        String channelId = temp == null || temp.length() == 0 ? "xyz" : (temp.matches("^p\\d$") ? "pri" + temp.charAt(1) : (temp.matches("^s\\d$") ? "sec" + temp.charAt(1) : temp.toLowerCase()));
        String timeStamp = record.getStartTime().toMinimalString();
        int copyCount = 0;
        File outPath = new File(this.outputDir, stationId + timeStamp + "." + channelId);
        if (this.forceOverwrite) {
            if (outPath.exists()) {
                log.warning("The file \"" + outPath.getPath() + "\" already exists and will be overwritten!");
            }
        } else {
            while (outPath.exists()) {
                log.warning("The file \"" + outPath.getName() + "\" already exists!");
                outPath = new File(this.outputDir, stationId + timeStamp + "." + ++copyCount + "." + channelId);
            }
        }
        return outPath;
    }

    private void encodeSampleBuffer(int channel, int limit) throws IntegrityException, IOException {
        double lastValue;
        int index;
        Record record;
        assert (channel >= 0) : "Channel number must be a small positive integer!";
        assert (channel < this.sampleBufferList.size()) : "This recording channel does not exist!";
        if (this.sampleBufferList.get(channel) == null || this.sampleBufferList.get(channel).getNumberOfSamples() == 0) {
            return;
        }
        assert (this.sampleBufferList.get(channel).getNumberOfChannels() == 1) : "Expected a time series with exactly one channel!";
        for (index = 0; this.sampleBufferList.get(channel).getNumberOfSamples() - limit > index; index += record.putSampleData(this.sampleBufferList.get(channel).getValuesOfChannel(0), index, lastValue)) {
            int sequenceNumber;
            if (this.recordBufferList.get(channel).size() > 0) {
                sequenceNumber = this.recordBufferList.get(channel).last().getSequenceNumber() + 1;
                lastValue = this.recordBufferList.get(channel).last().lastSampleValue();
                if (sequenceNumber <= 0 || sequenceNumber >= 1000000) {
                    sequenceNumber = 1;
                }
            } else {
                sequenceNumber = 1;
                lastValue = 0.0;
            }
            record = new Record(this.outputRecordSize, this.outputByteOrder, this.outputCodec, true);
            record.setSequenceNumber(sequenceNumber);
            record.setStationId(this.stationIdList.get(channel));
            record.setChannelId(this.channelIdList.get(channel));
            record.setNetworkId(this.networkIdList.get(channel));
            record.setLocationId(this.locationIdList.get(channel));
            record.setSamplePeriod(this.sampleBufferList.get(channel).getSamplePeriod().getSeconds());
            record.setStartTime(this.sampleBufferList.get(channel).getSampleAtIndex(index).getTime());
            if (record.getSampleCount() <= 0) {
                throw new MiniseedException("Failed to inject samples into miniSEED record!");
            }
            this.recordBufferList.get(channel).add(record);
            if (this.recordBufferList.get(channel).size() <= 64) continue;
            this.writeRecordBuffer(channel, 1, false);
        }
        int remainingSampleCount = this.sampleBufferList.get(channel).getNumberOfSamples() - index;
        if (remainingSampleCount > 0) {
            double[] values = new double[remainingSampleCount];
            System.arraycopy(this.sampleBufferList.get(channel).getValuesOfChannel(0), index, values, 0, remainingSampleCount);
            this.sampleBufferList.set(channel, new EquallySpacedTimeSeries(this.sampleBufferList.get(channel).getTimeAtIndex(index), this.sampleBufferList.get(channel).getSamplePeriod(), new double[][]{values}));
        } else if (remainingSampleCount == 0) {
            this.sampleBufferList.set(channel, null);
        } else {
            throw new ArrayIndexOutOfBoundsException(remainingSampleCount + " samples (!) remain in the sample buffer of channel #" + channel + "?!?");
        }
    }

    private void writeRecordBuffer(int channel, int remaining, boolean reencode) throws IntegrityException, IOException {
        assert (channel >= 0) : "Channel number must be a small positive integer!";
        assert (channel < this.sampleBufferList.size()) : "This recording channel does not exist!";
        assert (remaining >= 0) : "The argument 'remaining' must be non-negative!";
        if (this.recordBufferList.get(channel).size() == 0) {
            return;
        }
        this.reencodeRecordBuffer(channel, reencode);
        if (this.outputStreamList.get(channel) == null) {
            if (this.outputDir == null) {
                this.outputStreamList.set(channel, new BufferedOutputStream(System.out));
                log.fine("(Re-)opening console for writing miniSEED data");
            } else {
                File mseedFile = this.getFilename(this.recordBufferList.get(channel).first());
                this.outputStreamList.set(channel, Files.newOutputStream(mseedFile.toPath(), new OpenOption[0]));
                log.info("Writing to file '" + mseedFile.getName() + "'");
            }
        }
        while (this.recordBufferList.get(channel).size() > remaining) {
            Record first = this.recordBufferList.get(channel).first();
            first.write(this.outputStreamList.get(channel));
            this.recordBufferList.get(channel).remove(first);
        }
    }

    private void reencodeRecordBuffer(int channel, boolean encodingForced) {
        assert (channel >= 0) : "Channel number must be a small positive integer!";
        assert (channel < this.sampleBufferList.size()) : "This recording channel does not exist!";
        assert (this.recordBufferList.get(channel) != null) : "The record buffer of channel #" + channel + " is 'null'!";
        if (this.recordBufferList.get(channel).size() == 0) {
            return;
        }
        boolean encodingRequired = false;
        for (Record record : this.recordBufferList.get(channel)) {
            if (!(this.outputCodec != null && this.outputCodec != record.getCodec() || this.outputByteOrder != null && this.outputByteOrder != record.getByteOrder()) && (this.outputRecordSize <= 0 || this.outputRecordSize == record.size())) continue;
            encodingRequired = true;
            break;
        }
        if (encodingForced || encodingRequired) {
            for (Record record : this.recordBufferList.get(channel)) {
                if (record.getCodec() != EncodingFormat.ASCII) continue;
                throw new UnsupportedException("Cannot re-encode miniSEED because one or more records contain ASCII encode meta-(?)data (e.g. record '#" + record.getSequenceString() + "' of station '" + record.getStationId() + "', channel '" + record.getChannelId() + "' at approx. " + record.getStartTime().toLogString() + ").");
            }
            Trace before = new Trace(this.recordBufferList.get(channel));
            Trace after = before.recode(this.outputRecordSize, this.outputByteOrder, this.outputCodec, null);
            this.recordBufferList.set(channel, after.getAllRecords());
        }
    }

    @Override
    public void flush() throws IOException {
        assert (this.outputStreamList != null) : "The list with the associated output streams was never initialized!";
        if (this.isClosed) {
            return;
        }
        for (int channel = 0; channel < this.outputStreamList.size(); ++channel) {
            this.encodeSampleBuffer(channel, 0);
            this.writeRecordBuffer(channel, 0, false);
            if (this.outputStreamList.get(channel) == null) continue;
            this.outputStreamList.get(channel).flush();
        }
    }

    @Override
    public void close() throws IOException {
        assert (this.outputStreamList != null) : "The list with the associated output streams was never initialized!";
        if (this.isClosed) {
            return;
        }
        this.flush();
        for (int channel = 0; channel < this.outputStreamList.size(); ++channel) {
            if (this.outputStreamList.get(channel) == null || this.outputDir == null) continue;
            FileUtils.flushClose(this.outputStreamList.get(channel));
            this.outputStreamList.set(channel, null);
        }
        this.isClosed = true;
    }

    @Override
    public boolean append(EquallySpacedTimeSeries samples) throws IOException, IntegrityException, IllegalArgumentException {
        EquallySpacedTimeSeries combinedSamples;
        double[] values;
        int channelNumber;
        int stopIndex;
        assert (this.sampleBufferList != null) : "Internal 'Sample' buffer is not initialized!";
        assert (this.recordBufferList != null) : "Internal 'record' buffer is not initialized!";
        assert (this.sampleBufferList.size() == this.recordBufferList.size()) : "Different number of recording channels!";
        assert (this.splitTimes != null) : "Internal 'split time' list is not initialized!";
        if (this.isClosed) {
            throw new IOException(this.getClass().getSimpleName() + " was already closed.");
        }
        EquallySpacedTimeSeries timeSeries = this.timeWindow != null ? EquallySpacedTimeSeries.trim(samples, this.timeWindow) : samples;
        if (timeSeries == null || timeSeries.getNumberOfSamples() <= 0) {
            return false;
        }
        if (timeSeries.getNumberOfChannels() != this.sampleBufferList.size()) {
            throw new IllegalArgumentException("Unexpected number of recording channels (trace writer expected " + this.sampleBufferList.size() + " but got " + timeSeries.getNumberOfChannels() + " instead).");
        }
        while (this.nextFileTime.beforeOrAt(timeSeries.getStartTime())) {
            if (this.splitTimes.isEmpty()) {
                this.nextFileTime = TimeMoment.MAX_VALUE;
                continue;
            }
            this.nextFileTime = this.splitTimes.poll();
        }
        int startIndex = 0;
        for (stopIndex = 0; stopIndex < timeSeries.getNumberOfSamples(); ++stopIndex) {
            if (this.outputDir == null || !timeSeries.getTimeAtIndex(stopIndex).afterOrAt(this.nextFileTime) || stopIndex <= startIndex) continue;
            for (channelNumber = 0; channelNumber < timeSeries.getNumberOfChannels(); ++channelNumber) {
                values = new double[stopIndex - startIndex];
                System.arraycopy(timeSeries.getValuesOfChannel(channelNumber), startIndex, values, 0, values.length);
                EquallySpacedTimeSeries newSamples = new EquallySpacedTimeSeries(timeSeries.getTimeAtIndex(startIndex), timeSeries.getSamplePeriod(), new double[][]{values});
                combinedSamples = EquallySpacedTimeSeries.concatenate(this.sampleBufferList.get(channelNumber), newSamples);
                if (combinedSamples == null) {
                    return false;
                }
                this.sampleBufferList.set(channelNumber, combinedSamples);
                this.encodeSampleBuffer(channelNumber, 0);
                this.writeRecordBuffer(channelNumber, 0, false);
                FileUtils.flushClose(this.outputStreamList.get(channelNumber));
                this.outputStreamList.set(channelNumber, null);
            }
            startIndex = stopIndex;
            this.nextFileTime = this.splitTimes.isEmpty() ? TimeMoment.MAX_VALUE : this.splitTimes.poll();
        }
        if (stopIndex > startIndex) {
            for (channelNumber = 0; channelNumber < timeSeries.getNumberOfChannels(); ++channelNumber) {
                values = new double[stopIndex - startIndex];
                System.arraycopy(timeSeries.getValuesOfChannel(channelNumber), startIndex, values, 0, values.length);
                EquallySpacedTimeSeries remainingSamples = new EquallySpacedTimeSeries(timeSeries.getTimeAtIndex(startIndex), timeSeries.getSamplePeriod(), new double[][]{values});
                combinedSamples = EquallySpacedTimeSeries.concatenate(this.sampleBufferList.get(channelNumber), remainingSamples);
                if (combinedSamples == null) {
                    return false;
                }
                this.sampleBufferList.set(channelNumber, combinedSamples);
                if (this.sampleBufferList.get(channelNumber).getNumberOfSamples() > 10000) {
                    this.encodeSampleBuffer(channelNumber, 10000);
                }
                if (this.recordBufferList.get(channelNumber).size() < 64) continue;
                this.writeRecordBuffer(channelNumber, 1, false);
            }
        }
        return true;
    }

    public boolean append(Record record) throws IOException, IntegrityException {
        assert (this.sampleBufferList != null) : "Internal 'Sample' buffer is not initialized!";
        assert (this.recordBufferList != null) : "Internal 'record' buffer is not initialized!";
        assert (this.sampleBufferList.size() == this.recordBufferList.size()) : "Different number of recording channels!";
        if (this.isClosed) {
            throw new IOException(this.getClass().getSimpleName() + " was already closed.");
        }
        if (record == null) {
            return false;
        }
        if (record.getSampleCount() == 0 && record.getCodec() != EncodingFormat.ASCII) {
            return true;
        }
        for (int channel = 0; channel < this.recordBufferList.size(); ++channel) {
            this.encodeSampleBuffer(channel, 0);
            if (this.recordBufferList.get(channel).size() >= 64) {
                this.writeRecordBuffer(channel, 1, false);
            }
            if (this.recordBufferList.get(channel).size() != 0 && !Record.isContinuous(this.recordBufferList.get(channel).last(), record) && !Record.isContinuous(record, this.recordBufferList.get(channel).first()) && (record.getCodec() != EncodingFormat.ASCII || !Record.isSameStream(record, this.recordBufferList.get(channel).first()))) continue;
            this.recordBufferList.get(channel).add(record);
            return true;
        }
        return false;
    }

    public boolean append(Trace trace) throws IOException, IntegrityException {
        assert (this.sampleBufferList != null) : "Internal 'Sample' buffer is not initialized!";
        assert (this.recordBufferList != null) : "Internal 'record' buffer is not initialized!";
        assert (this.sampleBufferList.size() == this.recordBufferList.size()) : "Different number of recording channels!";
        if (this.isClosed) {
            throw new IOException(this.getClass().getSimpleName() + " was already closed.");
        }
        if (trace == null) {
            return false;
        }
        if (trace.getRecordCount() == 0) {
            return true;
        }
        if (this.outputStreamList == null) {
            return false;
        }
        for (Record record : trace.getAllRecords()) {
            if (this.append(record)) continue;
            return false;
        }
        return true;
    }

    public void setRecordSize(int size) {
        this.outputRecordSize = size;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.outputByteOrder = byteOrder;
    }

    public void setEncoding(EncodingFormat encoding) {
        this.outputCodec = encoding;
    }
}

