/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.miniseed;

import de.gfz_potsdam.gipp.common.seis.miniseed.ArithmeticOverflowException;
import de.gfz_potsdam.gipp.common.seis.miniseed.MiniseedCodec;
import java.nio.ByteBuffer;

public class IeeeFloatCodec
implements MiniseedCodec {
    private static final int FLOAT_SIZE = 4;

    @Override
    public int decodeSamples(ByteBuffer src, int srcPos, double[] dest, int destPos, int length) {
        int count;
        if (length < 0) {
            throw new IllegalArgumentException("Cannot decode " + length + " samples.");
        }
        if (length == 0) {
            return 0;
        }
        src.position(srcPos);
        for (count = 0; src.remaining() >= 4 && count < length; ++count) {
            dest[destPos + count] = src.getFloat();
        }
        return count;
    }

    @Override
    public int encodeSamples(double[] src, int srcPos, ByteBuffer dest, int destPos, int length, double bias) throws IllegalArgumentException {
        int srcIndex;
        if (src == null) {
            throw new IllegalArgumentException("The sample source is \"null\".");
        }
        if (src.length == 0) {
            throw new IllegalArgumentException("The source contains no samples.");
        }
        if (srcPos >= src.length) {
            throw new IllegalArgumentException("The source does not contain enough samples to start reading from this offset.");
        }
        if (dest == null) {
            throw new IllegalArgumentException("The destination buffer is \"null\".");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Cannot encode " + length + " samples.");
        }
        dest.position(destPos);
        for (srcIndex = srcPos; srcIndex < src.length && srcIndex - srcPos < length && dest.remaining() >= 4; ++srcIndex) {
            if (Math.abs(src[srcIndex]) > 3.4028234663852886E38) {
                throw new ArithmeticOverflowException("The absolute value of '" + src[srcIndex] + "' is to large to be represented by an IEEE single precision floating point variable. Cannot encode data!");
            }
            dest.putFloat((float)src[srcIndex]);
        }
        return srcIndex - srcPos;
    }

    @Override
    public double getFirstSample(ByteBuffer src, int srcPos) {
        return src.getFloat(srcPos);
    }

    @Override
    public double getLastSample(ByteBuffer src, int srcPos, int length) {
        return src.getFloat(srcPos + (length - 1) * 4);
    }
}

