/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.miniseed;

public enum EncodingFormat {
    ASCII(0, "ASCII text"),
    INT_16(1, "Binary (16 bit integer)"),
    INT_24(2, "Binary (24 bit integer)"),
    INT_32(3, "Binary (32 bit integer)"),
    IEEE_FLOAT(4, "IEEE single precision floating point"),
    IEEE_DOUBLE(5, "IEEE double precision floating point"),
    STEIM_1(10, "Steim-1 compression"),
    STEIM_2(11, "Steim-2 compression"),
    GEOSCOPE_INT_24(12, "GEOSCOPE Multiplexed (24 bit integer)"),
    GEOSCOPE_INT_16_3(13, "GEOSCOPE Multiplexed (16 bit gain ranged, 3 bit exponent)"),
    GEOSCOPE_INT_16_4(14, "GEOSCOPE Multiplexed (16 bit gain ranged, 4 bit exponent)"),
    USNSN(15, "US National Seismic Network data compression"),
    CDSN(16, "CDSN (16 bit gain ranged)"),
    GRAEFENBERG(17, "Graefenberg (16 bit gain ranged)"),
    IPG(18, "IPG Strassbourg (16 bit gain ranged)"),
    STEIM_3(19, "Steim-3 compression"),
    SRO(30, "SRO format"),
    HPLG(31, "HPLG format"),
    DWWSSN(32, "DWWSSN gain ranged"),
    RSTN(33, "RSTN (16 bit gain ranged");

    private final String description;
    private final byte codeNumber;

    private EncodingFormat(int code, String description) {
        this.description = description;
        this.codeNumber = (byte)code;
    }

    public String toString() {
        return this.description;
    }

    public byte getCode() {
        return this.codeNumber;
    }
}

