/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.BlockTag;
import de.gfz_potsdam.gipp.common.seis.cube.RecordedTimeTag;
import de.gfz_potsdam.gipp.common.seis.cube.TaipBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TimingQualityException;
import de.gfz_potsdam.gipp.common.seis.cube.TraceInfo;
import de.gfz_potsdam.gipp.common.seis.cube.VirtualTimeTag;
import de.gfz_potsdam.gipp.common.time.ExpiredLeapSecondInfoException;
import de.gfz_potsdam.gipp.common.time.InvalidLeapSecondInfoException;
import de.gfz_potsdam.gipp.common.time.LeapSecondInfo;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.util.logging.Logger;

public class WnroUtil {
    private static final Logger log = Logger.getLogger(WnroUtil.class.getName());

    public static void wnroCorrection(TraceInfo traceInfo, TimeSpan callerWNRO) throws InvalidLeapSecondInfoException, ExpiredLeapSecondInfoException, TimingQualityException {
        TimeSpan headerWNRO = traceInfo.getWnroCorrection();
        TimeSpan correction = callerWNRO != null ? WnroUtil.adaptCorrection(traceInfo, callerWNRO) : (headerWNRO != null ? WnroUtil.adaptCorrection(traceInfo, headerWNRO) : WnroUtil.adaptCorrection(traceInfo, null));
        if (correction != null && correction != TimeSpan.ZERO) {
            log.info("Applying WNRO correction..");
            WnroUtil.correctUtcTime(traceInfo, correction);
        } else {
            log.fine("No WNRO correction necessary.");
        }
    }

    private static TimeSpan adaptCorrection(TraceInfo traceInfo, TimeSpan wnroCorrection) throws InvalidLeapSecondInfoException, ExpiredLeapSecondInfoException, TimingQualityException {
        for (BlockTag blockTag : traceInfo.getIndex()) {
            if (blockTag instanceof RecordedTimeTag) {
                RecordedTimeTag tag = (RecordedTimeTag)blockTag;
                Integer sourceOffset = tag.getSourceGpsUtcOffset();
                Integer appliedOffset = tag.getAppliedGpsUtcOffset();
                TimeMoment utcTime = tag.time();
                if (sourceOffset == null || sourceOffset == 0) continue;
                String gpsTime = TaipBlock.buildGpsDateTimeString(utcTime.getYear(), utcTime.getMonth(), utcTime.getDay(), utcTime.getHour(), utcTime.getMinute(), utcTime.getSecond(), appliedOffset);
                int iersOffset = LeapSecondInfo.getGpsUtcOffset(gpsTime);
                if (wnroCorrection != null) {
                    if (wnroCorrection == TimeSpan.ZERO) {
                        return TimeSpan.ZERO;
                    }
                    int offsetDiff = sourceOffset - appliedOffset;
                    return TimeSpan.diff(wnroCorrection, TimeSpan.SECOND.multiply(offsetDiff));
                }
                if (Math.abs(sourceOffset - iersOffset) > 1) {
                    int offsetDiff = sourceOffset - appliedOffset;
                    return TimeSpan.diff(TimeSpan.GPS_EPOCH, TimeSpan.SECOND.multiply(offsetDiff));
                }
                return TimeSpan.ZERO;
            }
            if (!(blockTag instanceof VirtualTimeTag)) continue;
            throw new TimingQualityException("WNRO correction must be applied before virtual time tag generation.");
        }
        if (wnroCorrection == null) {
            log.info("Cube " + traceInfo.getCubeName() + " does not provide enough information to detect WNRO events.");
        }
        return wnroCorrection;
    }

    private static void correctUtcTime(TraceInfo traceInfo, TimeSpan correction) throws TimingQualityException {
        assert (traceInfo != null);
        assert (correction != null);
        for (BlockTag blockTag : traceInfo.getIndex()) {
            if (blockTag instanceof RecordedTimeTag) {
                RecordedTimeTag tag = (RecordedTimeTag)blockTag;
                tag.time(tag.time().add(correction));
                continue;
            }
            if (!(blockTag instanceof VirtualTimeTag)) continue;
            throw new TimingQualityException("WNRO correction must be applied before virtual time tag generation.");
        }
    }
}

