/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.BinaryBlock;
import de.gfz_potsdam.gipp.common.seis.cube.CubeException;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import java.io.Serializable;

public class VoltageBlock
extends BinaryBlock
implements Serializable {
    private static final long serialVersionUID = 1L;

    public VoltageBlock() {
        super(-1);
    }

    VoltageBlock(int[] data) {
        super(data);
    }

    public double getVoltage() {
        if (this.content.isEmpty()) {
            throw new CubeException("No voltage is available yet! Please read/parse a voltage block first.");
        }
        int index = 0;
        int counts = 0;
        switch (this.content.size()) {
            case 3: {
                counts += ((Byte)this.content.get(index++) & 0x7F) << 14;
            }
            case 2: {
                counts += ((Byte)this.content.get(index++) & 0x7F) << 7;
                return (double)(counts += (Byte)this.content.get(index) & 0x7F) / 1000.0;
            }
        }
        throw new IntegrityException("Expected a block size of either three or four bytes but got " + (this.content.size() + 1) + " instead.");
    }

    @Override
    public String toString() {
        if (this.content.isEmpty()) {
            return "--unread-voltage-block--";
        }
        return StringUtils.roundedNumber(this.getVoltage(), 2, 2) + "V";
    }
}

