/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.InfoBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TextualFields;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import java.io.DataOutput;
import java.io.IOException;

public class TrailerBlock
extends InfoBlock {
    private static final long serialVersionUID = 1L;

    @Override
    public int write(DataOutput stream) throws IOException {
        return this.write(stream, 240);
    }

    public TimeMoment approxRecorderStop() {
        String date = this.getValue(TextualFields.STOP_DATE);
        String time = this.getValue(TextualFields.STOP_TIME);
        if (date != null && time != null) {
            try {
                return TimeMoment.parse("20" + date + "T" + time);
            }
            catch (TimeException e) {
                return null;
            }
        }
        return null;
    }

    public double dcellVoltage() {
        String temp = this.getValue(TextualFields.VOLTAGE_INTERN);
        try {
            if (temp == null) {
                return Double.NaN;
            }
            return Double.parseDouble(temp) / 1000.0;
        }
        catch (NumberFormatException exp) {
            return Double.NaN;
        }
    }

    public double externVoltage() {
        String temp = this.getValue(TextualFields.VOLTAGE_EXTERN);
        try {
            if (temp == null) {
                return Double.NaN;
            }
            return Double.parseDouble(temp) / 1000.0;
        }
        catch (NumberFormatException exp) {
            return Double.NaN;
        }
    }
}

