/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.seis.cube.Block;
import de.gfz_potsdam.gipp.common.seis.cube.BlockTag;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.DelayBlock;
import de.gfz_potsdam.gipp.common.seis.cube.HeaderBlock;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.RecordedTimeTag;
import de.gfz_potsdam.gipp.common.seis.cube.SystemEventBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TaipBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TimeTag;
import de.gfz_potsdam.gipp.common.seis.cube.VirtualTimeTag;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.common.time.TimeWindow;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class TraceInfo
implements Comparable<TraceInfo>,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final int FILE_BUFFER_SIZE = 0x800000;
    private static final double PPS_TOLERANCE = 0.05;
    private static final Logger log = Logger.getLogger(TraceInfo.class.getName());
    private HeaderBlock traceHeader = null;
    private List<BlockTag> traceIndex = new ArrayList<BlockTag>();
    private int lastCubeFileNumber = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContinuous(File cubeFile) throws FileNotFoundException {
        HeaderBlock fileHeader;
        RandomAccessFile raf;
        block4: {
            boolean bl;
            if (this.traceHeader == null) {
                return true;
            }
            raf = null;
            try {
                raf = new RandomAccessFile(cubeFile, "r");
                fileHeader = CubeUtils.getHeader(raf);
                if (fileHeader != null) break block4;
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtils.flushClose(raf);
                throw throwable;
            }
            FileUtils.flushClose(raf);
            return bl;
        }
        boolean bl = this.traceHeader.cubeName().equals(fileHeader.cubeName()) && this.traceHeader.approxRecorderStartup().equals(fileHeader.approxRecorderStartup()) && this.traceHeader.enabledChannels() == fileHeader.enabledChannels() && this.traceHeader.channelGains().equals(fileHeader.channelGains()) && this.lastCubeFileNumber + 1 == fileHeader.fileNumber();
        FileUtils.flushClose(raf);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceInfo append(File cubeFile) throws IllegalArgumentException, FileNotFoundException, IntegrityException, IOException {
        assert (this.traceIndex != null) : "Uninitialized 'traceIndex'!";
        if (cubeFile == null) {
            throw new IllegalArgumentException("Cube file argument must not be 'null'!");
        }
        FileInputStream inStream = null;
        FileChannel inChannel = null;
        long bufferStart = 0L;
        long sampleCount = this.getNumberOfSamples();
        long timeTagOffset = -1L;
        long timeTagIndex = -1L;
        long lastSampleOffset = -1L;
        try {
            ByteBuffer inBuffer = ByteBuffer.allocateDirect(0x800000);
            inStream = new FileInputStream(cubeFile);
            inChannel = inStream.getChannel();
            inChannel.position(0L);
            inChannel.read(inBuffer);
            inBuffer.flip();
            TaipBlock taip = null;
            DelayBlock delay = null;
            HeaderBlock header = null;
            boolean isFirstSample = true;
            int blockFlag = inBuffer.get() & 0xFF;
            assert (blockFlag >= 128);
            block13: while (true) {
                try {
                    while (true) {
                        inBuffer.mark();
                        switch (blockFlag) {
                            case 240: {
                                header = new HeaderBlock();
                                blockFlag = header.read(inBuffer);
                                if (header.isPartiallyRead()) {
                                    throw new IntegrityException("The Cube header block found at offset #" + (bufferStart + (long)inBuffer.position()) + " is corrupt or incomplete! At least one mandatory header field is missing! Did you by any chance use non-ASCII characters in the 'Config.txt' file? Maybe for the experiment name?");
                                }
                                if (this.traceHeader == null) {
                                    this.traceHeader = header;
                                    this.lastCubeFileNumber = header.fileNumber();
                                    continue block13;
                                }
                                if (this.traceHeader.cubeName().equals(header.cubeName()) && this.traceHeader.approxRecorderStartup().equals(header.approxRecorderStartup()) && this.traceHeader.enabledChannels() == header.enabledChannels() && this.traceHeader.channelGains().equals(header.channelGains()) && this.lastCubeFileNumber + 1 == header.fileNumber()) {
                                    this.lastCubeFileNumber = header.fileNumber();
                                    continue block13;
                                }
                                throw new IntegrityException("An additional Cube header block indicating a discontinuity in the trace was found at offset #" + (bufferStart + (long)inBuffer.position()) + ".");
                            }
                            case 160: {
                                assert (this.traceHeader != null);
                                if ((double)(sampleCount - timeTagIndex) <= (double)this.traceHeader.sampleRate() * 1.05 && (double)(sampleCount - timeTagIndex) >= (double)this.traceHeader.sampleRate() * 0.95) {
                                    taip = new TaipBlock();
                                    blockFlag = taip.read(inBuffer);
                                    continue block13;
                                }
                                taip = null;
                                blockFlag = Block.skip(inBuffer);
                                log.fine("Unexpected number of samples between the current  TAIP block and the previous PPS sample block. (Found " + (sampleCount - timeTagIndex) + " samples instead of " + this.traceHeader.sampleRate() + " samples.) Skipping  TAIP block in the vicinity of file '" + cubeFile.getName() + "' sample #" + sampleCount + "!");
                                continue block13;
                            }
                            case 176: 
                            case 177: {
                                assert (this.traceHeader != null);
                                if ((double)(sampleCount - timeTagIndex) <= (double)this.traceHeader.sampleRate() * 1.05 && (double)(sampleCount - timeTagIndex) >= (double)this.traceHeader.sampleRate() * 0.95) {
                                    delay = new DelayBlock(blockFlag);
                                    blockFlag = delay.read(inBuffer);
                                    continue block13;
                                }
                                delay = null;
                                blockFlag = Block.skip(inBuffer);
                                log.fine("Unexpected number of samples between the current delay block and the previous PPS sample block. (Found " + (sampleCount - timeTagIndex) + " samples instead of " + this.traceHeader.sampleRate() + " samples.) Skipping delay block in the vicinity of file '" + cubeFile.getName() + "' sample #" + sampleCount + "!");
                                continue block13;
                            }
                            case 152: {
                                delay = RecordedTimeTag.DUMMY_ZERO_DELAY_BLOCK;
                            }
                            case 144: {
                                assert (header != null);
                                RecordedTimeTag tag = RecordedTimeTag.newTag(timeTagIndex, cubeFile, timeTagOffset, taip, delay, header.firFilterDelay());
                                if (tag != null) {
                                    TimeTag previous = this.getLastTimeTag();
                                    TimeSpan flushSpan = TimeSpan.HOUR;
                                    if (previous != null && previous.time().after(tag.time()) && flushSpan != null && TimeSpan.diff(tag.time(), previous.time()).compareTo(flushSpan) > 0) {
                                        throw new IntegrityException("The time tag at file position #" + tag.offset() + " claims to be recorded at " + tag.time() + ", which is " + TimeSpan.diff(tag.time(), previous.time()) + " before (!) the previous time tag at " + previous.time() + ".");
                                    }
                                    this.traceIndex.add(tag);
                                }
                                timeTagIndex = sampleCount;
                                timeTagOffset = bufferStart + (long)inBuffer.position();
                                taip = null;
                                delay = null;
                            }
                            case 128: 
                            case 136: {
                                if (isFirstSample) {
                                    BlockTag first = new BlockTag(sampleCount, cubeFile, bufferStart + (long)inBuffer.position());
                                    this.traceIndex.add(first);
                                    isFirstSample = false;
                                }
                                lastSampleOffset = bufferStart + (long)inBuffer.position();
                                blockFlag = Block.skip(inBuffer);
                                ++sampleCount;
                                continue block13;
                            }
                            case 192: {
                                SystemEventBlock event = new SystemEventBlock();
                                blockFlag = event.read(inBuffer);
                                if (!event.ringBufferOverrunIsOn()) continue block13;
                                throw new IntegrityException("Detected a \"ring buffer overflow\" error at file offset #" + (bufferStart + (long)inBuffer.position()) + ". Approximately " + event.numberOfMissingSamples() + " samples are missing!");
                            }
                        }
                        blockFlag = Block.skip(inBuffer);
                    }
                }
                catch (BufferUnderflowException e) {
                    inBuffer.reset();
                    if (inBuffer.position() == 0) {
                        throw new IntegrityException("Cube block is larger than the read buffer (" + StringUtils.toShortSiByteCount(inBuffer.limit()) + ")!");
                    }
                    bufferStart += (long)inBuffer.position();
                    inBuffer.compact();
                    if (inChannel.read(inBuffer) != -1) {
                        inBuffer.flip();
                        continue;
                    }
                    if (lastSampleOffset >= 0L) {
                        BlockTag last = new BlockTag(sampleCount - 1L, cubeFile, lastSampleOffset);
                        this.traceIndex.add(last);
                    }
                    FileUtils.flushClose(inChannel);
                    FileUtils.flushClose(inStream);
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (lastSampleOffset >= 0L) {
                BlockTag last = new BlockTag(sampleCount - 1L, cubeFile, lastSampleOffset);
                this.traceIndex.add(last);
            }
            FileUtils.flushClose(inChannel);
            FileUtils.flushClose(inStream);
            throw throwable;
        }
        return this;
    }

    public List<BlockTag> getIndex() {
        assert (this.traceIndex != null) : "Uninitialized 'traceIndex'!";
        return this.traceIndex;
    }

    public void setIndex(List<BlockTag> newIndex) {
        if (newIndex == null) {
            throw new IllegalArgumentException("Thd new tag index must not be 'null'.");
        }
        this.traceIndex = newIndex;
    }

    public int getTimeTagCount() {
        if (this.traceIndex == null) {
            return 0;
        }
        int count = 0;
        for (BlockTag tag : this.traceIndex) {
            if (!(tag instanceof TimeTag)) continue;
            ++count;
        }
        return count;
    }

    public BlockTag getFirstSample() {
        if (this.traceIndex == null || this.traceIndex.isEmpty()) {
            return null;
        }
        return this.traceIndex.get(0);
    }

    public TimeTag getFirstTimeTag() {
        if (this.traceIndex == null) {
            return null;
        }
        for (BlockTag tag : this.traceIndex) {
            if (!(tag instanceof TimeTag)) continue;
            return (TimeTag)((Object)tag);
        }
        return null;
    }

    public BlockTag getLastSample() {
        if (this.traceIndex == null || this.traceIndex.isEmpty()) {
            return null;
        }
        return this.traceIndex.get(this.traceIndex.size() - 1);
    }

    public TimeTag getLastTimeTag() {
        assert (!this.traceIndex.isEmpty()) : "No trace index available. BlockTag list is empty!";
        for (int i = this.traceIndex.size() - 1; i >= 0; --i) {
            if (!(this.traceIndex.get(i) instanceof TimeTag)) continue;
            return (TimeTag)((Object)this.traceIndex.get(i));
        }
        return null;
    }

    public boolean timetagFirstSample(TimeSpan timePeriod, long sampleCount) {
        assert (this.traceIndex != null) : "Trace index is not initialized!";
        if (timePeriod == null || timePeriod.isZeroLength()) {
            throw new IllegalArgumentException("No or zero length time span given. Can't compute a sampling rate!");
        }
        if (sampleCount <= 0L) {
            throw new IllegalArgumentException("Invalid number of recorded samples given (" + sampleCount + "). Can't compute a sampling rate!");
        }
        BlockTag firstSample = this.getFirstSample();
        TimeTag firstTimeTag = this.getFirstTimeTag();
        if (firstSample == null || firstTimeTag == null) {
            return false;
        }
        if (firstSample.equals(firstTimeTag)) {
            return false;
        }
        TimeSpan delta = TimeSpan.multiply(timePeriod, firstTimeTag.number() - firstSample.number()).divide(sampleCount);
        TimeMoment timeOfFirstSample = TimeSpan.subtract(firstTimeTag.time(), delta);
        VirtualTimeTag newTimeTag = new VirtualTimeTag(firstSample.number(), firstSample.file(), firstSample.offset(), timeOfFirstSample);
        this.traceIndex.set(0, newTimeTag);
        return true;
    }

    public boolean timetagLastSample(TimeSpan timePeriod, long sampleCount) {
        assert (this.traceIndex != null) : "Trace index is not initialized!";
        if (timePeriod == null || timePeriod.isZeroLength()) {
            throw new IllegalArgumentException("No or zero length time span given. Can't compute a sampling rate!");
        }
        if (sampleCount <= 0L) {
            throw new IllegalArgumentException("Invalid number of recorded samples given (" + sampleCount + "). Can't compute a sampling rate!");
        }
        BlockTag lastSample = this.getLastSample();
        TimeTag lastTimeTag = this.getLastTimeTag();
        if (lastSample == null || lastTimeTag == null) {
            return false;
        }
        if (lastSample.equals(lastTimeTag)) {
            return false;
        }
        TimeSpan delta = TimeSpan.multiply(timePeriod, lastSample.number() - lastTimeTag.number()).divide(sampleCount);
        TimeMoment timeOfLastSample = TimeSpan.add(lastTimeTag.time(), delta);
        VirtualTimeTag newTimeTag = new VirtualTimeTag(lastSample.number(), lastSample.file(), lastSample.offset(), timeOfLastSample);
        this.traceIndex.set(this.traceIndex.size() - 1, newTimeTag);
        return true;
    }

    public TimeWindow getMaximumTimeWindow() {
        assert (!this.traceIndex.isEmpty()) : "No trace index available. BlockTag list is empty!";
        TimeTag start = this.getFirstTimeTag();
        TimeTag stop = this.getLastTimeTag();
        if (start == null || stop == null) {
            return null;
        }
        if (start.equals(stop)) {
            return null;
        }
        return new TimeWindow(start.time(), stop.time());
    }

    @Deprecated
    private BlockTag getSampleLocation(TimeMoment time) {
        assert (!this.traceIndex.isEmpty()) : "No trace index available. BlockTag list is empty!";
        TimeTag lastFix = null;
        for (BlockTag tag : this.traceIndex) {
            if (!(tag instanceof TimeTag)) continue;
            TimeTag gpsFix = (TimeTag)((Object)tag);
            if (gpsFix.time().before(time) || gpsFix.time().equals(time)) {
                lastFix = gpsFix;
                continue;
            }
            return (BlockTag)((Object)lastFix);
        }
        return null;
    }

    @Deprecated
    private BlockTag getSampleLocation(long number) {
        assert (!this.traceIndex.isEmpty()) : "No trace index available. BlockTag list is empty!";
        BlockTag result = null;
        for (BlockTag tag : this.traceIndex) {
            if (tag.number() > number) {
                return result;
            }
            result = tag;
        }
        return null;
    }

    public TimeMoment getApproximateTimeAt(long number) {
        TimeTag left = null;
        TimeTag right = null;
        for (BlockTag tag : this.traceIndex) {
            if (!(tag instanceof TimeTag)) continue;
            if (tag.number() < number) {
                left = (TimeTag)((Object)tag);
                continue;
            }
            if (tag.number() != number) break;
            return ((TimeTag)((Object)tag)).time();
        }
        if (left == null) {
            return null;
        }
        for (int i = this.traceIndex.size() - 1; i >= 0; --i) {
            if (!(this.traceIndex.get(i) instanceof TimeTag)) continue;
            if (this.traceIndex.get(i).number() < number) break;
            right = (TimeTag)((Object)this.traceIndex.get(i));
        }
        if (right == null) {
            return null;
        }
        return TimeSpan.add(left.time(), TimeSpan.multiply(TimeSpan.diff(right.time(), left.time()), (double)(number - left.number()) / (double)(right.number() - left.number())));
    }

    public long getLastIndexBefore(TimeMoment time, boolean including) throws IllegalStateException, IndexOutOfBoundsException {
        TimeTag tag;
        assert (time != null) : "Argument 'time' must not be null.";
        assert (!this.traceIndex.isEmpty()) : "No trace index available. BlockTag list is empty!";
        TimeTag lastFix = null;
        for (BlockTag blockTag : this.traceIndex) {
            if (!(blockTag instanceof TimeTag)) continue;
            tag = (TimeTag)((Object)blockTag);
            if (!tag.time().before(time) && !tag.time().equals(time)) break;
            lastFix = tag;
        }
        if (lastFix == null) {
            throw new IllegalStateException("Trace index contains not enough time information!");
        }
        TimeTag nextFix = null;
        for (int i = this.traceIndex.size() - 1; i >= 0; --i) {
            if (!(this.traceIndex.get(i) instanceof TimeTag)) continue;
            tag = (TimeTag)((Object)this.traceIndex.get(i));
            if (!tag.time().after(time) && !tag.time().equals(time)) break;
            nextFix = tag;
        }
        if (nextFix == null) {
            throw new IllegalStateException("Trace index contains not enough time information!");
        }
        if (lastFix.equals(nextFix)) {
            if (including) {
                return lastFix.number();
            }
            return lastFix.number() - 1L;
        }
        double index = TimeSpan.divide(TimeSpan.diff(time, lastFix.time()), TimeSpan.diff(nextFix.time(), lastFix.time())) * (double)(nextFix.number() - lastFix.number()) + (double)lastFix.number();
        if (index > 9.223372036854776E18 || index < -9.223372036854776E18) {
            throw new IndexOutOfBoundsException("Ordinal number of the last sample before time " + time + " is #" + index + ", which cannot be represented by a 'long' variable!");
        }
        if (this.getFirstTimeTag().time().before(time)) {
            if (!including && index == Math.ceil(index)) {
                return Math.round(Math.floor(index)) - 1L;
            }
            return Math.round(Math.floor(index));
        }
        if (!including && index == Math.ceil(index)) {
            return Math.round(Math.floor(-index)) - 1L;
        }
        return Math.round(Math.floor(-index));
    }

    public long getFirstIndexAfter(TimeMoment time, boolean including) throws IllegalStateException, IndexOutOfBoundsException {
        TimeTag tag;
        assert (time != null) : "Argument 'time' must not be null.";
        assert (!this.traceIndex.isEmpty()) : "No trace index available. BlockTag list is empty!";
        TimeTag lastFix = null;
        for (BlockTag blockTag : this.traceIndex) {
            if (!(blockTag instanceof TimeTag)) continue;
            tag = (TimeTag)((Object)blockTag);
            if (!tag.time().before(time) && !tag.time().equals(time)) break;
            lastFix = tag;
        }
        if (lastFix == null) {
            throw new IllegalStateException("Trace index contains not enough time information!");
        }
        TimeTag nextFix = null;
        for (int i = this.traceIndex.size() - 1; i >= 0; --i) {
            if (!(this.traceIndex.get(i) instanceof TimeTag)) continue;
            tag = (TimeTag)((Object)this.traceIndex.get(i));
            if (!tag.time().after(time) && !tag.time().equals(time)) break;
            nextFix = tag;
        }
        if (nextFix == null) {
            throw new IllegalStateException("Trace index contains not enough time information!");
        }
        if (lastFix.equals(nextFix)) {
            if (including) {
                return lastFix.number();
            }
            return lastFix.number() + 1L;
        }
        double index = TimeSpan.divide(TimeSpan.diff(time, lastFix.time()), TimeSpan.diff(nextFix.time(), lastFix.time())) * (double)(nextFix.number() - lastFix.number()) + (double)lastFix.number();
        if (index > 9.223372036854776E18 || index < -9.223372036854776E18) {
            throw new IndexOutOfBoundsException("Ordinal number of the next sample after time " + time + " is #" + index + ", which cannot be represented by a 'long' variable!");
        }
        if (this.getFirstTimeTag().time().before(time)) {
            if (!including && index == Math.ceil(index)) {
                return Math.round(Math.ceil(index)) + 1L;
            }
            return Math.round(Math.ceil(index));
        }
        if (!including && index == Math.ceil(index)) {
            return Math.round(Math.ceil(-index)) + 1L;
        }
        return Math.round(Math.ceil(-index));
    }

    public long getClosestIndex(TimeMoment time) throws IllegalStateException, IndexOutOfBoundsException {
        TimeTag tag;
        assert (time != null) : "Argument 'time' must not be null.";
        assert (!this.traceIndex.isEmpty()) : "No trace index available. BlockTag list is empty!";
        TimeTag lastFix = null;
        for (BlockTag blockTag : this.traceIndex) {
            if (!(blockTag instanceof TimeTag)) continue;
            tag = (TimeTag)((Object)blockTag);
            if (!tag.time().before(time) && !tag.time().equals(time)) break;
            lastFix = tag;
        }
        if (lastFix == null) {
            throw new IllegalStateException("Trace index contains not enough time information!");
        }
        TimeTag nextFix = null;
        for (int i = this.traceIndex.size() - 1; i >= 0; --i) {
            if (!(this.traceIndex.get(i) instanceof TimeTag)) continue;
            tag = (TimeTag)((Object)this.traceIndex.get(i));
            if (!tag.time().after(time) && !tag.time().equals(time)) break;
            nextFix = tag;
        }
        if (nextFix == null) {
            throw new IllegalStateException("Trace index contains not enough time information!");
        }
        if (lastFix.equals(nextFix)) {
            return lastFix.number();
        }
        double index = TimeSpan.divide(TimeSpan.diff(time, lastFix.time()), TimeSpan.diff(nextFix.time(), lastFix.time())) * (double)(nextFix.number() - lastFix.number()) + (double)lastFix.number();
        if (index > 9.223372036854776E18 || index < -9.223372036854776E18) {
            throw new IndexOutOfBoundsException("Ordinal number of the sample closest to time " + time + " is #" + index + ", which cannot be represented by a 'long' variable!");
        }
        if (this.getFirstTimeTag().time().before(time)) {
            return Math.round(index);
        }
        return Math.round(-index);
    }

    public String getCubeFirmwareInfo() {
        assert (this.traceHeader != null);
        return this.traceHeader.firmwareVersionInfo();
    }

    public String getExperimentName() {
        assert (this.traceHeader != null);
        return this.traceHeader.experimentName();
    }

    public String getCubeName() {
        assert (this.traceHeader != null);
        return this.traceHeader.cubeName();
    }

    public TimeSpan getWnroCorrection() {
        assert (this.traceHeader != null);
        return this.traceHeader.wnroCorrection();
    }

    public List<Integer> getGainSetting() {
        assert (this.traceHeader != null);
        return this.traceHeader.channelGains();
    }

    public TimeSpan getSamplePeriod() {
        assert (this.traceHeader != null);
        return new TimeSpan.Builder().addSeconds(1.0 / (double)this.traceHeader.sampleRate()).build();
    }

    public int getSampleRate() {
        assert (this.traceHeader != null);
        return this.traceHeader.sampleRate();
    }

    public int getNumberOfChannels() {
        assert (this.traceHeader != null) : "Uninitialized 'traceHeader' variable!";
        return this.traceHeader.enabledChannels();
    }

    public long getNumberOfSamples() {
        assert (this.traceIndex != null) : "Uninitialized 'traceIndex'!";
        if (this.traceIndex.isEmpty()) {
            return 0L;
        }
        return this.traceIndex.get(this.traceIndex.size() - 1).number() - this.traceIndex.get(0).number() + 1L;
    }

    public String toString() {
        if (this.traceHeader == null) {
            return "empty / no data";
        }
        return "Cube '" + this.getCubeName() + "', last file segment '" + this.lastCubeFileNumber + "', time tags #" + this.getTimeTagCount() + ", samples #" + this.getNumberOfSamples();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lastCubeFileNumber;
        result = 31 * result + (this.traceHeader == null ? 0 : this.traceHeader.hashCode());
        result = 31 * result + (this.traceIndex == null ? 0 : this.traceIndex.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceInfo)) {
            return false;
        }
        TraceInfo other = (TraceInfo)obj;
        if (this.lastCubeFileNumber != other.lastCubeFileNumber) {
            return false;
        }
        if (this.traceHeader == null ? other.traceHeader != null : !this.traceHeader.equals(other.traceHeader)) {
            return false;
        }
        if (this.traceIndex == null) {
            return other.traceIndex == null;
        }
        return this.traceIndex.equals(other.traceIndex);
    }

    @Override
    public int compareTo(TraceInfo other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (!this.getCubeName().equals(other.getCubeName())) {
            return this.getCubeName().compareTo(other.getCubeName());
        }
        if (!this.getFirstTimeTag().time().equals(other.getFirstTimeTag().time())) {
            return this.getFirstTimeTag().time().compareTo(other.getFirstTimeTag().time());
        }
        return this.getLastTimeTag().time().compareTo(other.getLastTimeTag().time());
    }
}

