/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.BlockTag;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.FakeTimeBlockTagFilter;
import de.gfz_potsdam.gipp.common.seis.cube.LocalLeastSquaresBlockTagFilter;
import de.gfz_potsdam.gipp.common.seis.cube.RuleBasedBlockTagFilter;
import de.gfz_potsdam.gipp.common.seis.cube.TimeTag;
import de.gfz_potsdam.gipp.common.seis.cube.TraceInfo;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimingQualityUtils {
    private static final TimeSpan SUPERFLUOUS_TIMETAG_DISTANCE = new TimeSpan.Builder().addMinutes(1L).build();
    private static final Logger log = Logger.getLogger(TimingQualityUtils.class.getName());

    public static void qualityControl(TraceInfo traceInfo, QualityControlAlgorithm controlAlgorithm) {
        if (traceInfo == null) {
            throw new NullPointerException("Trace information is 'null'.");
        }
        if (controlAlgorithm == null) {
            throw new NullPointerException("Quality control algorithm is 'null'.");
        }
        int tagCount = traceInfo.getTimeTagCount();
        if (tagCount == 0 && controlAlgorithm != QualityControlAlgorithm.FAKE_TIME) {
            log.warning("Trace contains no valid time tags!");
            return;
        }
        log.info("Trace contains " + tagCount + " unchecked, raw data time tags.");
        if (log.isLoggable(Level.FINE)) {
            TimingQualityUtils.outputTimeTagTable(traceInfo.getIndex());
        }
        switch (controlAlgorithm) {
            case LOCAL_LEAST_SQUARES: {
                log.info("Starting \"local least squares\" quality control of the recorded time information.");
                LocalLeastSquaresBlockTagFilter llsFilter = new LocalLeastSquaresBlockTagFilter();
                traceInfo.setIndex(llsFilter.process(traceInfo.getIndex()));
                TimingQualityUtils.removeSuperfluousTimeTags(traceInfo.getIndex(), SUPERFLUOUS_TIMETAG_DISTANCE);
                break;
            }
            case RULE_BASED: {
                log.info("Starting \"rule based\" quality control of the recorded time information.");
                RuleBasedBlockTagFilter ruleFilter = new RuleBasedBlockTagFilter();
                traceInfo.setIndex(ruleFilter.process(traceInfo.getIndex()));
                TimingQualityUtils.removeSuperfluousTimeTags(traceInfo.getIndex(), SUPERFLUOUS_TIMETAG_DISTANCE);
                break;
            }
            case NONE: {
                log.info("Skipping any quality control of the recorded time information.");
                break;
            }
            case FAKE_TIME: {
                log.warning("Replacing all time information by a new fabricated \"fake\" time!");
                FakeTimeBlockTagFilter fakeFilter = new FakeTimeBlockTagFilter();
                traceInfo.setIndex(fakeFilter.process(traceInfo.getIndex()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Oops! The timing quality control method '" + (Object)((Object)controlAlgorithm) + "' was not implemented yet! Pleas choose a different one.");
            }
        }
        tagCount = traceInfo.getTimeTagCount();
        if (tagCount >= 2) {
            log.info("Finished quality control of the time information. " + tagCount + " time tags remain.");
        } else if (tagCount == 1) {
            log.info("Finished quality control of the time information. Only one time tag remains!");
        } else if (tagCount == 0) {
            log.warning("Finished quality control of the time information. Not a single time tag remains!");
        } else {
            throw new IllegalStateException("Impossible time tag count (" + tagCount + ") after quality control!");
        }
        if (log.isLoggable(Level.FINE)) {
            TimingQualityUtils.outputTimeTagTable(traceInfo.getIndex());
        }
    }

    private static void outputTimeTagTable(List<BlockTag> tagList) {
        assert (tagList != null);
        log.fine("--- begin of time tag table ---");
        for (BlockTag tag : tagList) {
            if (!(tag instanceof TimeTag)) continue;
            TimeMoment tagTime = ((TimeTag)((Object)tag)).time();
            log.fine(String.format("%10d\t%04d-%02d-%02dT%02d:%02d:%02d.%09d", tag.number(), tagTime.getYear(), tagTime.getMonth(), tagTime.getDay(), tagTime.getHour(), tagTime.getMinute(), tagTime.getSecond(), tagTime.getNanoSecond()));
        }
        log.fine("--- end of time tag table ---");
    }

    private static int removeSuperfluousTimeTags(List<BlockTag> tagList, TimeSpan minimal) {
        int removed = 0;
        TimeTag firstTag = CubeUtils.getFirstTimeTag(tagList);
        ListIterator<BlockTag> iter = tagList.listIterator(tagList.size());
        TimeTag nextTag = CubeUtils.getPreviousTimeTag(iter);
        TimeTag prevTag = CubeUtils.getPreviousTimeTag(iter);
        if (prevTag == null || nextTag == null) {
            return 0;
        }
        while (prevTag != null && prevTag != firstTag) {
            TimeSpan delta = TimeSpan.diff(prevTag.time(), nextTag.time());
            if (delta.compareTo(minimal) < 0) {
                iter.remove();
                ++removed;
                prevTag = CubeUtils.getPreviousTimeTag(iter);
                continue;
            }
            nextTag = prevTag;
            prevTag = CubeUtils.getPreviousTimeTag(iter);
        }
        log.info("Removed " + String.format("%8d", removed) + " superfluous time tags.");
        return removed;
    }

    public static enum QualityControlAlgorithm {
        LOCAL_LEAST_SQUARES,
        RULE_BASED,
        NONE,
        FAKE_TIME;

    }
}

