/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.BinaryBlock;
import de.gfz_potsdam.gipp.common.seis.cube.CubeException;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import java.io.Serializable;

public class TemperatureBlock
extends BinaryBlock
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CONTENT_LENGTH = 3;
    private static final int SIGN_MASK = 0x100000;

    public TemperatureBlock() {
        super(3);
    }

    TemperatureBlock(int[] data) {
        super(data);
    }

    public double getTemperature() {
        if (this.content.isEmpty()) {
            throw new CubeException("No temperature is available yet! Please read/parse a temperature block first.");
        }
        if (this.content.size() != 3) {
            throw new IntegrityException("Expected a block size of 4 bytes but got " + (this.content.size() + 1) + ".");
        }
        int counts = ((((Byte)this.content.get(0) & 0x7F) << 14 | ((Byte)this.content.get(1) & 0x7F) << 7 | (Byte)this.content.get(2) & 0x7F) ^ 0x100000) - 0x100000;
        return (double)counts / 100.0;
    }

    @Override
    public String toString() {
        if (this.content.isEmpty()) {
            return "--unread-temperature-block--";
        }
        return StringUtils.roundedNumber(this.getTemperature(), 2, 2) + " Celsius";
    }
}

