/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.geo.LatLonPoint;
import de.gfz_potsdam.gipp.common.seis.cube.InfoBlock;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.ExpiredLeapSecondInfoException;
import de.gfz_potsdam.gipp.common.time.InvalidDateException;
import de.gfz_potsdam.gipp.common.time.InvalidLeapSecondInfoException;
import de.gfz_potsdam.gipp.common.time.LeapSecondInfo;
import de.gfz_potsdam.gipp.common.time.ParserException;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;

public class TaipBlock
extends InfoBlock {
    private static final long serialVersionUID = 3L;
    private static final TimeSpan CSAC_TICK = TimeSpan.SECOND.divide(57600.0);
    private static final Pattern ATM_PATTERN = Pattern.compile(">ATM.*?<", 32);
    private static final Pattern MTM_PATTERN = Pattern.compile(">MTM.*?<", 32);
    private static final Pattern RTM_PATTERN = Pattern.compile(">RTM.*?<", 32);
    private static final Pattern TTM_PATTERN = Pattern.compile(">TTM.*?<", 32);
    private static final Pattern ZTM_PATTERN = Pattern.compile(">ZTM.*?<", 32);
    private static final Pattern APV_PATTERN = Pattern.compile(">APV.*?<", 32);
    private static final Pattern MPV_PATTERN = Pattern.compile(">MPV.*?<", 32);
    private static final Pattern RPV_PATTERN = Pattern.compile(">RPV.*?<", 32);
    private static final Pattern TPV_PATTERN = Pattern.compile(">TPV.*?<", 32);
    private static final Pattern XPV_PATTERN = Pattern.compile(">XPV.*?<", 32);
    private static final Pattern ZPV_PATTERN = Pattern.compile(">ZPV.*?<", 32);
    transient boolean pvParsed;
    transient boolean tmParsed;
    private transient TimeMoment utcTime;
    private transient String gpsTime;
    private transient Integer sourceGpsUtcOffset;
    private transient Integer appliedGpsUtcOffset;
    private transient LatLonPoint cubePosition;
    private transient Double cubeElevation;
    private transient Boolean isFresh;
    private transient Integer satellitesUsed;
    private transient String clockSource;
    private transient Double cubeTemperature;
    private transient Integer ubloxStatus1;
    private transient Integer ubloxStatus2;
    private transient Long csacUseTime;
    private transient Short csacMode;
    private transient Byte csacStatus;
    private transient Short csacAlarm;
    private transient TimeSpan csacPpsShift;

    public TaipBlock() {
        this.resetCacheTM();
        this.resetCachePV();
    }

    protected TaipBlock(String message) {
        super(message);
        this.resetCacheTM();
        this.resetCachePV();
    }

    @Override
    public int write(DataOutput stream) throws IOException {
        return this.write(stream, 160);
    }

    protected static boolean verifyTrimbleMessage(String msg) {
        if (msg == null) {
            return false;
        }
        if (msg.length() <= 5) {
            return false;
        }
        if (!msg.startsWith(">")) {
            return false;
        }
        if (!msg.endsWith("<")) {
            return false;
        }
        int checkPos = msg.indexOf(";*");
        if (checkPos != -1) {
            byte actual = 0;
            for (int i = 0; i < checkPos + 2; ++i) {
                actual = (byte)(actual ^ (byte)(msg.charAt(i) & 0xFF));
            }
            byte expected = Byte.parseByte(msg.substring(checkPos + 2, checkPos + 4), 16);
            return actual == expected;
        }
        return true;
    }

    public static String buildGpsDateTimeString(int year, int month, int day, int hour, int minute, int second, int offsetUtcGps) {
        second += offsetUtcGps;
        while (second > 59) {
            second -= 60;
            ++minute;
        }
        while (second < 0) {
            second += 60;
            --minute;
        }
        while (minute > 59) {
            minute -= 60;
            ++hour;
        }
        while (minute < 0) {
            minute += 60;
            --hour;
        }
        while (hour > 23) {
            hour -= 24;
            ++day;
        }
        while (hour < 0) {
            hour += 24;
            --day;
        }
        int daysInMonth = TimeMoment.getNumberOfDaysInMonth(year, month);
        while (day > daysInMonth) {
            day -= daysInMonth;
            ++month;
        }
        while (day < 1) {
            day += daysInMonth;
            --month;
        }
        while (month > 12) {
            month -= 12;
            ++year;
        }
        while (month < 1) {
            month += 12;
            --year;
        }
        return StringUtils.FOUR_DIGITS.format(year) + '-' + StringUtils.TWO_DIGITS.format(month) + '-' + StringUtils.TWO_DIGITS.format(day) + 'T' + StringUtils.TWO_DIGITS.format(hour) + ':' + StringUtils.TWO_DIGITS.format(minute) + ':' + StringUtils.TWO_DIGITS.format(second);
    }

    void resetCacheTM() {
        this.tmParsed = false;
        this.utcTime = null;
        this.gpsTime = null;
        this.sourceGpsUtcOffset = null;
        this.appliedGpsUtcOffset = null;
        this.satellitesUsed = null;
        this.clockSource = null;
        this.ubloxStatus1 = null;
        this.ubloxStatus2 = null;
    }

    void resetCachePV() {
        this.pvParsed = false;
        this.isFresh = null;
        this.cubePosition = null;
        this.cubeElevation = null;
        this.cubeTemperature = null;
        this.csacUseTime = null;
        this.csacMode = null;
        this.csacStatus = null;
        this.csacAlarm = null;
        this.csacPpsShift = null;
    }

    private Boolean convertDataAgeIndicator(int ageIndicator) {
        switch (ageIndicator) {
            case 2: {
                return Boolean.TRUE;
            }
            case 1: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private String convertGnssFixType(int fixType, String fixSource) {
        switch (fixType) {
            case 0: {
                return "2D-" + fixSource;
            }
            case 1: {
                return "3D-" + fixSource;
            }
            case 2: {
                return "2D-differential-" + fixSource;
            }
            case 3: {
                return "3D-differential-" + fixSource;
            }
            case 6: {
                return "DR";
            }
            case 8: {
                return "degraded-DR";
            }
        }
        return "unknown";
    }

    private void parseAPV(String msg) throws NumberFormatException {
        this.resetCachePV();
        long count = Long.parseLong(msg.substring(4, 14));
        short mode = Short.parseShort(msg.substring(14, 18), 16);
        byte status = Byte.parseByte(msg.substring(18, 19));
        short alarm = Short.parseShort(msg.substring(19, 23), 16);
        int shift = Integer.parseInt(msg.substring(23, 28));
        String unused = msg.substring(28, 33);
        int age = Integer.parseInt(msg.substring(33, 34));
        assert (age == 2) : "Atomic clock claims that it is not up-to-date!";
        this.isFresh = this.convertDataAgeIndicator(age);
        this.csacUseTime = count;
        this.csacMode = mode;
        this.csacStatus = status;
        this.csacAlarm = alarm;
        this.csacPpsShift = CSAC_TICK.multiply(shift);
        this.pvParsed = true;
    }

    private void parseMPV(String msg) throws NumberFormatException, IntegrityException {
        this.resetCachePV();
        double temp = Double.parseDouble(msg.substring(4, 9));
        double lat = Double.parseDouble(msg.substring(9, 17)) / 100000.0;
        double lon = Double.parseDouble(msg.substring(17, 26)) / 100000.0;
        double height = Double.parseDouble(msg.substring(26, 32));
        int source = Integer.parseInt(msg.substring(32, 33));
        int age = Integer.parseInt(msg.substring(33, 34));
        if (lat > 90.0 || lat < -90.0) {
            throw new IntegrityException("Impossible latitude value! (" + lat + " degree)");
        }
        if (lon > 180.0 || lon < -180.0) {
            throw new IntegrityException("Impossible longitude value! (" + lon + " degree)");
        }
        this.isFresh = this.convertDataAgeIndicator(age);
        this.cubeTemperature = temp;
        this.cubePosition = new LatLonPoint(lat, lon);
        this.cubeElevation = height;
        this.pvParsed = true;
    }

    private void parseRPV(String msg) throws IntegrityException, NumberFormatException {
        this.resetCachePV();
        int secOfDay = Integer.parseInt(msg.substring(4, 9));
        double lat = Double.parseDouble(msg.substring(9, 17)) / 100000.0;
        double lon = Double.parseDouble(msg.substring(17, 26)) / 100000.0;
        int mph = Integer.parseInt(msg.substring(26, 29));
        int heading = Integer.parseInt(msg.substring(29, 32));
        int source = Integer.parseInt(msg.substring(32, 33));
        int age = Integer.parseInt(msg.substring(33, 34));
        if (lat > 90.0 || lat < -90.0) {
            throw new IntegrityException("Impossible latitude value! (" + lat + " degree)");
        }
        if (lon > 180.0 || lon < -180.0) {
            throw new IntegrityException("Impossible longitude value! (" + lon + " degree)");
        }
        this.isFresh = this.convertDataAgeIndicator(age);
        this.cubePosition = new LatLonPoint(lat, lon);
        this.pvParsed = true;
    }

    private void parseTPV(String msg) throws NumberFormatException {
        this.resetCachePV();
        String unused = msg.substring(4, 32);
        int source = Integer.parseInt(msg.substring(32, 33));
        int age = Integer.parseInt(msg.substring(33, 34));
        assert (age == 2) : "GNSS simulator claims it is not up-to-date!";
        this.isFresh = this.convertDataAgeIndicator(age);
        this.pvParsed = true;
    }

    private void parseXPV(String msg) throws NumberFormatException, IntegrityException {
        this.resetCachePV();
        double temp = Double.parseDouble(msg.substring(4, 9));
        double lat = Double.parseDouble(msg.substring(9, 17)) / 100000.0;
        double lon = Double.parseDouble(msg.substring(17, 26)) / 100000.0;
        double height = Double.parseDouble(msg.substring(26, 32));
        int source = Integer.parseInt(msg.substring(32, 33));
        int age = Integer.parseInt(msg.substring(33, 34));
        if (lat > 90.0 || lat < -90.0) {
            throw new IntegrityException("Impossible latitude value! (" + lat + " degree)");
        }
        if (lon > 180.0 || lon < -180.0) {
            throw new IntegrityException("Impossible longitude value! (" + lon + " degree)");
        }
        this.isFresh = this.convertDataAgeIndicator(age);
        this.cubeTemperature = temp;
        this.cubePosition = new LatLonPoint(lat, lon);
        this.cubeElevation = height;
        this.pvParsed = true;
    }

    private void parseZPV(String msg) throws NumberFormatException {
        this.resetCachePV();
        int age = Integer.parseInt(msg.substring(33, 34));
        this.isFresh = this.convertDataAgeIndicator(age);
        this.pvParsed = true;
    }

    private void parsePositionMessage() throws IntegrityException {
        block8: {
            String msg = null;
            try {
                msg = this.getContent(XPV_PATTERN);
                if (msg != null && TaipBlock.verifyTrimbleMessage(msg)) {
                    this.parseXPV(msg);
                    break block8;
                }
                msg = this.getContent(MPV_PATTERN);
                if (msg != null && TaipBlock.verifyTrimbleMessage(msg)) {
                    this.parseMPV(msg);
                    break block8;
                }
                msg = this.getContent(RPV_PATTERN);
                if (msg != null && TaipBlock.verifyTrimbleMessage(msg)) {
                    this.parseRPV(msg);
                    break block8;
                }
                msg = this.getContent(APV_PATTERN);
                if (msg != null && TaipBlock.verifyTrimbleMessage(msg)) {
                    this.parseAPV(msg);
                    break block8;
                }
                msg = this.getContent(TPV_PATTERN);
                if (msg != null && TaipBlock.verifyTrimbleMessage(msg)) {
                    this.parseTPV(msg);
                    break block8;
                }
                msg = this.getContent(ZPV_PATTERN);
                if (msg != null && TaipBlock.verifyTrimbleMessage(msg)) {
                    this.parseZPV(msg);
                    break block8;
                }
                this.resetCachePV();
                throw new IntegrityException("Could not find valid \"position\" message in TAIP string '" + this.content + "'.");
            }
            catch (NumberFormatException e) {
                this.resetCachePV();
                throw new IntegrityException("Could not parse TAIP message '" + msg + "'!");
            }
        }
    }

    private void parseATM(String msg) throws NumberFormatException, IntegrityException {
        this.resetCacheTM();
        int hour = Integer.parseInt(msg.substring(4, 6));
        int minute = Integer.parseInt(msg.substring(6, 8));
        int second = Integer.parseInt(msg.substring(8, 10));
        int millisec = Integer.parseInt(msg.substring(10, 13));
        int day = Integer.parseInt(msg.substring(13, 15));
        int month = Integer.parseInt(msg.substring(15, 17));
        int year = Integer.parseInt(msg.substring(17, 21));
        int offset = Integer.parseInt(msg.substring(21, 23));
        int gpsFix = Integer.parseInt(msg.substring(23, 24));
        int satCount = Integer.parseInt(msg.substring(24, 26));
        int utcFlag = Integer.parseInt(msg.substring(26, 27));
        int reserved = Integer.parseInt(msg.substring(27, 32));
        if (utcFlag != 1) {
            throw new IntegrityException("Atomic clock is not UTC based! Synchronization problem?");
        }
        this.utcTime = new TimeMoment.Builder().date(year, month, day).time(hour, minute, second).build();
        this.sourceGpsUtcOffset = offset;
        this.appliedGpsUtcOffset = offset;
        this.clockSource = "chip-scale-atomic-clock";
        this.tmParsed = true;
    }

    private void parseMTM(String msg) throws NumberFormatException, IntegrityException {
        this.resetCacheTM();
        int hour = Integer.parseInt(msg.substring(4, 6));
        int minute = Integer.parseInt(msg.substring(6, 8));
        int second = Integer.parseInt(msg.substring(8, 10));
        int millisecs = Integer.parseInt(msg.substring(10, 13));
        int day = Integer.parseInt(msg.substring(13, 15));
        int month = Integer.parseInt(msg.substring(15, 17));
        int year = Integer.parseInt(msg.substring(17, 21));
        int offset = Integer.parseInt(msg.substring(21, 23));
        int gpsFix = Integer.parseInt(msg.substring(23, 24));
        int satCount = Integer.parseInt(msg.substring(24, 26));
        int utcFlag = Integer.parseInt(msg.substring(26, 27));
        char board = msg.charAt(27);
        String unused = msg.substring(28, 30);
        int ublox1 = msg.charAt(30) & 0xFF;
        int ublox2 = msg.charAt(31) & 0xFF;
        if (utcFlag != 1) {
            throw new IntegrityException("GNSS receiver returned an unexpected non-UTC based time!");
        }
        this.utcTime = new TimeMoment.Builder().date(year, month, day).time(hour, minute, second).build();
        this.sourceGpsUtcOffset = offset;
        this.appliedGpsUtcOffset = offset;
        this.satellitesUsed = satCount;
        this.ubloxStatus1 = ublox1;
        this.ubloxStatus2 = ublox2;
        switch (Character.toUpperCase(board)) {
            case 'I': {
                this.clockSource = this.convertGnssFixType(gpsFix, "GNSS-internal-antenna");
                break;
            }
            case 'E': {
                this.clockSource = this.convertGnssFixType(gpsFix, "GNSS-external-antenna");
                break;
            }
            default: {
                this.clockSource = this.convertGnssFixType(gpsFix, "GNSS");
            }
        }
        this.tmParsed = true;
    }

    private void parseRTM(String msg) throws NumberFormatException, InvalidLeapSecondInfoException, ExpiredLeapSecondInfoException, InvalidDateException, ParserException {
        this.resetCacheTM();
        int hour = Integer.parseInt(msg.substring(4, 6));
        int minute = Integer.parseInt(msg.substring(6, 8));
        int second = Integer.parseInt(msg.substring(8, 10));
        int millisec = Integer.parseInt(msg.substring(10, 13));
        int day = Integer.parseInt(msg.substring(13, 15));
        int month = Integer.parseInt(msg.substring(15, 17));
        int year = Integer.parseInt(msg.substring(17, 21));
        int offset = Integer.parseInt(msg.substring(21, 23));
        int gpsFix = Integer.parseInt(msg.substring(23, 24));
        int satCount = Integer.parseInt(msg.substring(24, 26));
        int utcFlag = Integer.parseInt(msg.substring(26, 27));
        int reserved = Integer.parseInt(msg.substring(27, 32));
        this.gpsTime = utcFlag == 1 ? TaipBlock.buildGpsDateTimeString(year, month, day, hour, minute, second, offset) : TaipBlock.buildGpsDateTimeString(year, month, day, hour, minute, second, 0);
        int iersOffset = LeapSecondInfo.getGpsUtcOffset(this.gpsTime);
        this.utcTime = TimeSpan.subtract(TimeMoment.parse(this.gpsTime), TimeSpan.SECOND.multiply(iersOffset));
        this.clockSource = this.convertGnssFixType(gpsFix, "GPS");
        this.sourceGpsUtcOffset = offset;
        this.appliedGpsUtcOffset = iersOffset;
        this.satellitesUsed = satCount;
        this.tmParsed = true;
    }

    private void parseTTM(String msg) throws IntegrityException, NumberFormatException {
        this.resetCacheTM();
        int hour = Integer.parseInt(msg.substring(4, 6));
        int minute = Integer.parseInt(msg.substring(6, 8));
        int second = Integer.parseInt(msg.substring(8, 10));
        int millisec = Integer.parseInt(msg.substring(10, 13));
        int day = Integer.parseInt(msg.substring(13, 15));
        int month = Integer.parseInt(msg.substring(15, 17));
        int year = Integer.parseInt(msg.substring(17, 21));
        int offset = Integer.parseInt(msg.substring(21, 23));
        int utcFlag = Integer.parseInt(msg.substring(26, 27));
        if (utcFlag != 1) {
            throw new IntegrityException("GNSS simulator time is not UTC based!");
        }
        this.utcTime = new TimeMoment.Builder().date(year, month, day).time(hour, minute, second).build();
        this.sourceGpsUtcOffset = offset;
        this.clockSource = "gnss-simulator";
        this.tmParsed = true;
    }

    private void parseZTM(String msg) throws NumberFormatException, InvalidLeapSecondInfoException, ExpiredLeapSecondInfoException, InvalidDateException, ParserException {
        this.resetCacheTM();
        int hour = Integer.parseInt(msg.substring(4, 6));
        int minute = Integer.parseInt(msg.substring(6, 8));
        int second = Integer.parseInt(msg.substring(8, 10));
        int day = Integer.parseInt(msg.substring(13, 15));
        int month = Integer.parseInt(msg.substring(15, 17));
        int year = Integer.parseInt(msg.substring(17, 21));
        int offset = Integer.parseInt(msg.substring(21, 23));
        int utcFlag = Integer.parseInt(msg.substring(26, 27));
        if (offset == 0 && utcFlag == 0) {
            this.gpsTime = TaipBlock.buildGpsDateTimeString(year, month, day, hour, minute, second, 0);
            int iersOffset = LeapSecondInfo.getGpsUtcOffset(this.gpsTime);
            this.utcTime = TimeSpan.subtract(TimeMoment.parse(this.gpsTime), TimeSpan.SECOND.multiply(iersOffset));
            this.sourceGpsUtcOffset = offset;
            this.appliedGpsUtcOffset = iersOffset;
        } else if (offset == 0 && utcFlag == 1) {
            this.utcTime = new TimeMoment.Builder().date(year, month, day).time(hour, minute, second).build();
        } else if (offset != 0 && utcFlag == 0) {
            this.gpsTime = TaipBlock.buildGpsDateTimeString(year, month, day, hour, minute, second, 0);
            this.utcTime = TimeSpan.subtract(TimeMoment.parse(this.gpsTime), TimeSpan.SECOND.multiply(offset));
            this.sourceGpsUtcOffset = offset;
            this.appliedGpsUtcOffset = offset;
        } else if (offset != 0 && utcFlag == 1) {
            this.utcTime = new TimeMoment.Builder().date(year, month, day).time(hour, minute, second).build();
            this.sourceGpsUtcOffset = offset;
            this.appliedGpsUtcOffset = offset;
        }
        this.clockSource = "experimental";
        this.tmParsed = true;
    }

    private void parseTimeMessage() throws IntegrityException, TimeException {
        block7: {
            String msg = null;
            try {
                msg = this.getContent(RTM_PATTERN);
                if (msg != null && TaipBlock.verifyTrimbleMessage(msg)) {
                    this.parseRTM(msg);
                    break block7;
                }
                msg = this.getContent(MTM_PATTERN);
                if (msg != null && TaipBlock.verifyTrimbleMessage(msg)) {
                    this.parseMTM(msg);
                    break block7;
                }
                msg = this.getContent(ATM_PATTERN);
                if (msg != null && TaipBlock.verifyTrimbleMessage(msg)) {
                    this.parseATM(msg);
                    break block7;
                }
                msg = this.getContent(TTM_PATTERN);
                if (msg != null && TaipBlock.verifyTrimbleMessage(msg)) {
                    this.parseTTM(msg);
                    break block7;
                }
                msg = this.getContent(ZTM_PATTERN);
                if (msg != null && TaipBlock.verifyTrimbleMessage(msg)) {
                    this.parseZTM(msg);
                    break block7;
                }
                this.resetCacheTM();
                throw new IntegrityException("Could not find valid \"time/date\" message in TAIP string '" + this.content + "'.");
            }
            catch (NumberFormatException e) {
                this.resetCachePV();
                throw new IntegrityException("Could not parse TAIP message '" + msg + "'!");
            }
        }
    }

    @Override
    public int read(ByteBuffer buffer) throws BufferUnderflowException {
        this.resetCachePV();
        this.resetCacheTM();
        return super.read(buffer);
    }

    @Override
    public int read(DataInput source) throws IOException {
        this.resetCachePV();
        this.resetCacheTM();
        return super.read(source);
    }

    public TimeMoment getTime() throws IntegrityException, TimeException {
        if (!this.tmParsed) {
            this.parseTimeMessage();
        }
        return this.utcTime;
    }

    public String getGpsDateTimeInfo() throws IntegrityException, TimeException {
        if (!this.tmParsed) {
            this.parseTimeMessage();
        }
        return this.gpsTime;
    }

    public Integer getSourceOffset() throws IntegrityException, TimeException {
        if (!this.tmParsed) {
            this.parseTimeMessage();
        }
        return this.sourceGpsUtcOffset;
    }

    public Integer getAppliedOffset() throws IntegrityException, TimeException {
        if (!this.tmParsed) {
            this.parseTimeMessage();
        }
        return this.appliedGpsUtcOffset;
    }

    public LatLonPoint getPosition() throws IntegrityException {
        if (!this.pvParsed) {
            this.parsePositionMessage();
        }
        return this.cubePosition;
    }

    public Double getElevation() throws IntegrityException {
        if (!this.pvParsed) {
            this.parsePositionMessage();
        }
        return this.cubeElevation;
    }

    public Boolean isUpToDate() throws IntegrityException {
        if (!this.pvParsed) {
            this.parsePositionMessage();
        }
        return this.isFresh;
    }

    public Integer getNumOfSatellites() throws IntegrityException, TimeException {
        if (!this.tmParsed) {
            this.parseTimeMessage();
        }
        return this.satellitesUsed;
    }

    public boolean isValid() throws IntegrityException, TimeException {
        if (this.isUpToDate() == null || !this.isUpToDate().booleanValue()) {
            return false;
        }
        return this.getNumOfSatellites() == null || this.getNumOfSatellites() > 0;
    }

    public String getClockSource() throws IntegrityException, TimeException {
        if (!this.tmParsed) {
            this.parseTimeMessage();
        }
        return this.clockSource;
    }

    public Double getTemperature() throws IntegrityException {
        if (!this.pvParsed) {
            this.parsePositionMessage();
        }
        return this.cubeTemperature;
    }

    public String getUbloxStatus() {
        if (!this.pvParsed) {
            this.parsePositionMessage();
        }
        if (this.ubloxStatus1 == null || this.ubloxStatus2 == null) {
            return null;
        }
        assert (0 <= this.ubloxStatus1 && this.ubloxStatus1 <= 255);
        assert (0 <= this.ubloxStatus2 && this.ubloxStatus2 <= 255);
        return StringUtils.toHexString(this.ubloxStatus1.intValue(), 2) + '-' + StringUtils.toHexString(this.ubloxStatus2.intValue(), 2);
    }

    public Long getCsacUseTime() throws IntegrityException {
        if (!this.pvParsed) {
            this.parsePositionMessage();
        }
        return this.csacUseTime;
    }

    public Short getCsacMode() throws IntegrityException {
        if (!this.pvParsed) {
            this.parsePositionMessage();
        }
        return this.csacMode;
    }

    public Byte getCsacStatus() throws IntegrityException {
        if (!this.pvParsed) {
            this.parsePositionMessage();
        }
        return this.csacStatus;
    }

    public Short getCsacAlarm() throws IntegrityException {
        if (!this.pvParsed) {
            this.parsePositionMessage();
        }
        return this.csacAlarm;
    }

    public TimeSpan getCsacPpsShift() throws IntegrityException {
        if (!this.pvParsed) {
            this.parsePositionMessage();
        }
        return this.csacPpsShift;
    }
}

