/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.BinaryBlock;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public class SystemEventBlock
extends BinaryBlock
implements Serializable {
    private static final long serialVersionUID = 1L;

    public SystemEventBlock() {
    }

    public SystemEventBlock(int[] data) {
        super(data);
    }

    public int write(DataOutput stream) throws IOException {
        return this.write(stream, 192);
    }

    @Override
    public String toString() {
        if (this.content.isEmpty()) {
            return "--unread-system-event-block--";
        }
        StringBuilder hex = new StringBuilder();
        for (int index = 0; index < this.content.size(); ++index) {
            hex.append("0x").append(StringUtils.toHexString((Byte)this.content.get(index)));
            if (index == this.content.size() - 1) continue;
            hex.append(' ');
        }
        StringBuilder human = new StringBuilder();
        if (this.ringBufferOverrunIsOn()) {
            human.append("Ring buffer overrun");
            switch (this.content.size()) {
                case 3: {
                    int count = (((Byte)this.content.get(1) & 0x7F) << 7) + ((Byte)this.content.get(2) & 0x7F);
                    human.append(" (Approx. ").append(count).append(" samples missing!)");
                    break;
                }
                case 4: {
                    int count = (((Byte)this.content.get(2) & 0x7F) << 7) + ((Byte)this.content.get(3) & 0x7F);
                    human.append(" (Approx. ").append(count).append(" samples missing!)");
                    break;
                }
            }
        }
        if (this.gpsIsOn()) {
            if (human.length() == 0) {
                human.append("GPS on");
            } else {
                human.append(", GPS on");
            }
        }
        if (this.gpsIsOff()) {
            if (human.length() == 0) {
                human.append("GPS off");
            } else {
                human.append(", GPS off");
            }
        }
        if (this.pulseIsOn()) {
            if (human.length() == 0) {
                human.append("Pulse on");
            } else {
                human.append(", pulse on");
            }
        }
        if (this.pulseIsOff()) {
            if (human.length() == 0) {
                human.append("Pulse off");
            } else {
                human.append(", pulse off");
            }
        }
        if (this.debugIsOn()) {
            if (human.length() == 0) {
                human.append("Debug mark");
            } else {
                human.append(", debug mark");
            }
        }
        if (human.length() == 0) {
            human.append("--no-event-indicated--");
        }
        return "(" + hex + ")  " + human;
    }

    public boolean gpsIsOn() {
        switch (this.content.size()) {
            case 0: 
            case 1: 
            case 3: {
                return false;
            }
        }
        return EventFlag.GPS_ON.isSet((Byte)this.content.get(0), (Byte)this.content.get(1));
    }

    public boolean gpsIsOff() {
        switch (this.content.size()) {
            case 0: 
            case 1: 
            case 3: {
                return false;
            }
        }
        return EventFlag.GPS_OFF.isSet((Byte)this.content.get(0), (Byte)this.content.get(1));
    }

    public boolean pulseIsOn() {
        switch (this.content.size()) {
            case 0: 
            case 1: 
            case 3: {
                return false;
            }
        }
        return EventFlag.PULSE_ON.isSet((Byte)this.content.get(0), (Byte)this.content.get(1));
    }

    public boolean pulseIsOff() {
        switch (this.content.size()) {
            case 0: 
            case 1: 
            case 3: {
                return false;
            }
        }
        return EventFlag.PULSE_OFF.isSet((Byte)this.content.get(0), (Byte)this.content.get(1));
    }

    public boolean debugIsOn() {
        switch (this.content.size()) {
            case 0: 
            case 1: 
            case 3: {
                return false;
            }
        }
        return EventFlag.DEBUG.isSet((Byte)this.content.get(0), (Byte)this.content.get(1));
    }

    public boolean ringBufferOverrunIsOn() {
        switch (this.content.size()) {
            case 0: {
                return false;
            }
            case 1: {
                return EventFlag.RING_BUFFER_OVERRUN_ERROR.isSet((Byte)this.content.get(0), (byte)0);
            }
        }
        return EventFlag.RING_BUFFER_OVERRUN_ERROR.isSet((Byte)this.content.get(0), (Byte)this.content.get(1));
    }

    public int numberOfMissingSamples() {
        int count;
        if (!this.ringBufferOverrunIsOn()) {
            return -1;
        }
        switch (this.content.size()) {
            case 0: 
            case 1: 
            case 2: {
                count = 0;
                break;
            }
            case 3: {
                count = (((Byte)this.content.get(1) & 0x7F) << 7) + ((Byte)this.content.get(2) & 0x7F);
                break;
            }
            case 4: {
                count = (((Byte)this.content.get(2) & 0x7F) << 7) + ((Byte)this.content.get(3) & 0x7F);
                break;
            }
            default: {
                count = -9;
            }
        }
        return count;
    }

    private static final class EventFlag
    extends Enum<EventFlag> {
        public static final /* enum */ EventFlag GPS_ON = new EventFlag(0, 1);
        public static final /* enum */ EventFlag GPS_OFF = new EventFlag(0, 2);
        public static final /* enum */ EventFlag PULSE_ON = new EventFlag(0, 4);
        public static final /* enum */ EventFlag PULSE_OFF = new EventFlag(0, 8);
        public static final /* enum */ EventFlag DEBUG = new EventFlag(0, 64);
        public static final /* enum */ EventFlag RING_BUFFER_OVERRUN_ERROR = new EventFlag(1, 0);
        private final int hiMask;
        private final int loMask;
        private static final /* synthetic */ EventFlag[] $VALUES;

        public static EventFlag[] values() {
            return (EventFlag[])$VALUES.clone();
        }

        public static EventFlag valueOf(String name) {
            return Enum.valueOf(EventFlag.class, name);
        }

        private EventFlag(int hiByte, int loByte) {
            this.hiMask = hiByte;
            this.loMask = loByte;
        }

        private boolean isSet(Byte hiByte, Byte loByte) {
            assert (hiByte != null) : "hiByte argument must not be null!";
            assert (loByte != null) : "loByte argument must not be null!";
            if ((hiByte & 0x80) == 128 || (loByte & 0x80) == 128) {
                throw new IntegrityException("Cube block type flag detected where only data was expected!");
            }
            int hiStatus = 0xFF & hiByte;
            int loStatus = 0xFF & loByte;
            return (hiStatus & this.hiMask) == this.hiMask && (loStatus & this.loMask) == this.loMask;
        }

        static {
            $VALUES = new EventFlag[]{GPS_ON, GPS_OFF, PULSE_ON, PULSE_OFF, DEBUG, RING_BUFFER_OVERRUN_ERROR};
        }
    }
}

