/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.BlockTag;
import de.gfz_potsdam.gipp.common.seis.cube.BlockTagFilter;
import de.gfz_potsdam.gipp.common.seis.cube.RecordedTimeTag;
import de.gfz_potsdam.gipp.common.seis.cube.TimeTag;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class RuleBasedBlockTagFilter
implements BlockTagFilter {
    private static final TimeSpan VALID_PPS_LOWER_LIMIT = new TimeSpan.Builder().addSeconds(0.5).build();
    private static final TimeSpan VALID_PPS_UPPER_LIMIT = new TimeSpan.Builder().addSeconds(1.5).build();
    private static final int POWER_ON_IGNORE_TIMETAGS = 20;
    private static final Logger log = Logger.getLogger(RuleBasedBlockTagFilter.class.getName());

    public static TimeSpan gap(TimeTag left, TimeTag right, int rate) {
        assert (left != null) : "Argument 'left' may not be null!";
        assert (right != null) : "Argument 'right' must not be null!";
        assert (rate > 0) : "Sample rate must be positive!";
        TimeSpan delta = new TimeSpan.Builder().addSeconds((double)(right.number() - left.number()) / (double)rate).build();
        TimeMoment expected = TimeSpan.add(left.time(), delta);
        TimeSpan diff = TimeSpan.diff(expected, right.time());
        return diff;
    }

    public static int removeGpsWarmupTimeTags(List<BlockTag> tagList) {
        return RuleBasedBlockTagFilter.removeGpsWarmupTimeTags(tagList, VALID_PPS_UPPER_LIMIT, 20);
    }

    public static int removeGpsWarmupTimeTags(List<BlockTag> tagList, TimeSpan gap, int ignore) {
        assert (tagList != null);
        assert (gap != null);
        assert (ignore >= 0);
        ListIterator<BlockTag> iter = tagList.listIterator();
        RecordedTimeTag baseTag = null;
        RecordedTimeTag nextTag = null;
        int removed = 0;
        int counter = -1;
        while (iter.hasNext()) {
            BlockTag tag = iter.next();
            if (!(tag instanceof RecordedTimeTag)) continue;
            baseTag = nextTag;
            nextTag = (RecordedTimeTag)tag;
            if (baseTag == null || ++counter < ignore) {
                iter.remove();
                ++removed;
                continue;
            }
            TimeSpan delta = TimeSpan.diff(baseTag.time(), nextTag.time());
            if (delta.compareTo(gap) != 1) continue;
            iter.remove();
            ++removed;
            counter = 0;
        }
        return removed;
    }

    public static int removeNonPpsTimeTags(List<BlockTag> tagList) {
        return RuleBasedBlockTagFilter.removeNonPpsTimeTags(tagList, VALID_PPS_LOWER_LIMIT);
    }

    public static int removeNonPpsTimeTags(List<BlockTag> tagList, TimeSpan minSpan) {
        if (tagList.size() < 2) {
            return 0;
        }
        ListIterator<BlockTag> iter = tagList.listIterator();
        TimeTag baseTag = null;
        TimeTag nextTag = null;
        int removed = 0;
        boolean troubleFlag = false;
        while (iter.hasNext()) {
            BlockTag tag = iter.next();
            if (!(tag instanceof TimeTag)) continue;
            if (baseTag == null) {
                baseTag = (TimeTag)((Object)tag);
                continue;
            }
            if (nextTag == null) {
                nextTag = (TimeTag)((Object)tag);
                continue;
            }
            TimeSpan delta = TimeSpan.diff(baseTag.time(), nextTag.time());
            if (delta.lessThan(minSpan)) {
                iter.remove();
                ++removed;
                troubleFlag = true;
                nextTag = (TimeTag)((Object)tag);
                continue;
            }
            if (troubleFlag) {
                iter.previous();
                iter.remove();
                ++removed;
                troubleFlag = false;
            }
            baseTag = nextTag;
            nextTag = (TimeTag)((Object)tag);
        }
        return removed;
    }

    @Override
    public List<BlockTag> process(List<BlockTag> index) {
        assert (index != null);
        ArrayList<BlockTag> remaining = new ArrayList<BlockTag>(index);
        int count = RuleBasedBlockTagFilter.removeNonPpsTimeTags(remaining);
        log.info("Removed " + String.format("%8d", count) + " time tag that occurred suspiciously close to each other");
        count = RuleBasedBlockTagFilter.removeGpsWarmupTimeTags(remaining);
        log.info("Removed " + String.format("%8d", count) + " tags that occurred during GPS \"power-up\".");
        return remaining;
    }
}

