/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.geo.LatLonPoint;
import de.gfz_potsdam.gipp.common.seis.cube.BlockTag;
import de.gfz_potsdam.gipp.common.seis.cube.DelayBlock;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.TaipBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TimeTag;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.io.File;
import java.io.Serializable;
import java.util.logging.Logger;

public class RecordedTimeTag
extends BlockTag
implements TimeTag,
Serializable {
    private static final long serialVersionUID = 4L;
    private static final Logger log = Logger.getLogger(RecordedTimeTag.class.getName());
    private static final TimeMoment FIRST_VALID_TIME = new TimeMoment.Builder().date(2005, 1, 1).build();
    private static final TimeMoment LAST_VALID_TIME = TimeSpan.add(TimeMoment.now(), new TimeSpan.Builder().addDays(1000L).build());
    private static final TimeSpan MINIMUM_DELAY = new TimeSpan.Builder().addMicroSeconds(10L).build();
    public static DelayBlock DUMMY_ZERO_DELAY_BLOCK = new DelayBlock(176, new int[]{0, 0});
    private final LatLonPoint position;
    private final Double elevation;
    private final Integer sourceOffset;
    private final Integer appliedOffset;
    private TimeMoment time;

    private RecordedTimeTag(long number, File file, long offset, TimeMoment time, Integer sourceGpsUtcOffset, Integer usedGpsUtcOffset, LatLonPoint position, Double elevation) {
        super(number, file, offset);
        assert (time != null);
        this.time = time;
        this.sourceOffset = sourceGpsUtcOffset;
        this.appliedOffset = usedGpsUtcOffset;
        this.position = position;
        this.elevation = elevation;
    }

    public static RecordedTimeTag newTag(long sampleIndex, File cubeFile, long fileOffset, TaipBlock taipBlock, DelayBlock delayBlock, TimeSpan filterDelay) {
        Double height;
        LatLonPoint location;
        Integer usedOffset;
        Integer srcOffset;
        TimeMoment taggedTime;
        if (fileOffset < 0L || sampleIndex < 0L || taipBlock == null || delayBlock == null || filterDelay == null) {
            return null;
        }
        try {
            if (!taipBlock.isValid()) {
                if (taipBlock.isUpToDate() == null) {
                    log.fine("Ignoring invalid time tag! Age of GPS fix is unknown! (File '" + cubeFile.getName() + "', offset 0x" + StringUtils.toHexString(fileOffset, 8) + ", sample #" + sampleIndex + ")");
                } else if (!taipBlock.isUpToDate().booleanValue()) {
                    log.fine("Ignoring invalid time tag! GPS fix is older than 10 seconds! (File '" + cubeFile.getName() + "', offset 0x" + StringUtils.toHexString(fileOffset, 8) + ", sample #" + sampleIndex + ")");
                } else if (taipBlock.getNumOfSatellites() != null && taipBlock.getNumOfSatellites() <= 0) {
                    log.fine("Ignoring invalid time tag! Number of satellites used for GPS fix is zero! (File '" + cubeFile.getName() + "', offset 0x" + StringUtils.toHexString(fileOffset, 8) + ", sample #" + sampleIndex + ")");
                } else {
                    log.fine("Ignoring invalid/bad time tag! (File '" + cubeFile.getName() + "', offset 0x" + StringUtils.toHexString(fileOffset, 8) + ", sample #" + sampleIndex + ")");
                }
                return null;
            }
            if (delayBlock != DUMMY_ZERO_DELAY_BLOCK && delayBlock.getDelay().compareTo(MINIMUM_DELAY) < 0) {
                log.fine("Time tag (file '" + cubeFile.getName() + "', offset 0x" + StringUtils.toHexString(fileOffset, 8) + ", sample #" + sampleIndex + ") ignored! Sample was recorded during PPS signal.");
                return null;
            }
            TimeMoment utcTime = taipBlock.getTime();
            taggedTime = TimeSpan.subtract(TimeSpan.add(utcTime, delayBlock.getDelay()), filterDelay);
            srcOffset = taipBlock.getSourceOffset();
            usedOffset = taipBlock.getAppliedOffset();
        }
        catch (IntegrityException e) {
            log.warning("Time tag (file '" + cubeFile.getName() + "', offset 0x" + StringUtils.toHexString(fileOffset, 8) + ", sample #" + sampleIndex + ") ignored! Failed to parse (TAIP) message ('" + StringUtils.escapeControlCodes(taipBlock.toString()) + "').");
            return null;
        }
        catch (TimeException e) {
            log.warning("Time tag (file '" + cubeFile.getName() + "', offset 0x" + StringUtils.toHexString(fileOffset, 8) + ", sample #" + sampleIndex + ") ignored! " + e.getMessage());
            return null;
        }
        if (taggedTime.before(FIRST_VALID_TIME) || taggedTime.after(LAST_VALID_TIME)) {
            log.warning("Time tag (file '" + cubeFile.getName() + "', offset 0x" + StringUtils.toHexString(fileOffset, 8) + ", sample #" + sampleIndex + ") ignored! A time of '" + taggedTime.toDateTimeString() + "' is outside the valid range.");
            return null;
        }
        try {
            location = taipBlock.getPosition();
            height = taipBlock.getElevation();
        }
        catch (IntegrityException e) {
            log.warning("Failed to parse geographic position from TAIP message (" + StringUtils.escapeControlCodes(taipBlock.toString()) + ") for time tag (file '" + cubeFile.getName() + "', offset 0x" + StringUtils.toHexString(fileOffset, 8) + ", sample #" + sampleIndex + "). Time information however, is OK!");
            location = null;
            height = null;
        }
        return new RecordedTimeTag(sampleIndex, cubeFile, fileOffset, taggedTime, srcOffset, usedOffset, location, height);
    }

    public static RecordedTimeTag newTagFromString(String line) {
        File dummyFile = new File("dummy.cube");
        long dummyOffset = 0L;
        LatLonPoint dummyPosition = null;
        Double dummyElevation = null;
        try {
            String textLine = line.trim();
            if (textLine.isEmpty()) {
                return null;
            }
            int commentPos = textLine.indexOf(35);
            if (commentPos == 0) {
                return null;
            }
            if (commentPos > 0) {
                textLine = textLine.substring(0, commentPos);
            }
            String[] column = textLine.split("\\s+");
            switch (column.length) {
                case 6: 
                case 7: {
                    long tagIndex = Long.parseLong(column[0]);
                    TimeMoment fullSeconds = TimeMoment.parse(column[5]);
                    long microSeconds = Long.parseLong(column[4]);
                    TimeMoment tagTime = TimeSpan.add(fullSeconds, TimeSpan.MICROSECOND.multiply(microSeconds));
                    return new RecordedTimeTag(tagIndex, dummyFile, 0L, tagTime, 0, 0, dummyPosition, dummyElevation);
                }
                case 2: {
                    long tagIndex = Long.parseLong(column[0]);
                    TimeMoment tagTime = TimeMoment.parse(column[1]);
                    return new RecordedTimeTag(tagIndex, dummyFile, 0L, tagTime, 0, 0, dummyPosition, dummyElevation);
                }
            }
            log.warning("Unknown input format. Expected 2, 6 or 7 columns but got '" + line + "'");
        }
        catch (TimeException e) {
            log.warning("Time tag ignored! Could not parse time ('" + line + "').");
        }
        catch (NumberFormatException e) {
            log.warning("Time tag ignored! Could not parse sample index ('" + line + "').");
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " at " + this.time();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.time == null ? 0 : this.time.hashCode());
        result = 31 * result + (this.sourceOffset == null ? 0 : this.sourceOffset.hashCode());
        result = 31 * result + (this.appliedOffset == null ? 0 : this.appliedOffset.hashCode());
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.elevation == null ? 0 : this.elevation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RecordedTimeTag)) {
            return false;
        }
        RecordedTimeTag other = (RecordedTimeTag)obj;
        if (this.time == null ? other.time != null : !this.time.equals(other.time)) {
            return false;
        }
        if (this.sourceOffset == null ? other.sourceOffset != null : !this.sourceOffset.equals(other.sourceOffset)) {
            return false;
        }
        if (this.appliedOffset == null ? other.appliedOffset != null : !this.appliedOffset.equals(other.appliedOffset)) {
            return false;
        }
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        if (this.elevation == null) {
            return other.elevation == null;
        }
        return this.elevation.equals(other.elevation);
    }

    @Override
    public TimeMoment time() {
        assert (this.time != null) : "The time tag contains no time information!";
        return this.time;
    }

    public RecordedTimeTag time(TimeMoment newTime) {
        assert (newTime != null) : "Cannot set a 'null' time!";
        this.time = newTime;
        return this;
    }

    public Integer getSourceGpsUtcOffset() {
        return this.sourceOffset;
    }

    public Integer getAppliedGpsUtcOffset() {
        return this.appliedOffset;
    }

    public LatLonPoint position() {
        return this.position;
    }

    public Double elevation() {
        return this.elevation;
    }
}

