/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.BinaryBlock;
import de.gfz_potsdam.gipp.common.seis.cube.CubeException;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public class LostSamplesBlock
extends BinaryBlock
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CONTENT_LENGTH = 3;

    public LostSamplesBlock() {
        super(3);
    }

    LostSamplesBlock(int[] data) {
        super(data);
    }

    public int write(DataOutput stream) throws IOException {
        return this.write(stream, 194);
    }

    public int getSamplesLost() {
        if (this.content.isEmpty()) {
            throw new CubeException("No 'lost sample' count is available yet! Please read/parse the block first.");
        }
        if (this.content.size() != 3) {
            throw new IntegrityException("Expected a 'lost samples' block size of 4 bytes but got " + (this.content.size() + 1) + " bytes instead.");
        }
        int count = ((Byte)this.content.get(0) & 0x7F) << 14 | ((Byte)this.content.get(1) & 0x7F) << 7 | (Byte)this.content.get(2) & 0x7F;
        if (count == 0) {
            throw new IntegrityException("Zero missing samples is an invalid value for a 'missing samples' block!");
        }
        return count;
    }

    @Override
    public String toString() {
        if (this.content.isEmpty()) {
            return "--unread-lost-samples-block--";
        }
        return Integer.toString(this.getSamplesLost());
    }
}

