/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.BlockTag;
import de.gfz_potsdam.gipp.common.seis.cube.BlockTagFilter;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.TimeTag;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class LocalLeastSquaresBlockTagFilter
implements BlockTagFilter {
    private static final MathContext MATH_CONTEXT = new MathContext(24, RoundingMode.HALF_UP);
    static final Logger log = Logger.getLogger(LocalLeastSquaresBlockTagFilter.class.getName());
    private static final TimeSpan DEFAULT_MAX_TAG_DISTANCE = new TimeSpan.Builder().addSeconds(6.5).build();
    private static final int DEFAULT_MIN_NUMBER_OF_TAGS = 30;
    private static final TimeSpan DEFAULT_SEGMENT_LENGTH = new TimeSpan.Builder().addMinutes(15L).build();
    private static final double DEFAULT_MAX_OUTLIER_RATIO = 0.3;
    private static final TimeSpan DEFAULT_MAX_RESIDUAL = new TimeSpan.Builder().addNanoSeconds(1200L).build();
    private final TimeSpan maxTagDistanceInSegment;
    private final int minNumberOfTimeTags;
    private final TimeSpan segmentLength;
    private final double maxOutlierRatio;
    private final BigDecimal maxResidualPerTag;

    private static TimeMoment endOfFirstSegment(List<BlockTag> traceIndex, TimeSpan segmentLength) {
        assert (traceIndex != null) : "The trace index must not be 'null'!";
        assert (segmentLength != null) : "The segment length must not be 'null'!";
        TimeTag first = CubeUtils.getNextTimeTag(traceIndex.listIterator());
        if (first == null) {
            return null;
        }
        return TimeSpan.add(first.time(), segmentLength);
    }

    private static boolean discardFirstMatchingTag(List<BlockTag> traceIndex, BlockTag badTag) {
        assert (traceIndex != null) : "The trace index must not be 'null'!";
        assert (badTag != null) : "The bad block tag must not be 'null'!";
        Iterator<BlockTag> traceIndexIter = traceIndex.iterator();
        while (traceIndexIter.hasNext()) {
            BlockTag tag = traceIndexIter.next();
            if (badTag != tag) continue;
            traceIndexIter.remove();
            assert (!traceIndex.contains(badTag)) : "Removing bad block tag failed!";
            return true;
        }
        return false;
    }

    private static int discardAllTimeTags(List<BlockTag> traceIndex) {
        assert (traceIndex != null) : "The trace index must not be 'null'!";
        int removedCount = 0;
        ListIterator<BlockTag> iter = traceIndex.listIterator();
        while (iter.hasNext()) {
            BlockTag tag = iter.next();
            if (!(tag instanceof TimeTag)) continue;
            iter.remove();
            ++removedCount;
        }
        return removedCount;
    }

    public LocalLeastSquaresBlockTagFilter() {
        this(DEFAULT_MAX_TAG_DISTANCE, 30, DEFAULT_SEGMENT_LENGTH, 0.3, DEFAULT_MAX_RESIDUAL);
    }

    public LocalLeastSquaresBlockTagFilter(TimeSpan maxTimeTagDistance, int minNumberOfTags, TimeSpan segmentLength, double maxOutlierRatio, TimeSpan maxMisfitPerTag) {
        if (maxTimeTagDistance.lessThan(TimeSpan.SECOND)) {
            throw new IllegalArgumentException("The span between two time tags must be at least 1 second!");
        }
        if (minNumberOfTags <= 0) {
            throw new IllegalArgumentException("The minimal number of time tags must be a positive number!");
        }
        if (segmentLength != null && segmentLength.lessThan(new TimeSpan.Builder().addSeconds(minNumberOfTags).build())) {
            throw new IllegalArgumentException("The maximal segment length must be at least " + minNumberOfTags + " seconds long!");
        }
        if (maxOutlierRatio <= 0.0 || maxOutlierRatio > 1.0) {
            throw new IllegalArgumentException("The outlier ratio must be in the range ']0;1]' but was '" + maxOutlierRatio + "'.");
        }
        if (maxMisfitPerTag != null && maxMisfitPerTag.isZeroLength()) {
            throw new IllegalArgumentException("The allowed misfit per tag must be a positive number!");
        }
        this.maxTagDistanceInSegment = maxTimeTagDistance;
        this.minNumberOfTimeTags = minNumberOfTags;
        this.segmentLength = segmentLength;
        this.maxOutlierRatio = maxOutlierRatio;
        this.maxResidualPerTag = new BigDecimal(maxMisfitPerTag.getBigCount());
    }

    @Override
    public List<BlockTag> process(List<BlockTag> inIndex) {
        if (inIndex == null || inIndex.size() == 0) {
            throw new IllegalArgumentException("The input block list (\"trace index\") must not be empty!");
        }
        ArrayList<BlockTag> outIndex = new ArrayList<BlockTag>(inIndex.size());
        int incompleteSegmentTagCount = 0;
        int badSegmentTagCount = 0;
        int outlierTagCount = 0;
        ListIterator<BlockTag> inputListIter = inIndex.listIterator();
        LinkedList<BlockTag> segment = new LinkedList<BlockTag>();
        TimeMoment endOfSegment = LocalLeastSquaresBlockTagFilter.endOfFirstSegment(inIndex, this.segmentLength);
        while (inputListIter.hasNext()) {
            block16: {
                int segmentTimeTagCount = 0;
                int segmentRemovedCount = 0;
                TimeMoment segmentCurrentEndTime = null;
                do {
                    BlockTag tag;
                    if ((tag = inputListIter.next()) instanceof TimeTag) {
                        TimeTag timeTag = (TimeTag)((Object)tag);
                        if (segmentCurrentEndTime != null && TimeSpan.diff(timeTag.time(), segmentCurrentEndTime).moreThan(this.maxTagDistanceInSegment)) {
                            inputListIter.previous();
                            endOfSegment = TimeSpan.add(timeTag.time(), this.segmentLength);
                            break;
                        }
                        segment.add(tag);
                        ++segmentTimeTagCount;
                        segmentCurrentEndTime = timeTag.time();
                        if (!timeTag.time().afterOrAt(endOfSegment)) continue;
                        endOfSegment = TimeSpan.add(timeTag.time(), this.segmentLength);
                        break;
                    }
                    segment.add(tag);
                } while (inputListIter.hasNext());
                while (true) {
                    if (segmentTimeTagCount < this.minNumberOfTimeTags) {
                        if (inputListIter.hasNext()) {
                            log.fine("Not enough time tags left in " + this.segmentLength.toString() + " segment for statistical analysis. Discarding the remaining " + segmentTimeTagCount + " time tags!");
                        } else {
                            log.fine("End of trace index reached. Ignoring the last " + segmentTimeTagCount + " time tags! (Need at least " + this.minNumberOfTimeTags + " tags for meaningful statistical analysis.)");
                        }
                        incompleteSegmentTagCount += LocalLeastSquaresBlockTagFilter.discardAllTimeTags(segment);
                        segmentTimeTagCount = 0;
                        segmentRemovedCount = 0;
                        break block16;
                    }
                    if ((double)segmentRemovedCount / (double)(segmentTimeTagCount + segmentRemovedCount) > this.maxOutlierRatio) {
                        log.fine("More than " + StringUtils.roundedNumber(this.maxOutlierRatio * 100.0, 0, 1) + "% of the time tags in the segment are of questionable quality. Discarding the remaining " + segmentTimeTagCount + " time tags as well! ");
                        badSegmentTagCount += LocalLeastSquaresBlockTagFilter.discardAllTimeTags(segment);
                        segmentTimeTagCount = 0;
                        segmentRemovedCount = 0;
                        break block16;
                    }
                    BigDecimal xSum = BigDecimal.ZERO;
                    BigDecimal ySum = BigDecimal.ZERO;
                    for (BlockTag tag : segment) {
                        if (!(tag instanceof TimeTag)) continue;
                        TimeTag timeTag = (TimeTag)((Object)tag);
                        xSum = xSum.add(BigDecimal.valueOf(timeTag.number()));
                        ySum = ySum.add(new BigDecimal(timeTag.time().getBigCount()));
                    }
                    assert (segmentTimeTagCount > 0) : "The number of time tags in the segment must be positive!";
                    BigDecimal xMean = xSum.divide(BigDecimal.valueOf(segmentTimeTagCount), MATH_CONTEXT);
                    BigDecimal yMean = ySum.divide(BigDecimal.valueOf(segmentTimeTagCount), MATH_CONTEXT);
                    BigDecimal xxBar = BigDecimal.ZERO;
                    BigDecimal xyBar = BigDecimal.ZERO;
                    for (BlockTag tag : segment) {
                        if (!(tag instanceof TimeTag)) continue;
                        TimeTag timeTag = (TimeTag)((Object)tag);
                        BigDecimal xDelta = BigDecimal.valueOf(timeTag.number()).subtract(xMean);
                        BigDecimal yDelta = new BigDecimal(timeTag.time().getBigCount()).subtract(yMean);
                        xxBar = xxBar.add(xDelta.multiply(xDelta), MATH_CONTEXT);
                        xyBar = xyBar.add(xDelta.multiply(yDelta), MATH_CONTEXT);
                    }
                    BigDecimal beta1 = xyBar.divide(xxBar, MATH_CONTEXT);
                    BigDecimal beta0 = yMean.subtract(beta1.multiply(xMean), MATH_CONTEXT);
                    log.finer("Fitted line: y = " + beta1.toPlainString() + " * x + " + beta0.toPlainString());
                    BlockTag outlierTag = null;
                    BigDecimal outlierError = BigDecimal.ZERO;
                    BigDecimal totalMisfit = BigDecimal.ZERO;
                    for (BlockTag tag : segment) {
                        if (!(tag instanceof TimeTag)) continue;
                        TimeTag timeTag = (TimeTag)((Object)tag);
                        BigDecimal fittedTime = beta1.multiply(BigDecimal.valueOf(timeTag.number())).add(beta0);
                        BigDecimal absError = fittedTime.subtract(new BigDecimal(timeTag.time().getBigCount())).abs();
                        totalMisfit = totalMisfit.add(absError.pow(2));
                        if (absError.compareTo(outlierError) != 1) continue;
                        outlierTag = tag;
                        outlierError = absError;
                    }
                    BigDecimal maxMisfit = this.maxResidualPerTag.multiply(this.maxResidualPerTag).multiply(BigDecimal.valueOf(segmentTimeTagCount));
                    if (totalMisfit.compareTo(maxMisfit) <= 0) {
                        log.fine("Finished analyzing \"segment\". " + segmentTimeTagCount + " good time tags remain.");
                        break block16;
                    }
                    log.fine("Removing suspicious time tag at sample #" + outlierTag.number());
                    if (!LocalLeastSquaresBlockTagFilter.discardFirstMatchingTag(segment, outlierTag)) break;
                    --segmentTimeTagCount;
                    ++segmentRemovedCount;
                    ++outlierTagCount;
                }
                throw new IllegalStateException("Detected a suspicious time tag but failed to remove it from the trace index!");
            }
            outIndex.addAll(segment);
            segment.clear();
        }
        if (inIndex.equals(outIndex)) {
            log.info("No bad time tags found in the index!");
            outIndex.clear();
            return inIndex;
        }
        log.info("Removed " + String.format("%8d", outlierTagCount) + " suspected outlier time tags.");
        log.info("Removed " + String.format("%8d", badSegmentTagCount) + " tags where the overall timing quality of the surrounding tags is too bad.");
        log.info("Removed " + String.format("%8d", incompleteSegmentTagCount) + " time tags where the density of surrounding tags was to sparse.");
        return outIndex;
    }
}

