/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.Block;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.TextualFields;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InfoBlock
extends Block
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String content;

    public InfoBlock() {
        this.content = null;
    }

    public InfoBlock(String text) {
        this.content = text;
    }

    @Override
    public int read(ByteBuffer inBuffer) throws BufferUnderflowException {
        StringBuilder buffer = new StringBuilder();
        this.content = null;
        while (inBuffer.hasRemaining()) {
            byte value = inBuffer.get();
            if (value < 0) {
                this.content = buffer.toString();
                return value & 0xFF;
            }
            buffer.append((char)value);
        }
        this.content = buffer.toString();
        throw new BufferUnderflowException();
    }

    @Override
    public int read(InputStream stream) throws IOException {
        StringBuilder buffer = new StringBuilder();
        this.content = null;
        while (true) {
            int value;
            if ((value = stream.read()) > 127 || value < 0) {
                this.content = buffer.toString();
                return value;
            }
            buffer.append((char)value);
        }
    }

    @Override
    public int read(DataInput source) throws IOException {
        StringBuilder buffer = new StringBuilder();
        this.content = null;
        try {
            while (true) {
                int value;
                if ((value = source.readUnsignedByte()) > 127) {
                    this.content = buffer.toString();
                    return value;
                }
                buffer.append((char)value);
            }
        }
        catch (EOFException e) {
            this.content = buffer.toString();
            return -1;
        }
    }

    public int write(DataOutput stream) throws IOException {
        return this.write(stream, 208);
    }

    protected int write(DataOutput stream, int blockType) throws IOException {
        if (blockType < 128 || blockType >= 255) {
            throw new IntegrityException("Invalid block type. An ID of 0x" + StringUtils.toHexString(blockType, 2) + " was given but only numbers in the range 0x80 to 0xff are possible!");
        }
        if (this.content == null) {
            throw new IntegrityException("Cannot write an uninitialized block!");
        }
        stream.writeByte(blockType);
        stream.writeBytes(this.content);
        return this.content.length() + 1;
    }

    public String toString() {
        if (this.content != null) {
            return this.content;
        }
        return "--unread-textual-block--";
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InfoBlock)) {
            return false;
        }
        InfoBlock other = (InfoBlock)obj;
        if (this.content == null) {
            return other.content == null;
        }
        return this.content.equals(other.content);
    }

    public int length() {
        if (this.content == null) {
            return -1;
        }
        return this.content.length();
    }

    protected String getValue(TextualFields keyword) {
        if (this.content == null) {
            return null;
        }
        Pattern p = Pattern.compile("(?:" + keyword.key() + "=([^;]+))");
        Matcher m = p.matcher(this.content);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    protected String getContent(Pattern searchPattern) {
        assert (searchPattern != null) : "Search pattern must not be null!";
        if (this.content == null) {
            return null;
        }
        Matcher m = searchPattern.matcher(this.content);
        if (m.find()) {
            return m.group();
        }
        return null;
    }
}

