/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.InfoBlock;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.TextualFields;
import de.gfz_potsdam.gipp.common.time.TimeException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class HeaderBlock
extends InfoBlock {
    private static final long serialVersionUID = 2L;
    private static final String NOT_AVAILABLE = "N/A";

    public HeaderBlock() {
    }

    HeaderBlock(String text) {
        super(text);
    }

    @Override
    public int write(DataOutput stream) throws IOException {
        return this.write(stream, 240);
    }

    public boolean isPartiallyRead() {
        if (this.content == null || this.content.isEmpty()) {
            return true;
        }
        if (!this.content.contains(TextualFields.COMMON_GAIN.key())) {
            return true;
        }
        if (!this.content.contains(TextualFields.UNIT_ID.key())) {
            return true;
        }
        if (!this.content.contains(TextualFields.CHANNEL_NUMBER.key())) {
            return true;
        }
        if (!this.content.contains(TextualFields.SAMPLE_RATE.key())) {
            return true;
        }
        if (!this.content.contains(TextualFields.FIR_FILTER_DELAY.key())) {
            return true;
        }
        if (!this.content.contains(TextualFields.FIR_FILTER_TYPE.key())) {
            return true;
        }
        if (!this.content.contains(TextualFields.START_DATE.key())) {
            return true;
        }
        return !this.content.contains(TextualFields.START_TIME.key());
    }

    private String getLoggerInfo(LoggerComponent component) {
        String info = this.getValue(TextualFields.SYSTEM_INFO);
        if (info == null || info.isEmpty()) {
            return NOT_AVAILABLE;
        }
        String[] components = info.split("_");
        switch (component) {
            case FIRMWARE: {
                if (components.length <= 0) break;
                return components[0];
            }
            case CLOCK_SOURCE: {
                if (components.length <= 1) break;
                return components[1];
            }
            case DIGITIZER: {
                if (components.length <= 2) break;
                return components[2];
            }
            case CHANNELS: {
                if (components.length <= 3) break;
                return components[3];
            }
            case HARDWARE_ID1: {
                if (components.length <= 4) break;
                return components[4];
            }
            case HARDWARE_ID2: {
                if (components.length <= 5) break;
                return components[5];
            }
        }
        return NOT_AVAILABLE;
    }

    public boolean isCube() {
        if (this.content == null || this.content.isEmpty()) {
            return false;
        }
        String firmwareVersion = this.getLoggerInfo(LoggerComponent.FIRMWARE);
        if (firmwareVersion.toUpperCase().startsWith("C")) {
            return true;
        }
        return !this.isNube() && !this.isEventRecorder();
    }

    public boolean isNube() {
        if (this.content == null || this.content.isEmpty()) {
            return false;
        }
        String firmwareVersion = this.getLoggerInfo(LoggerComponent.FIRMWARE);
        if (firmwareVersion.equalsIgnoreCase(NOT_AVAILABLE)) {
            return false;
        }
        return firmwareVersion.toUpperCase().startsWith("N");
    }

    public boolean isEventRecorder() {
        if (this.content == null || this.content.isEmpty()) {
            return false;
        }
        String firmwareVersion = this.getLoggerInfo(LoggerComponent.FIRMWARE);
        return firmwareVersion.toUpperCase().startsWith("ER");
    }

    public String firmwareVersionInfo() {
        return this.getLoggerInfo(LoggerComponent.FIRMWARE);
    }

    public TimeSpan wnroCorrection() {
        if (this.content == null || this.content.isEmpty()) {
            return null;
        }
        String info = this.getLoggerInfo(LoggerComponent.CLOCK_SOURCE);
        if (info.equalsIgnoreCase(NOT_AVAILABLE)) {
            return null;
        }
        if (info.length() >= 3) {
            char wnroInfo = Character.toUpperCase(info.charAt(2));
            switch (wnroInfo) {
                case 'A': {
                    return TimeSpan.ZERO;
                }
                case 'B': {
                    return TimeSpan.GPS_EPOCH;
                }
            }
            return null;
        }
        return null;
    }

    ClockSource clockSource() {
        if (this.content == null || this.content.isEmpty()) {
            return null;
        }
        String source = this.getLoggerInfo(LoggerComponent.CLOCK_SOURCE);
        if (source.equalsIgnoreCase(NOT_AVAILABLE)) {
            return ClockSource.LASSEN_IQ;
        }
        if (source.length() >= 2) {
            switch (source.substring(0, 2)) {
                case "00": 
                case "01": 
                case "02": 
                case "03": 
                case "04": 
                case "05": 
                case "06": 
                case "07": 
                case "08": 
                case "09": {
                    return ClockSource.LASSEN_IQ;
                }
                case "10": 
                case "11": 
                case "12": 
                case "13": 
                case "14": 
                case "15": 
                case "16": 
                case "17": 
                case "18": 
                case "19": {
                    return ClockSource.COPERNICUS_II;
                }
                case "20": 
                case "21": 
                case "22": 
                case "23": 
                case "24": 
                case "25": 
                case "26": 
                case "27": 
                case "28": 
                case "29": {
                    return ClockSource.MAX_8;
                }
                case "90": 
                case "91": 
                case "92": 
                case "93": 
                case "94": 
                case "95": 
                case "96": 
                case "97": 
                case "98": {
                    return ClockSource.SIMULATOR;
                }
            }
            return null;
        }
        return null;
    }

    public String clockSourceInfo() {
        ClockSource clockSource = this.clockSource();
        if (clockSource == null) {
            return NOT_AVAILABLE;
        }
        switch (clockSource) {
            case LASSEN_IQ: 
            case COPERNICUS_II: 
            case MAX_8: {
                String clockDetails = this.getLoggerInfo(LoggerComponent.CLOCK_SOURCE);
                if (clockDetails.length() >= 4) {
                    switch (clockDetails.substring(3, 4)) {
                        case "I": {
                            return "GNSS receiver using internal antenna";
                        }
                        case "E": {
                            return "GNSS receiver using external antenna";
                        }
                        case "S": {
                            String receiverID = this.getValue(TextualFields.GNSS_RECEIVER);
                            if (receiverID == null) {
                                return "GNSS receiver";
                            }
                            if (receiverID.equals("0")) {
                                return "GNSS receiver using internal antenna";
                            }
                            if (receiverID.equals("1")) {
                                return "GNSS receiver using external antenna";
                            }
                            return "GNSS receiver";
                        }
                    }
                    return "GNSS receiver";
                }
                return "GNSS receiver";
            }
            case SIMULATOR: {
                return "simulator";
            }
            case CSAC: {
                return "Chip Scale Atomic Clock (CSAC)";
            }
        }
        return NOT_AVAILABLE;
    }

    public String clockStaticCorrectionInfo() {
        if (this.content == null || this.content.isEmpty()) {
            return NOT_AVAILABLE;
        }
        String info = this.getLoggerInfo(LoggerComponent.CLOCK_SOURCE);
        if (info.equalsIgnoreCase(NOT_AVAILABLE)) {
            return NOT_AVAILABLE;
        }
        if (info.length() >= 3) {
            char wnroInfo = Character.toUpperCase(info.charAt(2));
            switch (wnroInfo) {
                case 'A': {
                    return "none";
                }
                case 'B': {
                    return "1024 weeks (GPS week number rollover)";
                }
            }
            return "ERROR - Unknown WNRO correction ('" + this.wnroCorrection().getApproximateString() + "')!";
        }
        return NOT_AVAILABLE;
    }

    AnalogDigitalConverter analogDigitalConverter() {
        if (this.content == null || this.content.isEmpty()) {
            return null;
        }
        String info = this.getLoggerInfo(LoggerComponent.DIGITIZER);
        if (info.equalsIgnoreCase(NOT_AVAILABLE)) {
            return AnalogDigitalConverter.ADS1282;
        }
        switch (info) {
            case "01": {
                return AnalogDigitalConverter.ADS1282;
            }
            case "02": {
                return AnalogDigitalConverter.MAX11214;
            }
        }
        return null;
    }

    int availableChannels() {
        String info = this.getLoggerInfo(LoggerComponent.CHANNELS);
        try {
            return Integer.parseInt(info);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String cubeName() throws IntegrityException {
        if (this.content == null || this.content.isEmpty()) {
            throw new IntegrityException("The header block is empty.");
        }
        StringBuilder name = new StringBuilder(5);
        if (this.isCube()) {
            name.append('c');
        } else if (this.isNube()) {
            name.append('n');
        } else if (this.isEventRecorder()) {
            name.append("er");
        }
        String buffer = this.getValue(TextualFields.UNIT_ID);
        if (buffer == null) {
            throw new IntegrityException("There is no unit ID in the header block.");
        }
        switch (buffer.length()) {
            case 1: {
                name.append("000").append(buffer);
                break;
            }
            case 2: {
                name.append("00").append(buffer);
                break;
            }
            case 3: {
                name.append('0').append(buffer);
                break;
            }
            default: {
                name.append(buffer);
            }
        }
        return name.toString();
    }

    public int enabledChannels() throws IntegrityException {
        try {
            String value = this.getValue(TextualFields.CHANNEL_NUMBER);
            if (value == null || value.isEmpty()) {
                throw new IntegrityException("Could not read the number of used recording channels from the header block. Parameter '" + TextualFields.CHANNEL_NUMBER.key() + "' was not found!");
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IntegrityException("Could not successfully read the number of used recording channels (got '" + this.getValue(TextualFields.CHANNEL_NUMBER) + "' but expected a small positive number).");
        }
    }

    public String experimentName() {
        String info = this.getValue(TextualFields.EXPERIMENT_NAME);
        if (info == null || info.isEmpty()) {
            return NOT_AVAILABLE;
        }
        return info;
    }

    public List<Integer> channelGains() throws IntegrityException {
        int channels = this.enabledChannels();
        ArrayList<Integer> gains = new ArrayList<Integer>(channels);
        try {
            String gainInfo = this.getValue(TextualFields.CHANNEL_GAIN);
            if (gainInfo != null && !gainInfo.isEmpty()) {
                Object[] gainValues = gainInfo.split("_");
                if (gainValues.length == channels) {
                    for (int i = 0; i < channels; ++i) {
                        gains.add(Integer.parseInt(gainValues[i]));
                    }
                    return gains;
                }
                throw new IntegrityException("Expected " + channels + " gain values, one for each enabled recording channel. However, got " + Arrays.toString(gainValues) + " instead.");
            }
            gainInfo = this.getValue(TextualFields.COMMON_GAIN);
            if (gainInfo != null && !gainInfo.isEmpty()) {
                int gain = Integer.parseInt(gainInfo);
                for (int i = 0; i < channels; ++i) {
                    gains.add(gain);
                }
                return gains;
            }
        }
        catch (NumberFormatException exception) {
            throw new IntegrityException("Could not determine recorder gain setting.", exception);
        }
        throw new IntegrityException("No gain settings were found in the header block. Expected " + (Object)((Object)TextualFields.CHANNEL_GAIN) + " or " + (Object)((Object)TextualFields.COMMON_GAIN) + " field.");
    }

    public String choppingAmplifierMode() {
        String value = this.getValue(TextualFields.AMPLIFIER_CHOP);
        if (value == null || value.isEmpty()) {
            return NOT_AVAILABLE;
        }
        int chopping = Integer.parseInt(value);
        if (chopping == 1) {
            return "on";
        }
        if (chopping == 0) {
            return "off";
        }
        return "unknown";
    }

    PowerMode adcPowerMode() {
        String value = this.getValue(TextualFields.ADC_MODE);
        if (value == null || value.isEmpty()) {
            return PowerMode.NOT_SUPPORTED;
        }
        switch (value) {
            case "0": {
                return PowerMode.LOW_POWER;
            }
            case "1": {
                return PowerMode.HIGH_RESOLUTION;
            }
        }
        throw new IntegrityException("Could not successfully read the ADC power mode setting (got '" + this.getValue(TextualFields.ADC_MODE) + "' but expected '0' or '1').");
    }

    public String adcPowerModeInfo() {
        if (this.content == null || this.content.isEmpty()) {
            return NOT_AVAILABLE;
        }
        try {
            switch (this.adcPowerMode()) {
                case NOT_SUPPORTED: {
                    return NOT_AVAILABLE;
                }
                case LOW_POWER: {
                    return "low power consumption";
                }
                case HIGH_RESOLUTION: {
                    return "high resolution";
                }
            }
        }
        catch (IntegrityException integrityException) {
            // empty catch block
        }
        return "unknown";
    }

    public int sampleRate() throws IntegrityException {
        try {
            String value = this.getValue(TextualFields.SAMPLE_RATE);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IntegrityException("Could not successfully read the sample rate of the recording (got '" + this.getValue(TextualFields.SAMPLE_RATE) + "' but expected a positive number).");
        }
    }

    public String highpassFilterInfo() {
        String filter = this.getValue(TextualFields.HIGH_PASS_FILTER);
        if (filter == null) {
            return NOT_AVAILABLE;
        }
        switch (filter) {
            case "0": {
                return "off";
            }
            case "1": {
                return "on";
            }
        }
        return NOT_AVAILABLE;
    }

    public String firFilterInfo() {
        if (this.content == null || this.content.isEmpty()) {
            return NOT_AVAILABLE;
        }
        try {
            switch (this.firFilterType()) {
                case LINEAR_PHASE_FIR: {
                    return "linear phase";
                }
                case MINIMUM_PHASE_FIR: {
                    return "minimum phase";
                }
            }
        }
        catch (IntegrityException integrityException) {
            // empty catch block
        }
        return "unknown";
    }

    DigitalFilter firFilterType() {
        String filterType = this.getValue(TextualFields.FIR_FILTER_TYPE);
        if (filterType == null || filterType.isEmpty()) {
            throw new IntegrityException("Could not read the FIR filter type setting from the header block. Parameter '" + TextualFields.FIR_FILTER_TYPE.key() + "' was not found!");
        }
        switch (filterType) {
            case "0": {
                return DigitalFilter.LINEAR_PHASE_FIR;
            }
            case "1": {
                return DigitalFilter.MINIMUM_PHASE_FIR;
            }
        }
        throw new IntegrityException("Could not successfully read the FIR filter type setting (got '" + this.getValue(TextualFields.FIR_FILTER_TYPE) + "' but expected '0' or '1').");
    }

    public TimeSpan firFilterDelay() throws IntegrityException {
        AnalogDigitalConverter adc = this.analogDigitalConverter();
        DigitalFilter fir = this.firFilterType();
        int sampleRate = this.sampleRate();
        if (adc != null) {
            switch (adc) {
                case ADS1282: {
                    if (fir == DigitalFilter.LINEAR_PHASE_FIR) {
                        switch (sampleRate) {
                            case 50: {
                                return TimeSpan.SECOND.multiply(0.62428);
                            }
                            case 100: {
                                return TimeSpan.SECOND.multiply(0.31229);
                            }
                            case 200: {
                                return TimeSpan.SECOND.multiply(0.15629);
                            }
                            case 250: {
                                return TimeSpan.SECOND.multiply(0.12487);
                            }
                            case 400: {
                                return TimeSpan.SECOND.multiply(0.07829);
                            }
                            case 500: {
                                return TimeSpan.SECOND.multiply(0.06247);
                            }
                            case 800: {
                                return TimeSpan.SECOND.multiply(0.03929);
                            }
                            case 1000: {
                                return TimeSpan.SECOND.multiply(0.03127);
                            }
                            case 2000: {
                                return TimeSpan.SECOND.multiply(0.01567);
                            }
                            case 4000: {
                                return TimeSpan.SECOND.multiply(0.00787);
                            }
                        }
                        break;
                    }
                    if (fir != DigitalFilter.MINIMUM_PHASE_FIR) break;
                    switch (sampleRate) {
                        case 50: {
                            return TimeSpan.SECOND.multiply(0.10428000000000001);
                        }
                        case 100: {
                            return TimeSpan.SECOND.multiply(0.05229);
                        }
                        case 200: {
                            return TimeSpan.SECOND.multiply(0.02629);
                        }
                        case 250: {
                            return TimeSpan.SECOND.multiply(0.02087);
                        }
                        case 400: {
                            return TimeSpan.SECOND.multiply(0.013290000000000001);
                        }
                        case 500: {
                            return TimeSpan.SECOND.multiply(0.01047);
                        }
                        case 800: {
                            return TimeSpan.SECOND.multiply(0.00679);
                        }
                        case 1000: {
                            return TimeSpan.SECOND.multiply(0.00527);
                        }
                        case 2000: {
                            return TimeSpan.SECOND.multiply(0.00267);
                        }
                        case 4000: {
                            return TimeSpan.SECOND.multiply(0.0013700000000000001);
                        }
                    }
                    break;
                }
                case MAX11214: {
                    double minGain = Collections.min(this.channelGains()).intValue();
                    PowerMode adcMode = this.adcPowerMode();
                    if (adcMode == PowerMode.LOW_POWER || minGain > 16.0) {
                        if (fir == DigitalFilter.LINEAR_PHASE_FIR) {
                            switch (sampleRate) {
                                case 25: {
                                    return TimeSpan.SECOND.multiply(1.29759);
                                }
                                case 50: {
                                    return TimeSpan.SECOND.multiply(0.64915);
                                }
                                case 100: {
                                    return TimeSpan.SECOND.multiply(0.32494);
                                }
                                case 125: {
                                    return TimeSpan.SECOND.multiply(0.25967);
                                }
                                case 200: {
                                    return TimeSpan.SECOND.multiply(0.16251000000000002);
                                }
                                case 250: {
                                    return TimeSpan.SECOND.multiply(0.12998);
                                }
                                case 400: {
                                    return TimeSpan.SECOND.multiply(0.0813);
                                }
                                case 500: {
                                    return TimeSpan.SECOND.multiply(0.06502);
                                }
                                case 800: {
                                    return TimeSpan.SECOND.multiply(0.0407);
                                }
                                case 1000: {
                                    return TimeSpan.SECOND.multiply(0.03253);
                                }
                                case 2000: {
                                    return TimeSpan.SECOND.multiply(0.01629);
                                }
                                case 4000: {
                                    return TimeSpan.SECOND.multiply(0.00817);
                                }
                            }
                            break;
                        }
                        if (fir != DigitalFilter.MINIMUM_PHASE_FIR) break;
                        switch (sampleRate) {
                            case 25: {
                                return TimeSpan.SECOND.multiply(0.21759);
                            }
                            case 50: {
                                return TimeSpan.SECOND.multiply(0.10915000000000001);
                            }
                            case 100: {
                                return TimeSpan.SECOND.multiply(0.05494);
                            }
                            case 125: {
                                return TimeSpan.SECOND.multiply(0.04367);
                            }
                            case 200: {
                                return TimeSpan.SECOND.multiply(0.02751);
                            }
                            case 250: {
                                return TimeSpan.SECOND.multiply(0.02198);
                            }
                            case 400: {
                                return TimeSpan.SECOND.multiply(0.0138);
                            }
                            case 500: {
                                return TimeSpan.SECOND.multiply(0.01102);
                            }
                            case 800: {
                                return TimeSpan.SECOND.multiply(0.0069500000000000004);
                            }
                            case 1000: {
                                return TimeSpan.SECOND.multiply(0.00553);
                            }
                            case 2000: {
                                return TimeSpan.SECOND.multiply(0.00279);
                            }
                            case 4000: {
                                return TimeSpan.SECOND.multiply(0.00142);
                            }
                        }
                        break;
                    }
                    if (fir == DigitalFilter.LINEAR_PHASE_FIR) {
                        switch (sampleRate) {
                            case 25: {
                                return TimeSpan.SECOND.multiply(1.29759);
                            }
                            case 50: {
                                return TimeSpan.SECOND.multiply(0.6488);
                            }
                            case 100: {
                                return TimeSpan.SECOND.multiply(0.32459);
                            }
                            case 125: {
                                return TimeSpan.SECOND.multiply(0.25967);
                            }
                            case 200: {
                                return TimeSpan.SECOND.multiply(0.16248);
                            }
                            case 250: {
                                return TimeSpan.SECOND.multiply(0.12998);
                            }
                            case 400: {
                                return TimeSpan.SECOND.multiply(0.08127);
                            }
                            case 500: {
                                return TimeSpan.SECOND.multiply(0.06502);
                            }
                            case 800: {
                                return TimeSpan.SECOND.multiply(0.04066);
                            }
                            case 1000: {
                                return TimeSpan.SECOND.multiply(0.03253);
                            }
                            case 2000: {
                                return TimeSpan.SECOND.multiply(0.01629);
                            }
                            case 4000: {
                                return TimeSpan.SECOND.multiply(0.00817);
                            }
                        }
                        break;
                    }
                    if (fir != DigitalFilter.MINIMUM_PHASE_FIR) break;
                    switch (sampleRate) {
                        case 25: {
                            return TimeSpan.SECOND.multiply(0.21759);
                        }
                        case 50: {
                            return TimeSpan.SECOND.multiply(0.10880000000000001);
                        }
                        case 100: {
                            return TimeSpan.SECOND.multiply(0.05459);
                        }
                        case 125: {
                            return TimeSpan.SECOND.multiply(0.04367);
                        }
                        case 200: {
                            return TimeSpan.SECOND.multiply(0.02748);
                        }
                        case 250: {
                            return TimeSpan.SECOND.multiply(0.02198);
                        }
                        case 400: {
                            return TimeSpan.SECOND.multiply(0.013770000000000001);
                        }
                        case 500: {
                            return TimeSpan.SECOND.multiply(0.01102);
                        }
                        case 800: {
                            return TimeSpan.SECOND.multiply(0.00691);
                        }
                        case 1000: {
                            return TimeSpan.SECOND.multiply(0.00553);
                        }
                        case 2000: {
                            return TimeSpan.SECOND.multiply(0.00279);
                        }
                        case 4000: {
                            return TimeSpan.SECOND.multiply(0.00142);
                        }
                    }
                }
            }
        }
        try {
            double filterDelay = Double.parseDouble(this.getValue(TextualFields.FIR_FILTER_DELAY));
            return TimeSpan.SECOND.multiply(filterDelay / (double)sampleRate);
        }
        catch (NullPointerException e) {
            throw new IntegrityException("Could not read the FIR filter delay setting from the header block. Parameter '" + TextualFields.FIR_FILTER_DELAY.key() + "' was not found!", e);
        }
        catch (NumberFormatException e) {
            throw new IntegrityException("Could not successfully read the FIR filter delay setting (got '" + this.getValue(TextualFields.FIR_FILTER_DELAY) + "' but expected a number).", e);
        }
    }

    public String clockDriftCorrectionInfo() {
        if (this.content == null || this.content.isEmpty()) {
            return NOT_AVAILABLE;
        }
        String mode = this.getValue(TextualFields.TIME_CORRECTION);
        if (mode == null) {
            return NOT_AVAILABLE;
        }
        try {
            switch (Integer.parseInt(mode)) {
                case 0: {
                    return "off";
                }
                case 1: {
                    return "synchronize to PLL";
                }
                case 2: {
                    return "minimize drift";
                }
            }
            return "ERROR - Unknown clock drift correction mode ('" + mode + "')!";
        }
        catch (NumberFormatException exp) {
            return "ERROR - Non-numeric clock drift correction mode setting!";
        }
    }

    public String clockPowerModeInfo() {
        if (this.content == null || this.content.isEmpty()) {
            return NOT_AVAILABLE;
        }
        try {
            int clockMode = Integer.parseInt(this.getValue(TextualFields.GNSS_MODE));
            if (clockMode == 1) {
                return "continuously powered on";
            }
            if (clockMode == 0) {
                int cycleLength = Integer.parseInt(this.getValue(TextualFields.CYCLE_TIME));
                int powerDownMode = Integer.parseInt(this.getValue(TextualFields.GNSS_POWER_DOWN));
                StringBuilder modeInfo = new StringBuilder();
                if (powerDownMode == 0) {
                    int poweredOn = Integer.parseInt(this.getValue(TextualFields.GNSS_MAX_POWERED));
                    modeInfo.append("powered on for ").append(poweredOn).append(" minutes every ");
                    modeInfo.append(cycleLength).append(" minutes");
                } else {
                    modeInfo.append("60 time fixes every ").append(cycleLength);
                    modeInfo.append(" minute");
                }
                return modeInfo.toString();
            }
            return "ERROR - Unknown clock power mode ('" + clockMode + "')!";
        }
        catch (NumberFormatException exp) {
            return "ERROR - Non-numeric clock settings!";
        }
    }

    public String initialGnssPositionInfo() {
        if (this.content == null || this.content.isEmpty()) {
            return NOT_AVAILABLE;
        }
        return this.getValue(TextualFields.GNSS_INITIAL_POSITION);
    }

    public String startRecordingInfo() {
        if (this.content == null || this.content.isEmpty()) {
            return NOT_AVAILABLE;
        }
        int mode = Integer.parseInt(this.getValue(TextualFields.BEGIN_RECORDING));
        switch (mode) {
            case 0: {
                return "on valid clock signal";
            }
            case 1: {
                return "immediately (ignoring clock availability)";
            }
        }
        return "ERROR - Unknown begin of recording mode ('" + mode + "')!";
    }

    public TimeMoment approxRecorderStartup() {
        String date = this.getValue(TextualFields.START_DATE);
        String time = this.getValue(TextualFields.START_TIME);
        if (date == null || date.isEmpty() || time == null || time.isEmpty()) {
            return null;
        }
        try {
            return TimeMoment.parse("20" + date + "T" + time);
        }
        catch (TimeException e) {
            return null;
        }
    }

    public double dcellVoltage() {
        String voltage = this.getValue(TextualFields.VOLTAGE_INTERN);
        try {
            return Double.parseDouble(voltage) / 1000.0;
        }
        catch (NullPointerException | NumberFormatException exception) {
            return Double.NaN;
        }
    }

    public double externVoltage() {
        String voltage = this.getValue(TextualFields.VOLTAGE_EXTERN);
        try {
            return Double.parseDouble(voltage) / 1000.0;
        }
        catch (NullPointerException | NumberFormatException exception) {
            return Double.NaN;
        }
    }

    public double gpsBackupVoltage() {
        String voltage = this.getValue(TextualFields.VOLTAGE_BACKUP);
        try {
            return Double.parseDouble(voltage) / 1000.0;
        }
        catch (NullPointerException | NumberFormatException exception) {
            return Double.NaN;
        }
    }

    public int fileNumber() {
        String number = this.getValue(TextualFields.FILE_NUMBER);
        if (number == null || number.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException exception) {
            throw new IntegrityException("Failed to parse the \"file number\" field ('" + TextualFields.FILE_NUMBER.key() + "') in the header block!", exception);
        }
    }

    public String fileNumberInfo() {
        String value = this.getValue(TextualFields.FILE_NUMBER);
        try {
            if (value == null || value.isEmpty()) {
                return NOT_AVAILABLE;
            }
            int number = Integer.parseInt(value);
            if (number >= 0) {
                return "#" + number;
            }
            return "ERROR - Invalid negative segment number (number=" + number + ")!";
        }
        catch (NumberFormatException e) {
            return "ERROR - Non-numeric file segment number (number=" + value + ")!";
        }
    }

    static enum ClockSource {
        LASSEN_IQ,
        COPERNICUS_II,
        MAX_8,
        CSAC,
        SIMULATOR;

    }

    static enum DigitalFilter {
        LINEAR_PHASE_FIR,
        MINIMUM_PHASE_FIR;

    }

    static enum PowerMode {
        NOT_SUPPORTED,
        LOW_POWER,
        HIGH_RESOLUTION;

    }

    static enum AnalogDigitalConverter {
        ADS1282,
        MAX11214;

    }

    private static enum LoggerComponent {
        FIRMWARE,
        CLOCK_SOURCE,
        DIGITIZER,
        CHANNELS,
        HARDWARE_ID1,
        HARDWARE_ID2;

    }
}

