/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.TimingQualityException;
import de.gfz_potsdam.gipp.common.seis.cube.TraceInfo;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import java.util.logging.Logger;

public class FringeSampleUtils {
    private static final Logger log = Logger.getLogger(FringeSampleUtils.class.getName());

    public static void includeFringeSamples(TraceInfo traceInfo, FringeSampleTreatment fringeSamples) throws NullPointerException, TimingQualityException, UnsupportedOperationException {
        if (traceInfo == null) {
            throw new NullPointerException("Trace information is 'null'.");
        }
        if (fringeSamples == null) {
            throw new NullPointerException("Fringe sample treatment method is 'null'.");
        }
        switch (fringeSamples) {
            case SKIP: {
                if (traceInfo.getTimeTagCount() < 2) {
                    throw new TimingQualityException("Not enough time information available for processing! Need at least two valid time tags.");
                }
                log.fine("Ignoring all samples before the first and after the last GPS (time) fix!");
                break;
            }
            case NOMINAL: {
                if (traceInfo.getTimeTagCount() < 1) {
                    throw new TimingQualityException("Not enough time information available to enable fringe samples! Need at least one valid time tag.");
                }
                TimeSpan deltaT = new TimeSpan.Builder().addSeconds(1L).build();
                long deltaN = traceInfo.getSampleRate();
                traceInfo.timetagFirstSample(deltaT, deltaN);
                traceInfo.timetagLastSample(deltaT, deltaN);
                log.info("Enable access to samples before the first and after the last GPS (time) fix (assuming a perfect sample rate of " + traceInfo.getSampleRate() + " Hz).");
                break;
            }
            case CONSTANT: {
                if (traceInfo.getTimeTagCount() < 2) {
                    throw new TimingQualityException("Not enough time information available to enable fringe samples! Need at least two valid time tags.");
                }
                TimeSpan deltaT = TimeSpan.diff(traceInfo.getLastTimeTag().time(), traceInfo.getFirstTimeTag().time());
                long deltaN = traceInfo.getLastTimeTag().number() - traceInfo.getFirstTimeTag().number();
                traceInfo.timetagFirstSample(deltaT, deltaN);
                traceInfo.timetagLastSample(deltaT, deltaN);
                log.info("Enable access to samples before the first and after the last GPS (time) fix (assuming a constant time drift over the whole recording).");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Oops! The fringe sample treatment method '" + fringeSamples.toString() + "' was not implemented yet! Pleas choose a different one.");
            }
        }
    }

    public static enum FringeSampleTreatment {
        SKIP,
        NOMINAL,
        CONSTANT;

    }
}

