/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.BlockTag;
import de.gfz_potsdam.gipp.common.seis.cube.BlockTagFilter;
import de.gfz_potsdam.gipp.common.seis.cube.TimeTag;
import de.gfz_potsdam.gipp.common.seis.cube.VirtualTimeTag;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class FakeTimeBlockTagFilter
implements BlockTagFilter {
    private static final TimeMoment DEFAULT_FAKE_START_TIME = TimeMoment.UNIX_EPOCH;
    private static final Logger log = Logger.getLogger(FakeTimeBlockTagFilter.class.getName());
    private final TimeMoment fakeStartTime;

    public FakeTimeBlockTagFilter() {
        this(DEFAULT_FAKE_START_TIME);
    }

    public FakeTimeBlockTagFilter(TimeMoment fakeTime) {
        if (fakeTime == null) {
            throw new IllegalArgumentException("No new \"fake start time\" was given!");
        }
        this.fakeStartTime = fakeTime;
    }

    @Override
    public List<BlockTag> process(List<BlockTag> inIndex) {
        if (inIndex == null || inIndex.size() == 0) {
            throw new IllegalArgumentException("The input block list (\"trace index\") must not be empty!");
        }
        ArrayList<BlockTag> outIndex = new ArrayList<BlockTag>(inIndex.size());
        int timeTagsRemoved = 0;
        for (BlockTag tag : inIndex) {
            if (tag instanceof TimeTag) {
                ++timeTagsRemoved;
                continue;
            }
            outIndex.add(tag);
        }
        if (timeTagsRemoved > 0) {
            log.info("Removed " + String.format("%8d", timeTagsRemoved) + " time tags.");
        } else {
            log.info("Found          0 (recorded) time tags.");
        }
        if (outIndex.size() < 2) {
            throw new IllegalStateException("Cube trace index incomplete! (Index contains " + outIndex.size() + " block tags. However, expected two or more tags.)");
        }
        BlockTag firstSample = (BlockTag)outIndex.get(0);
        VirtualTimeTag newTimeTag = new VirtualTimeTag(firstSample.number(), firstSample.file(), firstSample.offset(), this.fakeStartTime);
        outIndex.set(0, newTimeTag);
        log.warning("Added          1 (made-up) time tag (set to " + this.fakeStartTime.toLogString() + ").");
        return outIndex;
    }
}

