/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.BinaryBlock;
import de.gfz_potsdam.gipp.common.seis.cube.CubeException;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.SampleBlock;
import java.io.Serializable;

public class EventRecorderSampleBlock
extends BinaryBlock
implements SampleBlock,
Serializable {
    public static int MIN_VALUE = Short.MIN_VALUE;
    public static int MAX_VALUE = Short.MAX_VALUE;
    private static final long serialVersionUID = 1L;
    private static final int CONTENT_LENGTH = 5;
    private static final int DC_OFFSET = Short.MAX_VALUE;
    private static final int NUM_OF_CHANNELS = 2;

    public EventRecorderSampleBlock() {
        super(5);
    }

    public EventRecorderSampleBlock(int[] data) {
        super(data);
    }

    @Override
    public int getNumberOfChannels() {
        if (this.content.size() != 5) {
            return -1;
        }
        return 2;
    }

    @Override
    public int getValue(int channel) throws CubeException {
        if (this.content.isEmpty()) {
            throw new CubeException("No samples are available yet! Please read/parse a sample block first.");
        }
        if (this.content.size() != 5) {
            throw new IntegrityException("Expected a block size of 6 bytes but got " + (this.content.size() + 1) + ".");
        }
        if (channel < 0) {
            throw new IllegalArgumentException("The channel number ('" + channel + "') must not be negative!");
        }
        switch (channel) {
            case 0: {
                return (((Byte)this.content.get(1) & 0xFF) << 9 | ((Byte)this.content.get(2) & 0xFF) << 2 | (Byte)this.content.get(0) >> 2 & 3) - Short.MAX_VALUE;
            }
            case 1: {
                return (((Byte)this.content.get(3) & 0xFF) << 9 | ((Byte)this.content.get(4) & 0xFF) << 2 | (Byte)this.content.get(0) & 3) - Short.MAX_VALUE;
            }
        }
        StringBuilder channelList = new StringBuilder();
        for (int i = 0; i < 2; ++i) {
            channelList.append(CubeUtils.channelNumberToGippName(i)).append(' ');
        }
        throw new CubeException("No sample value is available for the requested recording channel '" + CubeUtils.channelNumberToGippName(channel) + "' because only " + 2 + "channels recorded in this sample block (" + channelList + ").");
    }

    @Override
    public int[] getAllValues() throws CubeException, IntegrityException {
        if (this.content.isEmpty()) {
            throw new CubeException("No samples are available yet! Please read/parse a sample block first.");
        }
        if (this.content.size() != 5) {
            throw new IntegrityException("Expected a block size of 6 bytes but got " + (this.content.size() + 1) + " bytes.");
        }
        return new int[]{this.getValue(0), this.getValue(1)};
    }

    @Override
    public void setValue(int channel, int value) throws CubeException {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new CubeException("Cannot save '" + value + "' in channel '" + CubeUtils.channelNumberToGippName(channel) + "' channel. Recorder only supports 16-bit values (" + Short.MIN_VALUE + " .. " + Short.MAX_VALUE + ")!");
        }
        while (this.content.size() < 5) {
            this.content.add((byte)-1);
        }
        if (this.content.size() != 5) {
            throw new IntegrityException("Event recorder sample block is too large.");
        }
        short temp = (short)(value + Short.MAX_VALUE);
        switch (channel) {
            case 0: {
                this.content.set(2, (byte)(temp >> 2 & 0x7F));
                this.content.set(1, (byte)(temp >> 9 & 0x7F));
                this.content.set(0, (byte)(temp << 2 & 0xB));
                break;
            }
            case 1: {
                this.content.set(4, (byte)(temp >> 2 & 0x7F));
                this.content.set(3, (byte)(temp >> 9 & 0x7F));
                this.content.set(0, (byte)(temp >> 0 & 3));
                break;
            }
            default: {
                throw new CubeException("The channel number ('" + channel + "') must be in the range from 0 .. " + 1 + "!");
            }
        }
    }

    @Override
    public String toString() {
        if (this.content.isEmpty()) {
            return "[unread]";
        }
        return "[" + this.getValue(0) + "][" + this.getValue(1) + "]";
    }

    public boolean isRecordButtonPressed() {
        if (this.content.isEmpty()) {
            throw new CubeException("No samples are available yet! Please read/parse a sample block first.");
        }
        if (this.content.size() != 5) {
            throw new IntegrityException("Expected a block size of 6 bytes but got " + (this.content.size() + 1) + " bytes.");
        }
        return ((Byte)this.content.get(0) & 0x10) != 0;
    }

    public boolean isTriggerSample() {
        if (this.content.isEmpty()) {
            throw new CubeException("No samples are available yet! Please read/parse a sample block first.");
        }
        if (this.content.size() != 5) {
            throw new IntegrityException("Expected a block size of 6 bytes but got " + (this.content.size() + 1) + " bytes.");
        }
        return ((Byte)this.content.get(0) & 0x40) != 0;
    }
}

