/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.BinaryBlock;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.TimeSpan;

public class DelayBlock
extends BinaryBlock {
    private static final double CLOCK_TICK_DEFAULT = 2.44140625;
    private static final double CLOCK_TICK_NUBE_25HZ = 4.8828125;
    private static final long serialVersionUID = 2L;
    private static final int CONTENT_LENGTH = 2;
    private final double clockTick;

    public DelayBlock(int type) throws IllegalArgumentException {
        super(2);
        this.clockTick = DelayBlock.initClockTick(type);
    }

    public DelayBlock(int type, int[] data) {
        super(data);
        this.clockTick = DelayBlock.initClockTick(type);
    }

    private static double initClockTick(int type) {
        switch (type) {
            case 176: {
                return 2.44140625;
            }
            case 177: {
                return 4.8828125;
            }
        }
        throw new IllegalArgumentException("Unknown delay block type. Expected '" + StringUtils.toHexString((byte)-80) + "' or '" + StringUtils.toHexString((byte)-79) + "' but got '" + StringUtils.toHexString((byte)type) + "'.");
    }

    public TimeSpan getDelay() {
        if (this.content.size() != 2) {
            return null;
        }
        long counts = ((Byte)this.content.get(0) & 0xFF) * 128 + ((Byte)this.content.get(1) & 0xFF);
        return new TimeSpan.Builder().addMicroSeconds(Math.round((double)counts * this.clockTick)).build();
    }

    @Override
    public String toString() {
        if (this.content.size() != 2) {
            return "--unread-delay-block--";
        }
        return this.getDelay().getFullString();
    }
}

