/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.Block;
import de.gfz_potsdam.gipp.common.seis.cube.CubeException;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.SampleBlock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class DataRecorderSampleBlock
extends Block
implements SampleBlock {
    public static int MIN_VALUE = -8388608;
    public static int MAX_VALUE = 0x7FFFFF;
    private static final int SIGN_MASK = 0x800000;
    private final int[] sampleValues = new int[8];
    private int numOfChannels = -1;

    @Override
    public int read(ByteBuffer buffer) throws BufferUnderflowException, IntegrityException {
        assert (buffer != null) : "Input byte buffer must not be 'null'!";
        this.numOfChannels = -1;
        for (int i = 0; i < 8; ++i) {
            this.sampleValues[i] = 0;
        }
        byte[] data = new byte[4];
        for (int i = 0; i < 8; ++i) {
            data[0] = buffer.get();
            if (data[0] < 0) {
                return data[0] & 0xFF;
            }
            data[1] = buffer.get();
            if (data[1] < 0) {
                throw new IntegrityException("Sample value of channel '" + CubeUtils.channelNumberToGippName(i) + "' is incomplete!");
            }
            data[2] = buffer.get();
            if (data[2] < 0) {
                throw new IntegrityException("Sample value of channel '" + CubeUtils.channelNumberToGippName(i) + "' is incomplete!");
            }
            data[3] = buffer.get();
            if (data[3] < 0) {
                throw new IntegrityException("Sample value of channel '" + CubeUtils.channelNumberToGippName(i) + "' is incomplete!");
            }
            this.sampleValues[i] = ((data[0] << 17 | data[1] << 10 | data[2] << 3 | data[3]) ^ 0x800000) - 0x800000;
            this.numOfChannels = i + 1;
        }
        byte nextByte = buffer.get();
        if (nextByte < 0) {
            return nextByte & 0xFF;
        }
        throw new IntegrityException("Number of recorded channels in sample block exceeds the allowed maximum of 8 channels!");
    }

    @Override
    public int read(InputStream stream) throws IOException {
        assert (stream != null) : "Input stream must not be 'null'!";
        this.numOfChannels = -1;
        for (int i = 0; i < 8; ++i) {
            this.sampleValues[i] = 0;
        }
        int[] data = new int[4];
        for (int i = 0; i < 8; ++i) {
            data[0] = stream.read();
            if (data[0] > 127) {
                return data[0];
            }
            data[1] = stream.read();
            if (data[1] > 127) {
                throw new IntegrityException("Sample value of channel '" + CubeUtils.channelNumberToGippName(i) + "' is incomplete!");
            }
            data[2] = stream.read();
            if (data[2] > 127) {
                throw new IntegrityException("Sample value of channel '" + CubeUtils.channelNumberToGippName(i) + "' is incomplete!");
            }
            data[3] = stream.read();
            if (data[3] > 127) {
                throw new IntegrityException("Sample value of channel '" + CubeUtils.channelNumberToGippName(i) + "' is incomplete!");
            }
            this.sampleValues[i] = (((data[0] & 0xFF) << 17 | (data[1] & 0xFF) << 10 | (data[2] & 0xFF) << 3 | data[3] & 0xFF) ^ 0x800000) - 0x800000;
            this.numOfChannels = i + 1;
        }
        int nextByte = stream.read();
        if (nextByte > 127) {
            return nextByte;
        }
        throw new IntegrityException("Number of recorded channels in sample block exceeds the allowed maximum of 8 channels!");
    }

    @Override
    public int read(DataInput source) throws IOException, IntegrityException {
        assert (source != null) : "Data input stream must not be 'null'!";
        this.numOfChannels = -1;
        for (int i = 0; i < 8; ++i) {
            this.sampleValues[i] = 0;
        }
        try {
            int[] data = new int[4];
            for (int i = 0; i < 8; ++i) {
                data[0] = source.readUnsignedByte();
                if (data[0] > 127) {
                    return data[0];
                }
                data[1] = source.readUnsignedByte();
                if (data[1] > 127) {
                    throw new IntegrityException("Sample value of channel '" + CubeUtils.channelNumberToGippName(i) + "' is incomplete!");
                }
                data[2] = source.readUnsignedByte();
                if (data[2] > 127) {
                    throw new IntegrityException("Sample value of channel '" + CubeUtils.channelNumberToGippName(i) + "' is incomplete!");
                }
                data[3] = source.readUnsignedByte();
                if (data[3] > 127) {
                    throw new IntegrityException("Sample value of channel '" + CubeUtils.channelNumberToGippName(i) + "' is incomplete!");
                }
                this.sampleValues[i] = (((data[0] & 0xFF) << 17 | (data[1] & 0xFF) << 10 | (data[2] & 0xFF) << 3 | data[3] & 0xFF) ^ 0x800000) - 0x800000;
                this.numOfChannels = i + 1;
            }
            int nextByte = source.readUnsignedByte();
            if (nextByte > 127) {
                return source.readUnsignedByte();
            }
            throw new IntegrityException("Number of recorded channels in sample block exceeds the allowed maximum of 8 channels!");
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public int write(DataOutput stream) throws IOException {
        assert (stream != null) : "Data output stream must not be 'null'!";
        if (this.numOfChannels <= 0) {
            throw new IntegrityException("Cannot write an uninitialized sample block!");
        }
        stream.writeByte(128);
        int writeCount = 1;
        for (int i = 0; i < this.numOfChannels; ++i) {
            stream.writeByte(this.sampleValues[i] >> 17 & 0x7F);
            stream.writeByte(this.sampleValues[i] >> 10 & 0x7F);
            stream.writeByte(this.sampleValues[i] >> 3 & 0x7F);
            stream.writeByte(this.sampleValues[i] & 0x7F);
            writeCount += 4;
        }
        return writeCount;
    }

    @Override
    public void setValue(int channel, int value) throws CubeException {
        if (channel < 0 || channel >= 8) {
            throw new CubeException("The channel number ('" + channel + "') must be in the range from 0 .. " + 8 + "!");
        }
        if (value < -8388608 || value > 0x7FFFFF) {
            throw new CubeException("Cannot save '" + value + "' in channel '" + CubeUtils.channelNumberToGippName(channel) + "' channel. Recorder only supports 24-bit values (-8388608 .. 8388607)!");
        }
        this.sampleValues[channel] = value;
        this.numOfChannels = Math.max(this.numOfChannels, channel + 1);
    }

    @Override
    public int getNumberOfChannels() {
        return this.numOfChannels;
    }

    @Override
    public int getValue(int channel) throws CubeException {
        if (this.numOfChannels <= 0) {
            throw new CubeException("No samples are available yet! Please read/parse a sample block first.");
        }
        if (channel < 0) {
            throw new CubeException("The channel number ('" + channel + "') must be positive!");
        }
        if (channel >= this.numOfChannels) {
            StringBuilder channelList = new StringBuilder();
            for (int i = 0; i < this.numOfChannels; ++i) {
                channelList.append(CubeUtils.channelNumberToGippName(i)).append(' ');
            }
            throw new CubeException("No sample value is available for the requested recording channel '" + CubeUtils.channelNumberToGippName(channel) + "' because only the channel(s) [ " + channelList + "] were recorded in this sample block.");
        }
        return this.sampleValues[channel];
    }

    @Override
    public int[] getAllValues() throws CubeException {
        if (this.numOfChannels <= 0) {
            throw new CubeException("No samples are available yet! Please read/parse a sample block first.");
        }
        int[] result = new int[this.numOfChannels];
        System.arraycopy(this.sampleValues, 0, result, 0, this.numOfChannels);
        return result;
    }

    public String toString() {
        if (this.numOfChannels > 0) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this.numOfChannels; ++i) {
                buffer.append('[').append(this.sampleValues[i]).append(']');
            }
            return buffer.toString();
        }
        if (this.numOfChannels == -1) {
            return "[unread]";
        }
        return "[invalid]";
    }
}

