/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.file.SortByCubeStream;
import de.gfz_potsdam.gipp.common.file.SortedFileSet;
import de.gfz_potsdam.gipp.common.seis.cube.Block;
import de.gfz_potsdam.gipp.common.seis.cube.BlockTag;
import de.gfz_potsdam.gipp.common.seis.cube.HeaderBlock;
import de.gfz_potsdam.gipp.common.seis.cube.InfoBlock;
import de.gfz_potsdam.gipp.common.seis.cube.TimeTag;
import de.gfz_potsdam.gipp.common.seis.cube.TrailerBlock;
import de.gfz_potsdam.gipp.common.time.LeapSecondInfo;
import de.gfz_potsdam.gipp.common.time.Stopwatch;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class CubeUtils {
    public static final int MAX_CHANNELS = 8;
    private static final Logger log = Logger.getLogger(CubeUtils.class.getName());
    private static final int BLOCK_SEARCH_RANGE = 1024;
    private static final String[] GIPP_CHANNEL_NAMES = new String[8];

    public static String channelNumberToGippName(int channel) {
        if (channel < 0) {
            throw new IllegalArgumentException("The used channel number ('" + channel + "') must not be negative!");
        }
        if (channel >= GIPP_CHANNEL_NAMES.length) {
            throw new IllegalArgumentException("The used channel number ('" + channel + "') is larger than the maximum number ('" + GIPP_CHANNEL_NAMES.length + "') of supported channels.");
        }
        return GIPP_CHANNEL_NAMES[channel];
    }

    public static int gippNameToChannelNumber(String name) {
        assert (name != null) : "The channel 'name' argument must not be 'null'!";
        for (int i = 0; i < GIPP_CHANNEL_NAMES.length; ++i) {
            if (!GIPP_CHANNEL_NAMES[i].equalsIgnoreCase(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown channel name '" + name + "'. Valid names are " + Arrays.toString(GIPP_CHANNEL_NAMES) + ".");
    }

    public static boolean isCubeFile(RandomAccessFile file) throws IOException {
        assert (file != null) : "The 'file' argument must not be 'null'!";
        long savedPos = file.getFilePointer();
        file.seek(0L);
        boolean result = file.read() == 240 && file.read() == 71 && file.read() == 73 && file.read() == 80 && file.read() == 80;
        file.seek(savedPos);
        return result;
    }

    public static boolean isEventRecorderFile(RandomAccessFile file) throws IOException {
        assert (file != null) : "The 'file' argument must not be 'null'!";
        long savedPos = file.getFilePointer();
        file.seek(0L);
        boolean result = file.read() == 240 && file.read() == 71 && file.read() == 73 && file.read() == 80 && file.read() == 80 && file.read() == 61 && file.read() == 69 && file.read() == 82;
        file.seek(savedPos);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLeapSecondListOutdated(File cubeFile) throws FileNotFoundException {
        RandomAccessFile raf;
        block2: {
            boolean bl;
            raf = null;
            try {
                TimeMoment traceStart;
                raf = new RandomAccessFile(cubeFile, "r");
                HeaderBlock fileHeader = CubeUtils.getHeader(raf);
                if (fileHeader == null || (traceStart = fileHeader.approxRecorderStartup()) == null) break block2;
                bl = !LeapSecondInfo.isListUpToDate(traceStart);
            }
            catch (Throwable throwable) {
                FileUtils.flushClose(raf);
                throw throwable;
            }
            FileUtils.flushClose(raf);
            return bl;
        }
        FileUtils.flushClose(raf);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static SortedFileSet buildCubeFileList(List<String> pathNameList, FileFilter fileNameFilter) {
        assert (pathNameList != null) : "The pathname list must not be 'null'!";
        Stopwatch runTime = new Stopwatch();
        SortedFileSet allFilesList = new SortedFileSet(fileNameFilter);
        SortedFileSet cubeFileList = new SortedFileSet(new SortByCubeStream());
        log.info("Searching for Cube input files. This may take a while...");
        for (String fileName : pathNameList) {
            File file = new File(fileName);
            if (file.exists()) {
                allFilesList.add(file);
                continue;
            }
            log.warning("File or directory '" + fileName + "' given at the command line does not exist! Maybe a typing error?");
        }
        RandomAccessFile raf = null;
        for (File file : allFilesList) {
            block17: {
                block16: {
                    block15: {
                        if (file.canRead()) break block15;
                        log.warning("File '" + file.getName() + "' is not readable! File permissions?");
                        FileUtils.flushClose(raf);
                        continue;
                    }
                    if (file.length() != 0L) break block16;
                    log.warning("File '" + file.getName() + "' is zero bytes long!");
                    FileUtils.flushClose(raf);
                    continue;
                }
                try {
                    raf = new RandomAccessFile(file, "r");
                    if (CubeUtils.isCubeFile(raf)) {
                        cubeFileList.add(file);
                        log.fine("Found Cube file '" + file.getName() + "'.");
                        break block17;
                    }
                    log.warning("File '" + file.getAbsolutePath() + "' was ignored! Not a Cube data file!");
                }
                catch (FileNotFoundException e) {
                    log.severe("File '" + file.getAbsolutePath() + "' disappeared!");
                    FileUtils.flushClose(raf);
                    continue;
                }
                catch (IOException e2) {
                    log.severe("File '" + file.getAbsolutePath() + "' could not be read!");
                    {
                        catch (Throwable throwable) {
                            FileUtils.flushClose(raf);
                            throw throwable;
                        }
                    }
                    FileUtils.flushClose(raf);
                    continue;
                }
            }
            FileUtils.flushClose(raf);
        }
        if (cubeFileList.isEmpty()) {
            log.severe("Not a single valid Cube input file was found!");
        } else {
            log.info("Found " + cubeFileList.size() + " Cube files in " + runTime);
        }
        return cubeFileList;
    }

    public static OutputStream newCubeOutputStream(File outDir, File cubeFile, boolean overwrite) throws IllegalArgumentException, IOException {
        if (outDir == null || cubeFile == null) {
            return new BufferedOutputStream(System.out);
        }
        if (!outDir.isDirectory()) {
            throw new IllegalArgumentException("Given output directory '" + outDir.getCanonicalPath() + "'is not a directory!");
        }
        if (!outDir.canWrite()) {
            throw new IOException("Output directory '" + outDir.getCanonicalPath() + "' is not writable!");
        }
        int copyCount = 0;
        File outFile = new File(outDir, cubeFile.getName());
        if (overwrite) {
            if (outFile.exists()) {
                log.warning("The file \"" + outFile.getPath() + "\" already exists and will be overwritten!");
            }
        } else {
            while (outFile.exists()) {
                log.warning("The file \"" + outFile.getName() + "\" already exists!");
                outFile = new File(outDir, FileUtils.getBasename(cubeFile) + "." + ++copyCount + "." + FileUtils.getSuffix(cubeFile));
            }
            log.info("Writing to '" + outFile.getCanonicalPath() + "'.");
        }
        return Files.newOutputStream(outFile.toPath(), new OpenOption[0]);
    }

    public static HeaderBlock getHeader(RandomAccessFile file) {
        assert (file != null) : "The 'file' argument must not be 'null'!";
        try {
            HeaderBlock header = null;
            long savedPos = file.getFilePointer();
            file.seek(0L);
            while (file.getFilePointer() < 1024L) {
                if (Block.skip(file) != 240) continue;
                header = new HeaderBlock();
                header.read(file);
                break;
            }
            file.seek(savedPos);
            return header;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<InfoBlock> getInfos(RandomAccessFile file, long start, long length) {
        assert (file != null) : "The 'file' argument must not be 'null'!";
        ArrayList<InfoBlock> result = new ArrayList<InfoBlock>(5);
        long savedPos = 0L;
        try {
            savedPos = file.getFilePointer();
            file.seek(start);
            int blockType = Block.skip(file);
            while (file.getFilePointer() < start + length) {
                if (blockType == 208) {
                    InfoBlock info = new InfoBlock();
                    blockType = info.read(file);
                    result.add(info);
                    continue;
                }
                blockType = Block.skip(file);
            }
            ArrayList<InfoBlock> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            List<InfoBlock> list = null;
            return list;
        }
        finally {
            try {
                file.seek(savedPos);
            }
            catch (IOException e) {
                log.severe("Error while restoring file-pointer offset. (" + e.getMessage() + ")");
            }
        }
    }

    public static TrailerBlock getTrailer(RandomAccessFile file) {
        assert (file != null) : "The 'file' argument must not be 'null'!";
        try {
            long savedPos = file.getFilePointer();
            TrailerBlock trailer = null;
            file.seek(Math.max(file.length() - 1024L, 0L));
            while (file.getFilePointer() < file.length()) {
                if (Block.skip(file) != 224) continue;
                trailer = new TrailerBlock();
                trailer.read(file);
                break;
            }
            file.seek(savedPos);
            return trailer;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean hasEofBlock(RandomAccessFile file) {
        assert (file != null) : "The 'file' argument must not be 'null'!";
        try {
            long savedPos = file.getFilePointer();
            file.seek(Math.max(file.length() - 1L, 0L));
            boolean result = Block.skip(file) == 239;
            file.seek(savedPos);
            return result;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static TimeTag getFirstTimeTag(List<BlockTag> list) {
        assert (list != null) : "The list must not be 'null'.";
        return CubeUtils.getNextTimeTag(list.listIterator(0));
    }

    public static TimeTag getNextTimeTag(ListIterator<BlockTag> iter) {
        assert (iter != null) : "The list iterator must not be 'null'.";
        while (iter.hasNext()) {
            BlockTag tag = iter.next();
            if (!(tag instanceof TimeTag)) continue;
            return (TimeTag)((Object)tag);
        }
        return null;
    }

    public static TimeTag getPreviousTimeTag(ListIterator<BlockTag> iter) {
        assert (iter != null) : "The list iterator must not be 'null'.";
        while (iter.hasPrevious()) {
            BlockTag tag = iter.previous();
            if (!(tag instanceof TimeTag)) continue;
            return (TimeTag)((Object)tag);
        }
        return null;
    }

    static {
        for (int i = 0; i < GIPP_CHANNEL_NAMES.length; ++i) {
            CubeUtils.GIPP_CHANNEL_NAMES[i] = "p" + i;
        }
    }
}

