/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.seis.Sample;
import de.gfz_potsdam.gipp.common.seis.TraceReader;
import de.gfz_potsdam.gipp.common.seis.UnevenlySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.seis.cube.Block;
import de.gfz_potsdam.gipp.common.seis.cube.CubeException;
import de.gfz_potsdam.gipp.common.seis.cube.DataRecorderSampleBlock;
import de.gfz_potsdam.gipp.common.seis.cube.EventRecorderSampleBlock;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.seis.cube.TimeTag;
import de.gfz_potsdam.gipp.common.seis.cube.TraceInfo;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.common.time.TimeWindow;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class CubeTraceReader
extends TraceReader {
    private static final int DEFAULT_CHUNK_SIZE = 0x100000;
    private boolean isClosed;
    private final TraceInfo traceInfo;
    private final long stopIndex;
    private long nextIndex;

    public static CubeTraceReader newFromTrace(TraceInfo traceInfo, TimeMoment startTime, long sampleCount) {
        long startIndex;
        if (traceInfo == null) {
            throw new IllegalArgumentException("The trace info argument must not be 'null'!");
        }
        if (startTime == null) {
            throw new IllegalArgumentException("A 'null' start time was requested!");
        }
        if (sampleCount <= 0L) {
            throw new IllegalArgumentException("The number of samples to be read must be a positive number!");
        }
        TimeTag first = traceInfo.getFirstTimeTag();
        TimeTag last = traceInfo.getLastTimeTag();
        if (startTime.beforeOrAt(last.time())) {
            TimeMoment begin = TimeMoment.last(first.time(), startTime);
            startIndex = begin.beforeOrAt(first.time()) ? first.number() : traceInfo.getClosestIndex(startTime);
        } else {
            return null;
        }
        long stopIndex = Math.min(startIndex + sampleCount - 1L, last.number());
        return new CubeTraceReader(traceInfo, startIndex, stopIndex);
    }

    public static CubeTraceReader newFromTrace(TraceInfo traceInfo, TimeWindow requestWindow) throws IllegalArgumentException {
        long stopIndex;
        long startIndex;
        if (traceInfo == null) {
            throw new IllegalArgumentException("The trace info argument must not be 'null'!");
        }
        if (requestWindow == null) {
            throw new IllegalArgumentException("A 'null' time window was requested!");
        }
        TimeTag first = traceInfo.getFirstTimeTag();
        TimeTag last = traceInfo.getLastTimeTag();
        if (requestWindow.getStart().beforeOrAt(last.time())) {
            TimeMoment begin = TimeMoment.last(first.time(), requestWindow.getStart());
            startIndex = begin.before(first.time()) ? first.number() : traceInfo.getLastIndexBefore(begin, true);
        } else {
            return null;
        }
        if (requestWindow.getStop().afterOrAt(first.time())) {
            TimeMoment end = TimeMoment.first(last.time(), requestWindow.getStop());
            stopIndex = end.after(last.time()) ? last.number() : traceInfo.getFirstIndexAfter(end, true);
        } else {
            return null;
        }
        return new CubeTraceReader(traceInfo, startIndex, stopIndex);
    }

    private CubeTraceReader(TraceInfo traceInfo, long firstSample, long lastSample) {
        assert (traceInfo != null) : "The trace info argument must not be null!";
        assert (firstSample >= traceInfo.getFirstTimeTag().number()) : "Cannot read samples from before the first time tag!";
        assert (lastSample <= traceInfo.getLastTimeTag().number()) : "Cannot read samples past last the time tag!";
        this.traceInfo = traceInfo;
        this.isClosed = false;
        this.nextIndex = firstSample;
        this.stopIndex = lastSample;
    }

    @Override
    public UnevenlySpacedTimeSeries read() throws IntegrityException, FileNotFoundException, IOException {
        return this.read(0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public UnevenlySpacedTimeSeries read(int maxSamples) throws IllegalArgumentException, IntegrityException, FileNotFoundException, IOException {
        if (!CubeTraceReader.$assertionsDisabled && this.traceInfo == null) {
            throw new AssertionError((Object)"No information about the trace available!");
        }
        if (!CubeTraceReader.$assertionsDisabled && this.nextIndex < 0L) {
            throw new AssertionError((Object)"The sample index number must not be negative!");
        }
        if (maxSamples <= 0) {
            throw new IllegalArgumentException("The number or requested samples must be a positive integer and greater than zero!");
        }
        if (this.isClosed || this.nextIndex > this.stopIndex) {
            return null;
        }
        dataPoints = new ArrayList<Sample>(maxSamples);
        cubeStream = null;
        try {
            anchorTag = null;
            leftTag = null;
            rightTag = null;
            iter = this.traceInfo.getIndex().iterator();
            while (iter.hasNext()) {
                tag = iter.next();
                if (tag.number() <= this.nextIndex) {
                    anchorTag = tag;
                    if (!(anchorTag instanceof TimeTag)) continue;
                    leftTag = (TimeTag)tag;
                    continue;
                }
                if (tag instanceof TimeTag) {
                    rightTag = (TimeTag)tag;
                    break;
                }
                while (iter.hasNext()) {
                    tag = iter.next();
                    if (!(tag instanceof TimeTag)) continue;
                    rightTag = (TimeTag)tag;
                    break;
                }
                break;
            }
            if (!CubeTraceReader.$assertionsDisabled && anchorTag == null) {
                throw new AssertionError((Object)"The 'anchor' tag must not be 'null'.");
            }
            if (!CubeTraceReader.$assertionsDisabled && leftTag == null) {
                throw new AssertionError((Object)"The 'left' tag must not be 'null'.");
            }
            if (!CubeTraceReader.$assertionsDisabled && rightTag == null) {
                throw new AssertionError((Object)"The 'right' tag must not be 'null'.");
            }
            if (!CubeTraceReader.$assertionsDisabled && leftTag.number() > anchorTag.number()) {
                throw new AssertionError((Object)"The 'left' tag must come before the 'anchor' tag.");
            }
            if (!CubeTraceReader.$assertionsDisabled && anchorTag.number() > rightTag.number()) {
                throw new AssertionError((Object)"The 'anchor' tag must come before the 'right' tag.");
            }
            if (!CubeTraceReader.$assertionsDisabled && anchorTag.offset() <= 0L) {
                throw new AssertionError((Object)"The 'anchor' tag offset must not be zero.");
            }
            cubeStream = new BufferedInputStream(new FileInputStream(anchorTag.file()));
            skipped = cubeStream.skip(anchorTag.offset() - 1L);
            if (!CubeTraceReader.$assertionsDisabled && skipped != anchorTag.offset() - 1L) {
                throw new AssertionError((Object)"Failed to forward to the 'anchor tag'!");
            }
            blockFlag = cubeStream.read() & 255;
            if (!CubeTraceReader.$assertionsDisabled && blockFlag <= 127) {
                throw new AssertionError((Object)("Expected a block flag (i.e value > 127) but got " + blockFlag + " instead!"));
            }
            currentIndex = anchorTag.number();
            expectedChannels = this.traceInfo.getNumberOfChannels();
            dataRecorderSample = new DataRecorderSampleBlock();
            eventRecorderSample = new EventRecorderSampleBlock();
            sample = null;
            block8: while (currentIndex <= this.stopIndex && blockFlag != -1 && dataPoints.size() < maxSamples) {
                switch (blockFlag) {
                    case 128: 
                    case 136: 
                    case 144: 
                    case 152: {
                        if (currentIndex < this.nextIndex || currentIndex > this.stopIndex) ** GOTO lbl88
                        if (blockFlag == 128 || blockFlag == 144) {
                            blockFlag = dataRecorderSample.read(cubeStream);
                            sample = dataRecorderSample;
                        } else if (blockFlag == 136 || blockFlag == 152) {
                            blockFlag = eventRecorderSample.read(cubeStream);
                            sample = eventRecorderSample;
                        } else {
                            throw new CubeException("Oops! Unknown sample block (id=" + blockFlag + ").");
                        }
                        time = null;
                        if (currentIndex != leftTag.number()) ** GOTO lbl73
                        time = leftTag.time();
                        ** GOTO lbl83
lbl73:
                        // 1 sources

                        if (currentIndex != rightTag.number()) ** GOTO lbl82
                        time = rightTag.time();
                        while (iter.hasNext()) {
                            tag = iter.next();
                            if (!(tag instanceof TimeTag)) continue;
                            leftTag = rightTag;
                            rightTag = (TimeTag)tag;
                            ** GOTO lbl83
                        }
                        ** GOTO lbl83
lbl82:
                        // 1 sources

                        time = TimeSpan.add(leftTag.time(), TimeSpan.multiply(TimeSpan.diff(rightTag.time(), leftTag.time()), (double)(currentIndex - leftTag.number()) / (double)(rightTag.number() - leftTag.number())));
lbl83:
                        // 4 sources

                        if (sample.getNumberOfChannels() != expectedChannels) {
                            throw new IntegrityException("Bad sample block at approximately " + time.toLogString() + "! Expected " + expectedChannels + " channel(s) of data but got " + sample.getNumberOfChannels() + " channel(s) instead.");
                        }
                        dataPoints.add(new Sample(time, sample.getAllValues()));
                        ** GOTO lbl89
lbl88:
                        // 1 sources

                        blockFlag = Block.skip(cubeStream);
lbl89:
                        // 2 sources

                        ++currentIndex;
                        continue block8;
                    }
                    case -1: {
                        continue block8;
                    }
                }
                blockFlag = Block.skip(cubeStream);
            }
            this.nextIndex = currentIndex;
        }
        catch (Throwable var19_18) {
            FileUtils.flushClose(cubeStream);
            throw var19_18;
        }
        FileUtils.flushClose(cubeStream);
        if (dataPoints.isEmpty()) {
            return null;
        }
        return new UnevenlySpacedTimeSeries(dataPoints);
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }
}

