/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.InfoBlock;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChecksumBlock
extends InfoBlock {
    private static final long serialVersionUID = 1L;

    public ChecksumBlock() {
    }

    protected ChecksumBlock(MessageDigest digest) {
        super(digest.getAlgorithm() + "=" + StringUtils.toHexString(digest.digest()));
    }

    @Override
    public int write(DataOutput stream) throws IOException {
        return this.write(stream, 236);
    }

    public boolean verify(MessageDigest digest) {
        if (this.content == null) {
            return false;
        }
        Pattern p = Pattern.compile(digest.getAlgorithm() + "=([^;]+)");
        Matcher m = p.matcher(this.content);
        if (m.find()) {
            return m.group(1).equalsIgnoreCase(StringUtils.toHexString(digest.digest()));
        }
        digest.reset();
        return false;
    }
}

