/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.string.StringUtils;
import java.io.File;
import java.io.Serializable;

public class BlockTag
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long number;
    private final File file;
    private final long offset;

    public BlockTag(long number, File file, long offset) {
        assert (number >= 0L);
        assert (file != null);
        assert (offset >= 0L);
        this.number = number;
        this.file = file;
        this.offset = offset;
    }

    public String toString() {
        return "file '" + this.file.getName() + "', offset 0x" + StringUtils.toHexString(this.offset, 8) + ", sample #" + this.number;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.number ^ this.number >>> 32);
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + this.file.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockTag)) {
            return false;
        }
        BlockTag other = (BlockTag)obj;
        if (this.number != other.number) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return this.file.equals(other.file);
    }

    public long number() {
        return this.number;
    }

    public File file() {
        return this.file;
    }

    public long offset() {
        return this.offset;
    }
}

