/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.Block;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;

public class BinaryBlock
extends Block
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final int expectedSize;
    protected final List<Byte> content;

    public BinaryBlock() {
        this(-1);
    }

    protected BinaryBlock(int contentSize) {
        this.expectedSize = contentSize;
        this.content = contentSize > 0 ? new ArrayList<Byte>(contentSize) : new ArrayList<Byte>();
    }

    BinaryBlock(int[] data) {
        this(data.length);
        for (int value : data) {
            assert (value >= 0 && value <= 255) : "Input value out of range!";
            this.content.add((byte)(0xFF & value));
        }
    }

    @Override
    public int read(ByteBuffer inBuffer) throws BufferUnderflowException {
        this.content.clear();
        while (inBuffer.hasRemaining()) {
            byte value = inBuffer.get();
            if (value < 0) {
                if (this.expectedSize >= 0 && this.expectedSize != this.content.size()) {
                    throw new IntegrityException("Expected a block content size of " + this.expectedSize + " bytes but got " + this.content.size() + " bytes instead.");
                }
                return value & 0xFF;
            }
            this.content.add(value);
        }
        throw new BufferUnderflowException();
    }

    @Override
    public int read(InputStream stream) throws IOException {
        this.content.clear();
        while (true) {
            int value;
            if ((value = stream.read()) > 127 || value < 0) {
                if (this.expectedSize >= 0 && this.expectedSize != this.content.size()) {
                    throw new IntegrityException("Expected a block content size of " + this.expectedSize + " bytes but got " + this.content.size() + " bytes instead.");
                }
                return value;
            }
            this.content.add((byte)value);
        }
    }

    @Override
    public int read(DataInput source) throws IOException {
        this.content.clear();
        try {
            while (true) {
                int value;
                if ((value = source.readUnsignedByte()) > 127) {
                    if (this.expectedSize >= 0 && this.expectedSize != this.content.size()) {
                        throw new IntegrityException("Expected a block content size of " + this.expectedSize + " bytes but got " + this.content.size() + " bytes instead.");
                    }
                    return value;
                }
                this.content.add((byte)value);
            }
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public int write(DataOutput stream, int blockType) throws IOException {
        if (blockType < 128 || blockType >= 255) {
            throw new IntegrityException("Invalid block type. An ID of 0x" + StringUtils.toHexString(blockType, 2) + " was given but only numbers in the range 0x80 to 0xff are possible!");
        }
        if (this.content == null) {
            throw new IntegrityException("Cannot write an uninitialized block!");
        }
        if (this.expectedSize >= 0 && this.expectedSize != this.content.size()) {
            throw new IntegrityException("Cannot write an incomplete block. Expected " + this.expectedSize + " bytes but got " + this.content.size() + " bytes.");
        }
        stream.writeByte(blockType);
        for (Byte data : this.content) {
            stream.writeByte(data.byteValue());
        }
        return this.content.size() + 1;
    }

    public String toString() {
        if (this.content.isEmpty()) {
            return "--unread-binary-block--";
        }
        StringBuilder message = new StringBuilder();
        for (Byte value : this.content) {
            message.append("0x");
            message.append(StringUtils.toHexString(value));
            message.append(' ');
        }
        return message.toString();
    }

    public int hashCode() {
        return this.content.hashCode() * 31 + this.expectedSize;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BinaryBlock)) {
            return false;
        }
        BinaryBlock other = (BinaryBlock)obj;
        if (this.expectedSize != other.expectedSize) {
            return false;
        }
        if (this.content == null) {
            return other.content == null;
        }
        return this.content.equals(other.content);
    }

    public void updateDigest(MessageDigest digest) {
        for (byte value : this.content) {
            digest.update(value);
        }
    }

    public byte[] getContent() {
        byte[] result = new byte[this.content.size()];
        for (int i = 0; i < this.content.size(); ++i) {
            result[i] = this.content.get(i);
        }
        return result;
    }
}

