/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.cube;

import de.gfz_potsdam.gipp.common.seis.cube.AuxiliaryUnits;
import de.gfz_potsdam.gipp.common.seis.cube.BinaryBlock;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;

public class AuxiliaryBlock
extends BinaryBlock {
    private static final long serialVersionUID = 1L;
    private static final int SIGN_MASK = 0x100000;
    private static final String FIELD_SEPARATOR = "; ";
    private static final char UNIT_SEPARATOR = ' ';
    private static final int AUX_INFO_OFFSET = 0;
    private static final int AUX_DATA_OFFSET = 1;
    private static final int AUX_HEADER_SIZE = 2;

    public AuxiliaryBlock() {
    }

    AuxiliaryBlock(int[] data) {
        super(data);
    }

    private int sizeOfData() {
        int totalBlockSize = (Byte)this.content.get(0) & 0xF;
        assert (totalBlockSize >= 2) : "An auxiliary block must be at least 2 bytes long!";
        assert (totalBlockSize - 2 < this.content.size()) : "Auxiliary block claims to be larger than content array!";
        return totalBlockSize - 2;
    }

    public boolean isLast() {
        return ((Byte)this.content.get(0) & 0x20) == 0;
    }

    public boolean isAscii() {
        return ((Byte)this.content.get(0) & 0x40) != 0;
    }

    public boolean isBinary() {
        return ((Byte)this.content.get(0) & 0x40) == 0;
    }

    @Override
    public String toString() {
        if (this.content.isEmpty()) {
            return "--unread-auxiliary-block--";
        }
        StringBuilder message = new StringBuilder();
        if (this.isAscii()) {
            for (int i = 1; i <= this.sizeOfData(); ++i) {
                message.append((char)((Byte)this.content.get(i)).byteValue());
            }
        } else if (this.isBinary()) {
            int i = 1;
            switch (this.sizeOfData()) {
                case 12: {
                    String unit = AuxiliaryUnits.getUnitSymbol(((Byte)this.content.get(i++)).byteValue());
                    int value = ((((Byte)this.content.get(i++) & 0xFF) << 14 | ((Byte)this.content.get(i++) & 0xFF) << 7 | (Byte)this.content.get(i++) & 0xFF) ^ 0x100000) - 0x100000;
                    if (unit.isEmpty()) {
                        message.append(value).append(FIELD_SEPARATOR);
                    } else {
                        message.append(value).append(' ').append(unit).append(FIELD_SEPARATOR);
                    }
                }
                case 8: {
                    String unit = AuxiliaryUnits.getUnitSymbol(((Byte)this.content.get(i++)).byteValue());
                    int value = ((((Byte)this.content.get(i++) & 0xFF) << 14 | ((Byte)this.content.get(i++) & 0xFF) << 7 | (Byte)this.content.get(i++) & 0xFF) ^ 0x100000) - 0x100000;
                    if (unit.isEmpty()) {
                        message.append(value).append(FIELD_SEPARATOR);
                    } else {
                        message.append(value).append(' ').append(unit).append(FIELD_SEPARATOR);
                    }
                }
                case 4: {
                    String unit = AuxiliaryUnits.getUnitSymbol(((Byte)this.content.get(i++)).byteValue());
                    int value = ((((Byte)this.content.get(i++) & 0xFF) << 14 | ((Byte)this.content.get(i++) & 0xFF) << 7 | (Byte)this.content.get(i) & 0xFF) ^ 0x100000) - 0x100000;
                    if (unit.isEmpty()) {
                        message.append(value);
                        break;
                    }
                    message.append(value).append(' ').append(unit);
                    break;
                }
                default: {
                    throw new IntegrityException("Illegal auxiliary block size for binary data!");
                }
            }
        } else {
            throw new IntegrityException("Unknown auxiliary data format!");
        }
        return message.toString();
    }
}

