/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.ascii;

import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.seis.EquallySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.seis.Sample;
import de.gfz_potsdam.gipp.common.seis.TimeSeries;
import de.gfz_potsdam.gipp.common.seis.TraceWriter;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.TraceInfo;
import de.gfz_potsdam.gipp.common.string.StringUtils;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.common.time.TimeWindow;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;

public class AsciiTraceWriter
extends TraceWriter {
    private static final int DEFAULT_CHUNK_SIZE = 16384;
    private static final int MAX_DECIMAL_PLACES = 15;
    private static final Locale OUTPUT_LOCALE = Locale.ENGLISH;
    private static final Logger log = Logger.getLogger(AsciiTraceWriter.class.getName());
    private boolean isClosed;
    private int chunkSize;
    private final LinkedList<Sample> sampleBuffer;
    private List<String> traceHeader;
    private List<Integer> printChannels;
    private PrintWriter printWriter;
    private TimeMoment nextFileTime;
    private final TimeWindow timeWindow;
    private final File outputDir;
    private final String traceName;
    private TimeSpan traceSamplePeriod;
    private final boolean forceOverwrite;
    private final LinkedList<TimeMoment> splitTimes;

    private static void printDefaultHeader(PrintWriter out, String traceID, TimeMoment startTime, TimeSpan samplePeriod) {
        assert (out != null) : "The 'out' PrintWriter must not be null!";
        String station = traceID != null && traceID.length() > 0 ? traceID : "unknown";
        String start = startTime != null ? startTime.toDateTimeString() : "unknown";
        String rate = samplePeriod != null && samplePeriod.getSeconds() != 0.0 ? StringUtils.roundedNumber(1.0 / samplePeriod.getSeconds(), 0, 6) : "unknown";
        out.format(OUTPUT_LOCALE, "# station: '%s', first sample: %s, sample rate: %s sps%n", station, start, rate);
        out.flush();
    }

    private static void printStaticHeader(PrintWriter out, List<String> headerLines) {
        if (headerLines == null) {
            return;
        }
        for (String line : headerLines) {
            out.format(OUTPUT_LOCALE, "%s%n", line);
        }
        out.flush();
    }

    private static void printFullSampleData(PrintWriter out, Sample sample) {
        assert (out != null) : "Argument 'out' must not be null.";
        StringBuilder values = new StringBuilder();
        if (sample.getNumberOfChannels() == 0) {
            values = new StringBuilder();
        } else if (sample.getNumberOfChannels() == 1) {
            values = new StringBuilder(StringUtils.roundedNumber(sample.getValue(0), 0, 15));
        } else {
            values = new StringBuilder(StringUtils.roundedNumber(sample.getValue(0), 0, 15));
            for (int channel = 1; channel < sample.getNumberOfChannels(); ++channel) {
                values.append("  ");
                values.append(StringUtils.roundedNumber(sample.getValue(channel), 0, 15));
            }
        }
        out.format(OUTPUT_LOCALE, "%s  %s  %s%n", sample.getTime().toDateString(), sample.getTime().toTimeString(), values.toString());
    }

    private static void printSampleColumns(PrintWriter out, List<Integer> channelList, Sample sample) {
        assert (out != null) : "Argument 'out' must not be null.";
        assert (channelList != null) : "Channel list must not be null.";
        if (channelList.size() == 0) {
            return;
        }
        StringBuilder values = new StringBuilder();
        if (channelList.get(0) >= 0 && channelList.get(0) <= sample.getNumberOfChannels()) {
            values.append(StringUtils.roundedNumber(sample.getValue(channelList.get(0)), 0, 15));
        } else {
            values.append("n/a");
        }
        if (channelList.size() > 1) {
            for (int channel = 1; channel < channelList.size(); ++channel) {
                values.append("  ");
                if (channel >= 0 && channel < sample.getNumberOfChannels()) {
                    values.append(StringUtils.roundedNumber(sample.getValue(channel), 0, 15));
                    continue;
                }
                values.append("n/a");
            }
        }
        out.format(OUTPUT_LOCALE, "%s%n", values.toString());
    }

    public static AsciiTraceWriter newFromCube(TraceInfo cubeTraceInfo, File outputDir, boolean forceOverwrite, TimeWindow requestWindow) {
        if (cubeTraceInfo == null) {
            throw new IllegalArgumentException("Cube trace info argument must not be 'null'!");
        }
        if (requestWindow == null) {
            throw new IllegalArgumentException("Request window argument must not be 'null'!");
        }
        LinkedList<TimeMoment> startFilesAtList = AsciiTraceWriter.generateDayFileTimes(requestWindow);
        return new AsciiTraceWriter(outputDir, forceOverwrite, requestWindow, startFilesAtList, cubeTraceInfo.getCubeName());
    }

    public static AsciiTraceWriter newStreamWriter(OutputStream outStream, int blockSize) {
        TimeWindow largeWindow = new TimeWindow(TimeMoment.LONG_AGO, TimeMoment.FAR_FUTURE);
        AsciiTraceWriter writer = new AsciiTraceWriter(null, false, largeWindow, null, null);
        if (blockSize > 0) {
            writer.chunkSize = blockSize;
        }
        if (outStream != null) {
            writer.printWriter = new PrintWriter(outStream);
            writer.nextFileTime = TimeMoment.MAX_VALUE;
            writer.splitTimes.clear();
        }
        return writer;
    }

    private AsciiTraceWriter(File outputDir, boolean forceOverwrite, TimeWindow requestWindow, LinkedList<TimeMoment> splitTimes, String stationName) {
        assert (requestWindow != null) : "Parameter 'requestWindow' must not be null!";
        this.sampleBuffer = new LinkedList();
        this.chunkSize = 16384;
        this.printWriter = null;
        this.isClosed = false;
        this.traceName = stationName;
        this.outputDir = outputDir;
        this.forceOverwrite = forceOverwrite;
        this.traceHeader = null;
        this.printChannels = null;
        this.traceSamplePeriod = null;
        this.timeWindow = requestWindow != null ? requestWindow : new TimeWindow(TimeMoment.LONG_AGO, TimeMoment.FAR_FUTURE);
        this.splitTimes = splitTimes != null ? splitTimes : new LinkedList();
        this.nextFileTime = this.splitTimes.size() > 0 ? this.splitTimes.poll() : TimeMoment.MAX_VALUE;
    }

    public AsciiTraceWriter clearStaticHeader() {
        if (this.traceHeader == null) {
            this.traceHeader = new ArrayList<String>(0);
        } else {
            this.traceHeader.clear();
        }
        return this;
    }

    public AsciiTraceWriter enableDefaultHeader() {
        if (this.traceHeader != null) {
            this.traceHeader.clear();
            this.traceHeader = null;
        }
        return this;
    }

    public AsciiTraceWriter addHeaderLine(String text) {
        if (this.traceHeader == null) {
            this.traceHeader = new ArrayList<String>(0);
        }
        if (text == null || text.length() == 0) {
            this.traceHeader.add("#");
        } else if (text.startsWith("#")) {
            this.traceHeader.add(text);
        } else {
            this.traceHeader.add("# " + text);
        }
        return this;
    }

    public AsciiTraceWriter addMinimalCubeHeader(TraceInfo traceInfo) {
        if (this.traceHeader == null) {
            this.traceHeader = new ArrayList<String>(0);
        }
        List<Integer> gainList = traceInfo.getGainSetting();
        StringBuilder gainInfo = new StringBuilder();
        StringBuilder channelInfo = new StringBuilder();
        for (int i = 0; i < traceInfo.getNumberOfChannels(); ++i) {
            channelInfo.append(' ').append(CubeUtils.channelNumberToGippName(i));
            gainInfo.append(' ').append(gainList.get(i));
        }
        this.traceHeader.add("# Recorder: " + traceInfo.getCubeName() + ", Channels:" + channelInfo.toString() + ", Gains:" + gainInfo.toString() + ", Rate: " + traceInfo.getSampleRate() + " sps");
        return this;
    }

    public AsciiTraceWriter addFullCubeHeader(TraceInfo traceInfo) {
        if (this.traceHeader == null) {
            this.traceHeader = new ArrayList<String>(0);
        }
        List<Integer> gainList = traceInfo.getGainSetting();
        StringBuilder gainInfo = new StringBuilder();
        StringBuilder channelInfo = new StringBuilder();
        for (int i = 0; i < traceInfo.getNumberOfChannels(); ++i) {
            channelInfo.append(String.format("%3s ", CubeUtils.channelNumberToGippName(i)));
            gainInfo.append(String.format("%3d ", gainList.get(i)));
        }
        this.traceHeader.add("# ------------------------------------------------------------------------");
        this.traceHeader.add("#          experiment name:  " + traceInfo.getExperimentName());
        this.traceHeader.add("# ------------------------------------------------------------------------");
        this.traceHeader.add("#           recording unit:  " + traceInfo.getCubeName());
        this.traceHeader.add("#        recorded channels: " + StringUtils.trimTrailing(channelInfo.toString()));
        this.traceHeader.add("#     amplification factor: " + StringUtils.trimTrailing(gainInfo.toString()));
        this.traceHeader.add("#              sample rate:  " + traceInfo.getSampleRate() + " samples per second");
        this.traceHeader.add("# ------------------------------------------------------------------------");
        return this;
    }

    public AsciiTraceWriter enableAllColumns() {
        if (this.printChannels != null) {
            this.printChannels.clear();
            this.printChannels = null;
        }
        return this;
    }

    public AsciiTraceWriter addOutputChannels(int ... channels) {
        if (this.printChannels == null) {
            this.printChannels = new ArrayList<Integer>(8);
        }
        if (channels == null || channels.length <= 0) {
            return this;
        }
        for (int i : channels) {
            if (i < 0) continue;
            this.printChannels.add(i);
        }
        return this;
    }

    private File getOutputFilename(String traceId, TimeMoment startTime) {
        String name = traceId == null || traceId.length() == 0 ? "unknown" : traceId.toLowerCase();
        String time = startTime == null ? "999999999999" : startTime.toMinimalString();
        int copyCount = 0;
        File outPath = new File(this.outputDir, name + time + ".txt");
        if (this.forceOverwrite) {
            if (outPath.exists()) {
                log.warning("The file \"" + outPath.getPath() + "\" already exists and will be overwritten!");
            }
        } else {
            while (outPath.exists()) {
                log.warning("The file \"" + outPath.getName() + "\" already exists!");
                outPath = new File(this.outputDir, name + time + "." + ++copyCount + ".txt");
            }
        }
        return outPath;
    }

    private void writeBuffer(int numOfSamples) throws IOException {
        if (this.sampleBuffer == null || numOfSamples == 0) {
            return;
        }
        if (numOfSamples < 0) {
            throw new IllegalArgumentException("Cannot write() a negative number of samples.");
        }
        int maxCount = Math.min(numOfSamples, this.sampleBuffer.size());
        for (int i = 0; i < maxCount; ++i) {
            Sample sample = this.sampleBuffer.poll();
            assert (sample != null) : "Failed to read the next sample from the output sample buffer!";
            assert (this.nextFileTime != null);
            if (this.outputDir != null && sample.getTime().afterOrAt(this.nextFileTime)) {
                FileUtils.flushClose(this.printWriter);
                this.printWriter = null;
                this.nextFileTime = this.splitTimes.isEmpty() ? TimeMoment.MAX_VALUE : this.splitTimes.poll();
            }
            if (this.printWriter == null) {
                if (this.outputDir == null) {
                    this.printWriter = new PrintWriter(System.out, true);
                    log.fine("(Re-)opening console for writing.");
                } else {
                    File asciiFile = this.getOutputFilename(this.traceName, sample.getTime());
                    this.printWriter = new PrintWriter(asciiFile);
                    log.info("Writing to file '" + asciiFile.getName() + "'");
                }
                if (this.traceHeader == null) {
                    AsciiTraceWriter.printDefaultHeader(this.printWriter, this.traceName, sample.getTime(), this.traceSamplePeriod);
                } else {
                    AsciiTraceWriter.printStaticHeader(this.printWriter, this.traceHeader);
                }
            }
            if (this.printChannels == null) {
                AsciiTraceWriter.printFullSampleData(this.printWriter, sample);
                continue;
            }
            AsciiTraceWriter.printSampleColumns(this.printWriter, this.printChannels, sample);
        }
        this.printWriter.flush();
    }

    @Override
    public void flush() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.sampleBuffer != null && this.sampleBuffer.size() > 0) {
            this.writeBuffer(this.sampleBuffer.size());
        }
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.flush();
        FileUtils.flushClose(this.printWriter);
        this.printWriter = null;
        this.isClosed = true;
    }

    @Override
    public boolean append(EquallySpacedTimeSeries samples) throws IOException {
        assert (this.sampleBuffer != null) : "Internal 'Sample' buffer is not initialized!";
        if (this.isClosed) {
            throw new IOException(this.getClass().getSimpleName() + " was already closed.");
        }
        if (this.traceSamplePeriod == null) {
            this.traceSamplePeriod = samples.getSamplePeriod();
        }
        if (samples != null && samples.getNumberOfSamples() > 0) {
            for (int i = 0; i < samples.getNumberOfSamples(); ++i) {
                if (!this.timeWindow.contains(samples.getTimeAtIndex(i))) continue;
                this.sampleBuffer.addLast(samples.getSampleAtIndex(i));
                while (this.sampleBuffer.size() >= this.chunkSize) {
                    this.writeBuffer(this.chunkSize);
                }
            }
        }
        return true;
    }

    public boolean append(TimeSeries samples) throws IOException {
        assert (this.sampleBuffer != null) : "Internal 'Sample' buffer is not initialized!";
        if (this.isClosed) {
            throw new IOException(this.getClass().getSimpleName() + " was already closed.");
        }
        this.traceSamplePeriod = null;
        if (samples != null && samples.getNumberOfSamples() > 0) {
            for (int i = 0; i < samples.getNumberOfSamples(); ++i) {
                if (!this.timeWindow.contains(samples.getTimeAtIndex(i))) continue;
                this.sampleBuffer.addLast(samples.getSampleAtIndex(i));
                while (this.sampleBuffer.size() >= this.chunkSize) {
                    this.writeBuffer(this.chunkSize);
                }
            }
        }
        return true;
    }
}

