/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis.ascii;

import de.gfz_potsdam.gipp.common.seis.Sample;
import de.gfz_potsdam.gipp.common.seis.TraceReader;
import de.gfz_potsdam.gipp.common.seis.UnevenlySpacedTimeSeries;
import de.gfz_potsdam.gipp.common.time.InvalidDateException;
import de.gfz_potsdam.gipp.common.time.ParserException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class AsciiTraceReader
extends TraceReader {
    private static final int DEFAULT_BLOCK_LENGTH = 1000;
    private final int maxSamples;
    private BufferedReader asciiReader;

    public AsciiTraceReader(InputStream inStream) {
        this(inStream, 1000);
    }

    public AsciiTraceReader(InputStream inStream, int blockSize) {
        this.asciiReader = new BufferedReader(new InputStreamReader(inStream));
        this.maxSamples = blockSize;
    }

    @Override
    public void close() throws IOException {
        if (this.asciiReader != null) {
            this.asciiReader.close();
            this.asciiReader = null;
        }
    }

    @Override
    public UnevenlySpacedTimeSeries read() throws IOException {
        if (this.asciiReader == null) {
            return null;
        }
        ArrayList<Sample> timeSeries = new ArrayList<Sample>();
        String textLine = null;
        while ((textLine = this.asciiReader.readLine()) != null) {
            int commentPos;
            if ((textLine = textLine.trim()).length() == 0 || (commentPos = textLine.indexOf(35)) == 0) continue;
            if (commentPos > 0) {
                textLine = textLine.substring(0, commentPos);
            }
            try {
                String[] column = textLine.split("\\s+");
                if (column.length == 2) {
                    timeSeries.add(new Sample(TimeMoment.parse(column[0]), Double.parseDouble(column[1])));
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (InvalidDateException invalidDateException) {
            }
            catch (ParserException parserException) {
                // empty catch block
            }
            if (timeSeries.size() < this.maxSamples) continue;
            break;
        }
        if (timeSeries.isEmpty()) {
            return null;
        }
        return new UnevenlySpacedTimeSeries(timeSeries);
    }
}

