/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis;

import de.gfz_potsdam.gipp.common.seis.Sample;
import de.gfz_potsdam.gipp.common.seis.TimeSeries;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import java.util.ArrayList;
import java.util.List;

public class UnevenlySpacedTimeSeries
implements TimeSeries {
    private final List<Sample> dataPoints;

    public static UnevenlySpacedTimeSeries concatenate(UnevenlySpacedTimeSeries left, UnevenlySpacedTimeSeries right) {
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        if (left == null && right == null) {
            return null;
        }
        assert (left.getNumberOfSamples() > 0) : "left time series contains not a single sample.";
        assert (right.getNumberOfSamples() > 0) : "right time series contains not a single sample.";
        if (left.getNumberOfChannels() != right.getNumberOfChannels()) {
            throw new IllegalArgumentException("Cannot concatenate time series with different number of channels (" + left.getNumberOfChannels() + " and " + right.getNumberOfChannels() + " channels).");
        }
        if (left.getStopTime().before(right.getStartTime())) {
            ArrayList<Sample> combined = new ArrayList<Sample>(left.getNumberOfSamples() + right.getNumberOfSamples());
            combined.addAll(left.dataPoints);
            combined.addAll(right.dataPoints);
            return new UnevenlySpacedTimeSeries(combined);
        }
        if (right.getStopTime().before(left.getStartTime())) {
            ArrayList<Sample> combined = new ArrayList<Sample>(left.getNumberOfSamples() + right.getNumberOfSamples());
            combined.addAll(right.dataPoints);
            combined.addAll(left.dataPoints);
            return new UnevenlySpacedTimeSeries(combined);
        }
        return null;
    }

    public static UnevenlySpacedTimeSeries shift(UnevenlySpacedTimeSeries series, double offset) {
        ArrayList<Sample> newDataPoints = new ArrayList<Sample>(series.getNumberOfSamples());
        for (Sample s : series.getAllSamples()) {
            newDataPoints.add(Sample.shift(s, offset));
        }
        return new UnevenlySpacedTimeSeries(newDataPoints);
    }

    public UnevenlySpacedTimeSeries(Sample ... samples) {
        if (samples == null) {
            throw new IllegalArgumentException("Initialization with a 'null' argument.");
        }
        if (samples.length == 0) {
            throw new IllegalArgumentException("Initialization with an empty array of samples.");
        }
        this.dataPoints = new ArrayList<Sample>(samples.length);
        int channels = samples[0].getNumberOfChannels();
        TimeMoment lastSampleTime = new TimeMoment();
        for (int i = 0; i < samples.length; ++i) {
            Sample value = samples[i];
            if (channels != value.getNumberOfChannels()) {
                throw new IllegalArgumentException("Samples with a different number of channels cannot be added to the same time series.");
            }
            if (!lastSampleTime.before(value.getTime())) {
                throw new IllegalArgumentException("Samples were not measured at successive points in time.");
            }
            this.dataPoints.add(i, value);
            lastSampleTime = value.getTime();
        }
    }

    public UnevenlySpacedTimeSeries(List<Sample> samples) throws IllegalArgumentException {
        if (samples == null) {
            throw new IllegalArgumentException("Initialization with a 'null' argument.");
        }
        if (samples.size() == 0) {
            throw new IllegalArgumentException("Initialization with an empty list of samples.");
        }
        this.dataPoints = new ArrayList<Sample>(samples.size());
        int channels = samples.get(0).getNumberOfChannels();
        TimeMoment lastSampleTime = new TimeMoment();
        for (int i = 0; i < samples.size(); ++i) {
            Sample value = samples.get(i);
            if (channels != value.getNumberOfChannels()) {
                throw new IllegalArgumentException("Samples with a different number of channels cannot be added to the same time series.");
            }
            if (!lastSampleTime.before(value.getTime())) {
                throw new IllegalArgumentException("Samples were not measured at successive points in time.");
            }
            this.dataPoints.add(i, value);
            lastSampleTime = value.getTime();
        }
    }

    public UnevenlySpacedTimeSeries(TimeSeries timeSeries) throws IllegalArgumentException {
        if (timeSeries == null) {
            throw new IllegalArgumentException("Initialization with a 'null' argument.");
        }
        if (timeSeries.getNumberOfSamples() == 0) {
            throw new IllegalArgumentException("Initialization with an empty time series.");
        }
        this.dataPoints = new ArrayList<Sample>(timeSeries.getNumberOfSamples());
        TimeMoment lastSampleTime = new TimeMoment();
        for (int i = 0; i < timeSeries.getNumberOfSamples(); ++i) {
            Sample sample = timeSeries.getSampleAtIndex(i);
            if (timeSeries.getNumberOfChannels() != sample.getNumberOfChannels()) {
                throw new IllegalArgumentException("Samples with a different number of channels cannot be added to the same time series.");
            }
            if (!lastSampleTime.before(sample.getTime())) {
                throw new IllegalArgumentException("Samples were not measured at successive points in time.");
            }
            this.dataPoints.add(i, sample);
            lastSampleTime = sample.getTime();
        }
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append(this.getClass().getSimpleName()).append(": ");
        info.append(this.getStartTime()).append(" to ");
        info.append(this.getStopTime()).append(", ");
        info.append(this.getNumberOfSamples()).append(" samples, ");
        info.append(this.getNumberOfChannels()).append(" channels");
        return info.toString();
    }

    @Override
    public int getNumberOfChannels() {
        assert (this.dataPoints != null) : "The trace does not contain any samples.";
        assert (this.dataPoints.size() >= 1) : "The trace must contain at least one sample.";
        return this.dataPoints.get(0).getNumberOfChannels();
    }

    @Override
    public int getNumberOfSamples() {
        assert (this.dataPoints != null) : "The trace does not contain any samples.";
        return this.dataPoints.size();
    }

    @Override
    public TimeMoment getStartTime() {
        assert (this.dataPoints != null) : "The trace does not contain any samples.";
        assert (this.dataPoints.size() >= 1) : "The trace must contain at least one sample.";
        return this.dataPoints.get(0).getTime();
    }

    @Override
    public TimeMoment getStopTime() {
        assert (this.dataPoints != null) : "The trace does not contain any samples.";
        assert (this.dataPoints.size() >= 1) : "The trace must contain at least one sample.";
        if (this.dataPoints.size() == 1) {
            return this.getStartTime();
        }
        return this.dataPoints.get(this.dataPoints.size() - 1).getTime();
    }

    @Override
    public Sample getSampleAtIndex(int index) throws IndexOutOfBoundsException {
        assert (this.dataPoints != null) : "The trace does not contain any samples.";
        assert (this.dataPoints.size() >= 1) : "The trace must contain at least one sample.";
        return this.dataPoints.get(index);
    }

    @Override
    public TimeMoment getTimeAtIndex(int index) throws IndexOutOfBoundsException {
        assert (this.dataPoints != null) : "The trace does not contain any samples.";
        assert (this.dataPoints.size() >= 1) : "The trace must contain at least one sample.";
        return this.dataPoints.get(index).getTime();
    }

    @Override
    public double getValueAtIndex(int index, int channel) throws IndexOutOfBoundsException {
        assert (this.dataPoints != null) : "The trace does not contain any samples.";
        assert (this.dataPoints.size() >= 1) : "The trace must contain at least one sample.";
        return this.dataPoints.get(index).getValue(channel);
    }

    public List<Sample> getAllSamples() {
        return this.dataPoints;
    }

    @Override
    public double[] getValuesOfChannel(int channel) throws IndexOutOfBoundsException {
        assert (this.dataPoints != null) : "The trace does not contain any samples.";
        assert (this.dataPoints.size() >= 1) : "The trace must contain at least one sample.";
        double[] result = new double[this.dataPoints.size()];
        for (int i = 0; i < this.dataPoints.size(); ++i) {
            result[i] = this.dataPoints.get(i).getValue(channel);
        }
        return result;
    }
}

