/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis;

import de.gfz_potsdam.gipp.common.time.TimeMoment;
import java.io.Serializable;

public class Sample
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TimeMoment time;
    private final double[] values;

    public Sample(TimeMoment time, double ... values) {
        if (time == null) {
            throw new IllegalArgumentException("No sample time was given!");
        }
        this.time = time;
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("No sample value(s) were given");
        }
        this.values = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
    }

    public Sample(TimeMoment time, int ... values) {
        if (time == null) {
            throw new IllegalArgumentException("No sample time was given!");
        }
        this.time = time;
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("No sample value(s) were given");
        }
        this.values = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
    }

    public int getNumberOfChannels() {
        assert (this.values != null) : "The 'Sample' contains no data values!";
        return this.values.length;
    }

    public TimeMoment getTime() {
        assert (this.time != null) : "The 'Sample' contains no 'recording time'!";
        return this.time;
    }

    public double getValue(int channel) throws IndexOutOfBoundsException {
        assert (this.values != null) : "The 'Sample' contains no data values!";
        if (channel < 0 || channel >= this.values.length) {
            throw new IndexOutOfBoundsException("Sample only contains " + this.values.length + " recoding channels. However, channel #" + channel + " was requested!");
        }
        return this.values[channel];
    }

    public double[] getAllValues() {
        assert (this.values != null) : "The 'Sample' contains no data values!";
        return this.values;
    }

    public int hashCode() {
        assert (this.time != null) : "The 'Sample' contains no 'recording time'!";
        assert (this.values != null) : "The 'Sample' contains no data values!";
        int hash = 7;
        hash = 37 * hash + (null == this.time ? 0 : this.time.hashCode());
        for (double value : this.values) {
            hash = 37 * hash + Double.valueOf(value).hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        assert (this.time != null) : "The 'Sample' contains no 'recording time'!";
        assert (this.values != null) : "The 'Sample' contains no data values!";
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sample)) {
            return false;
        }
        Sample other = (Sample)obj;
        if (!this.time.equals(other.time)) {
            return false;
        }
        if (this.getNumberOfChannels() != other.getNumberOfChannels()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == other.values[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsTime(Sample other) {
        assert (this.time != null) : "The 'Sample' contains no 'recording time'!";
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.time.equals(other.time);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.time.toString());
        buffer.append(" ");
        for (double value : this.values) {
            buffer.append('[').append(value).append(']');
        }
        return buffer.toString();
    }

    public static Sample shift(Sample sample, double offset) {
        if (sample == null) {
            throw new IllegalArgumentException("No sample was given.");
        }
        double[] buffer = sample.getAllValues();
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = buffer[i] + offset;
        }
        return new Sample(sample.getTime(), buffer);
    }

    public static Sample shift(Sample sample, double ... offsets) {
        if (sample == null) {
            throw new IllegalArgumentException("No sample was given.");
        }
        if (offsets == null) {
            throw new IllegalArgumentException("No offsets were given.");
        }
        if (offsets.length != sample.getNumberOfChannels()) {
            throw new IllegalArgumentException("Number of offsets differs from the number of channels recorded in the sample.");
        }
        double[] buffer = sample.getAllValues();
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = buffer[i] + offsets[i];
        }
        return new Sample(sample.getTime(), buffer);
    }

    public static Sample scale(Sample sample, double factor) {
        if (sample == null) {
            throw new IllegalArgumentException("No sample was given.");
        }
        double[] buffer = sample.getAllValues();
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = buffer[i] * factor;
        }
        return new Sample(sample.getTime(), buffer);
    }

    public static Sample scale(Sample sample, double ... factors) {
        if (sample == null) {
            throw new IllegalArgumentException("No sample was given.");
        }
        if (factors == null) {
            throw new IllegalArgumentException("No scaling factors were given.");
        }
        if (factors.length != sample.getNumberOfChannels()) {
            throw new IllegalArgumentException("Number of scaling factors differs from the number of channels recorded in the sample.");
        }
        double[] buffer = sample.getAllValues();
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = buffer[i] * factors[i];
        }
        return new Sample(sample.getTime(), buffer);
    }
}

