/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.seis;

import de.gfz_potsdam.gipp.common.seis.Sample;
import de.gfz_potsdam.gipp.common.seis.TimeSeries;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import de.gfz_potsdam.gipp.common.time.TimeSpan;
import de.gfz_potsdam.gipp.common.time.TimeWindow;
import java.util.Arrays;

public class EquallySpacedTimeSeries
implements TimeSeries {
    private final double[][] sampleValues;
    private final TimeMoment sampleStart;
    private final TimeSpan samplePeriod;

    public static EquallySpacedTimeSeries concatenate(EquallySpacedTimeSeries left, EquallySpacedTimeSeries right) throws IllegalArgumentException {
        TimeMoment real;
        TimeMoment expected;
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        if (left == null && right == null) {
            return null;
        }
        assert (left.getNumberOfSamples() > 0) : "Left time series contains not a single sample.";
        assert (right.getNumberOfSamples() > 0) : "Right time series contains not a single sample.";
        if (!left.getSamplePeriod().equals(right.getSamplePeriod())) {
            throw new IllegalArgumentException("Cannot concatenate time series with different sampling periods (" + left.getSamplePeriod() + " and " + right.getSamplePeriod() + ").");
        }
        if (left.getNumberOfChannels() != right.getNumberOfChannels()) {
            throw new IllegalArgumentException("Cannot concatenate time series with different number of channels (" + left.getNumberOfChannels() + " and " + right.getNumberOfChannels() + " channels).");
        }
        TimeSpan epsilon = TimeSpan.divide(left.getSamplePeriod(), 4.0);
        if (left.getStartTime().before(right.getStartTime())) {
            TimeMoment real2;
            TimeMoment expected2 = TimeSpan.add(left.getStopTime(), left.getSamplePeriod());
            if (TimeSpan.diff(expected2, real2 = right.getStartTime()).compareTo(epsilon) == -1) {
                double[][] combined = new double[left.getNumberOfChannels()][];
                for (int channel = 0; channel < left.getNumberOfChannels(); ++channel) {
                    double[] buffer = new double[left.getNumberOfSamples() + right.getNumberOfSamples()];
                    System.arraycopy(left.getValuesOfChannel(channel), 0, buffer, 0, left.getNumberOfSamples());
                    System.arraycopy(right.getValuesOfChannel(channel), 0, buffer, left.getNumberOfSamples(), right.getNumberOfSamples());
                    combined[channel] = buffer;
                }
                return new EquallySpacedTimeSeries(left.getStartTime(), left.getSamplePeriod(), combined);
            }
        } else if (left.getStartTime().after(right.getStartTime()) && TimeSpan.diff(expected = TimeSpan.add(right.getStopTime(), right.getSamplePeriod()), real = left.getStartTime()).compareTo(epsilon) == -1) {
            double[][] combined = new double[left.getNumberOfChannels()][];
            for (int channel = 0; channel < left.getNumberOfChannels(); ++channel) {
                double[] buffer = new double[right.getNumberOfSamples() + left.getNumberOfSamples()];
                System.arraycopy(right.getValuesOfChannel(channel), 0, buffer, 0, right.getNumberOfSamples());
                System.arraycopy(left.getValuesOfChannel(channel), 0, buffer, right.getNumberOfSamples(), left.getNumberOfSamples());
                combined[channel] = buffer;
            }
            return new EquallySpacedTimeSeries(right.getStartTime(), right.getSamplePeriod(), combined);
        }
        return null;
    }

    public static EquallySpacedTimeSeries trim(EquallySpacedTimeSeries series, TimeWindow window) throws IllegalArgumentException, UnsupportedOperationException {
        long stopIndex;
        long startIndex;
        if (window == null) {
            throw new IllegalArgumentException("No time window argument was given.");
        }
        if (series == null) {
            return null;
        }
        assert (series.getNumberOfSamples() > 0) : "Input time series contains not a single sample.";
        double start = (double)window.getStart().compareTo(series.getStartTime()) * TimeSpan.diff(window.getStart(), series.getStartTime()).divide(series.getSamplePeriod());
        double stop = (double)window.getStop().compareTo(series.getStartTime()) * TimeSpan.diff(window.getStop(), series.getStartTime()).divide(series.getSamplePeriod());
        switch (window.getType()) {
            case START_STOP: {
                startIndex = Math.round(Math.ceil(start));
                stopIndex = Math.round(Math.floor(stop));
                break;
            }
            case START_LENGTH: {
                startIndex = Math.round(Math.ceil(start));
                if (stop == Math.floor(stop)) {
                    stopIndex = Math.round(Math.floor(stop)) - 1L;
                    break;
                }
                stopIndex = Math.round(Math.floor(stop));
                break;
            }
            case LENGTH_STOP: {
                startIndex = start == Math.ceil(start) ? Math.round(Math.ceil(start)) + 1L : Math.round(Math.ceil(start));
                stopIndex = Math.round(Math.floor(stop));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown time window type!");
            }
        }
        if (stopIndex < 0L || startIndex > (long)(series.getNumberOfSamples() - 1)) {
            return null;
        }
        return EquallySpacedTimeSeries.trim(series, startIndex, stopIndex);
    }

    public static EquallySpacedTimeSeries trim(EquallySpacedTimeSeries series, TimeMoment newStart, int newLength) throws IllegalArgumentException {
        if (newLength < 1) {
            throw new IllegalArgumentException("A time series must contain at least one sample.");
        }
        if (newStart == null) {
            throw new IllegalArgumentException("No start time for the trimmed time series was given.");
        }
        if (series == null) {
            return null;
        }
        assert (series.getNumberOfSamples() > 0) : "Input time series contains not a single sample.";
        long startIndex = Math.round((double)newStart.compareTo(series.getStartTime()) * TimeSpan.diff(series.getStartTime(), newStart).divide(series.getSamplePeriod()));
        long stopIndex = startIndex + (long)newLength - 1L;
        if (stopIndex < 0L || startIndex > (long)(series.getNumberOfSamples() - 1)) {
            return null;
        }
        return EquallySpacedTimeSeries.trim(series, startIndex, stopIndex);
    }

    public static EquallySpacedTimeSeries trim(EquallySpacedTimeSeries series, long newStart, long newStop) throws IllegalArgumentException {
        if (newStart > newStop) {
            throw new IllegalArgumentException("The 'newStart' index must come before the 'newStop' index.");
        }
        if (series == null) {
            return null;
        }
        assert (series.getNumberOfSamples() > 0) : "Input time series contains not a single sample.";
        long startIndex = Math.max(newStart, 0L);
        long stopIndex = Math.min(newStop, (long)(series.getNumberOfSamples() - 1));
        if (startIndex == 0L && stopIndex == (long)(series.getNumberOfSamples() - 1)) {
            return series;
        }
        double[][] trimmed = new double[series.getNumberOfChannels()][];
        for (int channel = 0; channel < series.getNumberOfChannels(); ++channel) {
            double[] buffer = new double[(int)(stopIndex - startIndex + 1L)];
            System.arraycopy(series.getValuesOfChannel(channel), (int)startIndex, buffer, 0, buffer.length);
            trimmed[channel] = buffer;
        }
        TimeMoment realStart = TimeSpan.add(series.getStartTime(), TimeSpan.multiply(series.getSamplePeriod(), startIndex));
        return new EquallySpacedTimeSeries(realStart, series.getSamplePeriod(), trimmed);
    }

    public static EquallySpacedTimeSeries pad(EquallySpacedTimeSeries series, TimeMoment newStart, int newLength) throws IllegalArgumentException {
        if (series == null) {
            return null;
        }
        return EquallySpacedTimeSeries.pad(series, newStart, newLength, series.getArithmeticMeans());
    }

    public static EquallySpacedTimeSeries pad(EquallySpacedTimeSeries series, TimeMoment newStart, int newLength, double ... padValues) throws IllegalArgumentException {
        if (series == null) {
            return null;
        }
        if (newLength < 1) {
            throw new IllegalArgumentException("A time series must contain at least one sample.");
        }
        if (newStart == null) {
            throw new IllegalArgumentException("No start time for the trimmed time series was given.");
        }
        if (padValues == null) {
            throw new IllegalArgumentException("No values were given to initialize the padded samples");
        }
        if (padValues.length != series.getNumberOfChannels()) {
            throw new IllegalArgumentException("The number of padding values from the number of channels contained in the time series (" + padValues.length + " and " + series.getNumberOfChannels() + " channels).");
        }
        assert (series.getNumberOfSamples() > 0) : "input time series contains not a single sample.";
        long startIndex = Math.round((double)newStart.compareTo(series.getStartTime()) * TimeSpan.diff(series.getStartTime(), newStart).divide(series.getSamplePeriod()));
        long stopIndex = startIndex + (long)newLength - 1L;
        if (startIndex >= 0L && stopIndex <= (long)(series.getNumberOfSamples() - 1)) {
            return series;
        }
        startIndex = Math.min(startIndex, 0L);
        stopIndex = Math.max(stopIndex, (long)(series.getNumberOfSamples() - 1));
        double[][] padded = new double[series.getNumberOfChannels()][];
        for (int channel = 0; channel < series.getNumberOfChannels(); ++channel) {
            double[] buffer = new double[(int)(stopIndex - startIndex + 1L)];
            Arrays.fill(buffer, 0, (int)Math.abs(startIndex), padValues[channel]);
            Arrays.fill(buffer, (int)Math.abs(startIndex) + series.getNumberOfSamples(), buffer.length, padValues[channel]);
            System.arraycopy(series.getValuesOfChannel(channel), 0, buffer, (int)Math.abs(startIndex), series.getNumberOfSamples());
            padded[channel] = buffer;
        }
        TimeMoment realStart = startIndex > 0L ? TimeSpan.add(series.getStartTime(), TimeSpan.multiply(series.getSamplePeriod(), startIndex)) : (startIndex < 0L ? TimeSpan.subtract(series.getStartTime(), TimeSpan.multiply(series.getSamplePeriod(), -startIndex)) : series.getStartTime());
        return new EquallySpacedTimeSeries(realStart, series.getSamplePeriod(), padded);
    }

    public static EquallySpacedTimeSeries shift(EquallySpacedTimeSeries series, double offset) {
        double[][] buffer = new double[series.getNumberOfChannels()][series.getNumberOfSamples()];
        for (int channel = 0; channel < series.getNumberOfChannels(); ++channel) {
            for (int i = 0; i < series.getNumberOfSamples(); ++i) {
                buffer[channel][i] = series.getValueAtIndex(i, channel) + offset;
            }
        }
        return new EquallySpacedTimeSeries(series.getStartTime(), series.getSamplePeriod(), buffer);
    }

    public EquallySpacedTimeSeries(TimeMoment start, TimeSpan period, double[] ... samples) throws IllegalArgumentException {
        int channel;
        if (start == null) {
            throw new IllegalArgumentException("A time series must have a 'start time '.");
        }
        if (period == null) {
            throw new IllegalArgumentException("A time series must have a 'sample period'.");
        }
        if (samples == null || samples.length < 1) {
            throw new IllegalArgumentException("The time series must contain at least one channel.");
        }
        for (channel = 1; channel < samples.length; ++channel) {
            if (samples[channel].length == samples[0].length) continue;
            throw new IllegalArgumentException("Channel #0 and #" + channel + " contain a different number of sample values (" + samples[0].length + " and " + samples[channel].length + " samples).");
        }
        if (samples[0].length < 1) {
            throw new IllegalArgumentException("The time series must contain at least one sample value.");
        }
        this.sampleValues = new double[samples.length][];
        this.sampleStart = start;
        this.samplePeriod = period;
        for (channel = 0; channel < samples.length; ++channel) {
            double[] buffer = new double[samples[channel].length];
            System.arraycopy(samples[channel], 0, buffer, 0, samples[channel].length);
            this.sampleValues[channel] = buffer;
        }
    }

    public EquallySpacedTimeSeries(TimeMoment start, TimeSpan period, int[] ... samples) throws IllegalArgumentException {
        int channel;
        if (start == null) {
            throw new IllegalArgumentException("A time series must have a 'start time '.");
        }
        if (period == null) {
            throw new IllegalArgumentException("A time series must have a 'sample period'.");
        }
        if (samples == null || samples.length < 1) {
            throw new IllegalArgumentException("The time series must contain at least one channel.");
        }
        for (channel = 1; channel < samples.length; ++channel) {
            if (samples[channel].length == samples[0].length) continue;
            throw new IllegalArgumentException("Channel #0 and #" + channel + " contain a different number of sample values (" + samples[0].length + " and " + samples[channel].length + " samples).");
        }
        if (samples[0].length < 1) {
            throw new IllegalArgumentException("The time series must contain at least one sample value.");
        }
        this.sampleValues = new double[samples.length][];
        this.sampleStart = start;
        this.samplePeriod = period;
        for (channel = 0; channel < samples.length; ++channel) {
            double[] buffer = new double[samples[channel].length];
            for (int index = 0; index < samples[channel].length; ++index) {
                buffer[index] = samples[channel][index];
            }
            this.sampleValues[channel] = buffer;
        }
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append(this.getClass().getSimpleName()).append(": ");
        info.append(this.getStartTime()).append(" to ");
        info.append(this.getStopTime()).append(", ");
        info.append(this.getNumberOfSamples()).append(" samples, ");
        info.append(this.getNumberOfChannels()).append(" channels, T=");
        info.append(this.getSamplePeriod());
        return info.toString();
    }

    @Override
    public int getNumberOfChannels() {
        assert (this.sampleValues != null) : "The time series does not contain any channels.";
        return this.sampleValues.length;
    }

    @Override
    public int getNumberOfSamples() {
        assert (this.sampleValues != null) : "The time series does not contain any channels.";
        assert (this.sampleValues.length >= 1) : "The time series must contain at least one recording channel.";
        assert (this.sampleValues[0] != null) : "The first channel does not contain any samples.";
        return this.sampleValues[0].length;
    }

    @Override
    public TimeMoment getStartTime() {
        assert (this.sampleStart != null) : "The time series does not have a start time.";
        return this.sampleStart;
    }

    @Override
    public TimeMoment getStopTime() {
        assert (this.sampleStart != null) : "The time series does not have a start time.";
        assert (this.samplePeriod != null) : "The time series does not have a sampling period.";
        assert (this.sampleValues != null) : "The time series does not contain any channels.";
        assert (this.sampleValues.length >= 1) : "The time series must contain at least one recording channel.";
        assert (this.sampleValues[0].length >= 1) : "The time series must contain at least one sample.";
        if (this.sampleValues[0].length == 1) {
            return this.sampleStart;
        }
        return TimeSpan.add(this.sampleStart, TimeSpan.multiply(this.samplePeriod, this.sampleValues[0].length - 1));
    }

    public TimeSpan getSamplePeriod() {
        assert (this.samplePeriod != null) : "The time series does not have a sampling period.";
        return this.samplePeriod;
    }

    @Override
    public Sample getSampleAtIndex(int index) throws IndexOutOfBoundsException {
        assert (this.sampleValues != null) : "The time series does not contain any channels.";
        assert (this.sampleValues.length >= 1) : "The time series must contain at least one recording channel.";
        if (index < 0 || index >= this.sampleValues[0].length) {
            throw new IndexOutOfBoundsException("There is no sample at index #" + index + " in the time series.");
        }
        double[] values = new double[this.getNumberOfChannels()];
        for (int channel = 0; channel < this.getNumberOfChannels(); ++channel) {
            values[channel] = this.sampleValues[channel][index];
        }
        Sample result = new Sample(this.getTimeAtIndex(index), values);
        return result;
    }

    @Override
    public TimeMoment getTimeAtIndex(int index) {
        assert (this.sampleStart != null) : "The time series does not have a start time.";
        assert (this.samplePeriod != null) : "The time series does not have a sampling period.";
        if (index >= 0) {
            return TimeSpan.add(this.sampleStart, TimeSpan.multiply(this.samplePeriod, index));
        }
        return TimeSpan.subtract(this.sampleStart, TimeSpan.multiply(this.samplePeriod, index));
    }

    @Override
    public double getValueAtIndex(int index, int channel) throws IndexOutOfBoundsException {
        assert (this.sampleValues != null) : "The time series does not contain any channels.";
        assert (this.sampleValues.length >= 1) : "The time series must contain at least one recording channel.";
        if (channel < 0 || channel >= this.sampleValues.length) {
            throw new IndexOutOfBoundsException("The time series does not contain a channel #" + channel);
        }
        if (index < 0 || index >= this.sampleValues[0].length) {
            throw new IndexOutOfBoundsException("There is no sample at index #" + index + " in the time series.");
        }
        return this.sampleValues[channel][index];
    }

    @Override
    public double[] getValuesOfChannel(int channel) throws IndexOutOfBoundsException {
        assert (this.sampleValues != null) : "The time series does not contain any channels.";
        assert (this.sampleValues.length >= 1) : "The time series must contain at least one recording channel.";
        if (channel < 0 || channel >= this.sampleValues.length) {
            throw new IndexOutOfBoundsException("The time series does not contain a channel #" + channel);
        }
        return this.sampleValues[channel];
    }

    public double getArithmeticMean(int channel) throws IndexOutOfBoundsException {
        assert (this.sampleValues != null) : "The time series does not contain any channels.";
        assert (this.sampleValues.length >= 1) : "The time series must contain at least one recording channel.";
        if (channel < 0 || channel >= this.sampleValues.length) {
            throw new IndexOutOfBoundsException("The time series does not contain a channel #" + channel);
        }
        double sum = 0.0;
        for (double value : this.sampleValues[channel]) {
            if (sum > Double.MAX_VALUE - value) {
                throw new ArithmeticException("Number overflow while calculating arithmetic mean.");
            }
            sum += value;
        }
        return sum / (double)this.sampleValues[channel].length;
    }

    public double[] getArithmeticMeans() {
        assert (this.sampleValues != null) : "The time series does not contain any channels.";
        assert (this.sampleValues.length >= 1) : "The time series must contain at least one recording channel.";
        double[] meanValues = new double[this.getNumberOfChannels()];
        for (int channel = 0; channel < this.getNumberOfChannels(); ++channel) {
            meanValues[channel] = this.getArithmeticMean(channel);
        }
        return meanValues;
    }

    public double getQuadraticMean(int channel) throws IndexOutOfBoundsException {
        assert (this.sampleValues != null) : "The time series does not contain any channels.";
        assert (this.sampleValues.length >= 1) : "The time series must contain at least one recording channel.";
        if (channel < 0 || channel >= this.sampleValues.length) {
            throw new IndexOutOfBoundsException("The time series does not contain a channel #" + channel);
        }
        double sum = 0.0;
        for (double value : this.sampleValues[channel]) {
            if (sum > Double.MAX_VALUE - value * value) {
                throw new ArithmeticException("Number overflow while calculating quadratic mean.");
            }
            sum += value * value;
        }
        return Math.sqrt(sum / (double)this.sampleValues[channel].length);
    }

    public double[] getQuadraticMeans() {
        assert (this.sampleValues != null) : "The time series does not contain any channels.";
        assert (this.sampleValues.length >= 1) : "The time series must contain at least one recording channel.";
        double[] meanValues = new double[this.getNumberOfChannels()];
        for (int channel = 0; channel < this.getNumberOfChannels(); ++channel) {
            meanValues[channel] = this.getQuadraticMean(channel);
        }
        return meanValues;
    }
}

