/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.regex;

import java.util.List;
import java.util.regex.Pattern;

public class RegexUtils {
    public static String convertWildcards(String wildcardRegex) {
        StringBuilder buffer = new StringBuilder();
        block5: for (char c : wildcardRegex.toCharArray()) {
            switch (c) {
                case '*': {
                    buffer.append(".*");
                    continue block5;
                }
                case '?': {
                    buffer.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    buffer.append('\\').append(c);
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static boolean matches(List<Pattern> patterns, String text) {
        if (patterns == null || patterns.isEmpty()) {
            return true;
        }
        for (Pattern p : patterns) {
            if (!p.matcher(text).matches()) continue;
            return true;
        }
        return false;
    }

    private RegexUtils() {
    }
}

