/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.platform.apple;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class AppleAdapter
implements InvocationHandler {
    private static Object appleApplication;
    protected Object targetObject;
    protected Method targetMethod;
    protected String handlerName;

    public static void installQuitHandler(Object target, Method handler) throws NullPointerException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (handler == null) {
            throw new NullPointerException("Handler is null.");
        }
        AppleAdapter.setHandler(new AppleAdapter("handleQuit", target, handler){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (this.handlerName.equals(method.getName()) && this.targetMethod != null && args.length == 1) {
                    Object appleEvent = args[0];
                    Object result = this.targetMethod.invoke(this.targetObject, new Object[0]);
                    if (result instanceof Boolean) {
                        Method setHandledMethod = appleEvent.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
                        setHandledMethod.invoke(appleEvent, (Boolean)result);
                    }
                }
                return null;
            }
        });
    }

    public static void installAboutHandler(Object target, Method handler) throws NullPointerException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (handler == null) {
            throw new NullPointerException("Handler is null.");
        }
        AppleAdapter.setHandler(new AppleAdapter("handleAbout", target, handler){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (this.handlerName.equals(method.getName()) && this.targetMethod != null && args.length == 1) {
                    Object appleEvent = args[0];
                    this.targetMethod.invoke(this.targetObject, new Object[0]);
                    Method setHandledMethod = appleEvent.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
                    setHandledMethod.invoke(appleEvent, Boolean.TRUE);
                }
                return null;
            }
        });
        Method enableAboutMethod = appleApplication.getClass().getDeclaredMethod("setEnabledAboutMenu", Boolean.TYPE);
        enableAboutMethod.invoke(appleApplication, Boolean.TRUE);
    }

    public static void installPreferencesHandler(Object target, Method handler) throws NullPointerException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (handler == null) {
            throw new NullPointerException("Handler is null.");
        }
        AppleAdapter.setHandler(new AppleAdapter("handlePreferences", target, handler){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (this.handlerName.equals(method.getName()) && this.targetMethod != null && args.length == 1) {
                    this.targetMethod.invoke(this.targetObject, new Object[0]);
                }
                return null;
            }
        });
        Method enablePrefsMethod = appleApplication.getClass().getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE);
        enablePrefsMethod.invoke(appleApplication, Boolean.TRUE);
    }

    public static void installOpenFileHandler(Object target, Method handler) throws NullPointerException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (handler == null) {
            throw new NullPointerException("Handler is null.");
        }
        AppleAdapter.setHandler(new AppleAdapter("handleOpenFile", target, handler){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (this.handlerName.equals(method.getName()) && this.targetMethod != null && args.length == 1) {
                    Object appleEvent = args[0];
                    Method getFilenameMethod = appleEvent.getClass().getDeclaredMethod("getFilname", new Class[0]);
                    String file = (String)getFilenameMethod.invoke(appleEvent, new Object[0]);
                    this.targetMethod.invoke(this.targetObject, file);
                }
                return null;
            }
        });
    }

    private static void setHandler(AppleAdapter adapter) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
        Class<?> listenerInterface = Class.forName("com.apple.eawt.ApplicationListener");
        if (appleApplication == null) {
            appleApplication = applicationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        Method addListenerMethod = applicationClass.getDeclaredMethod("addApplicationListener", listenerInterface);
        Object proxy = Proxy.newProxyInstance(AppleAdapter.class.getClassLoader(), new Class[]{listenerInterface}, (InvocationHandler)adapter);
        addListenerMethod.invoke(appleApplication, proxy);
    }

    private AppleAdapter(String handlerName, Object targetObject, Method targetMethod) {
        this.handlerName = handlerName;
        this.targetObject = targetObject;
        this.targetMethod = targetMethod;
    }

    @Override
    public abstract Object invoke(Object var1, Method var2, Object[] var3) throws Throwable;
}

