/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.platform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;

public class PlatformInfo {
    private static final Platform systemType;
    private static final String userPreferenceDir;
    private static final String sharedPreferenceDir;

    private PlatformInfo() {
    }

    public static boolean isMacOS9() {
        return systemType == Platform.MACOS9;
    }

    public static boolean isMacOSX() {
        return systemType == Platform.MACOSX;
    }

    public static boolean isMac() {
        return systemType == Platform.MACOSX || systemType == Platform.MACOS9;
    }

    public static boolean isLinux() {
        return systemType == Platform.LINUX;
    }

    public static boolean isSolaris() {
        return systemType == Platform.SOLARIS;
    }

    public static boolean isBsd() {
        return systemType == Platform.BSD;
    }

    public static boolean isWindows() {
        return systemType == Platform.WINDOWS;
    }

    public static boolean isOS2() {
        return systemType == Platform.OS2;
    }

    public static File getUserPrefsDirectory() {
        assert (userPreferenceDir != null);
        return new File(userPreferenceDir);
    }

    public static File getSharedPrefsDirectory() {
        assert (sharedPreferenceDir != null);
        return new File(sharedPreferenceDir);
    }

    public static File getJarDirectory(Class<?> javaClass) {
        if (javaClass == null) {
            return null;
        }
        URL classUrl = null;
        try {
            classUrl = javaClass.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (SecurityException e) {
            classUrl = javaClass.getResource(javaClass.getSimpleName() + ".class");
        }
        if (classUrl == null) {
            return null;
        }
        String urlString = classUrl.toExternalForm();
        if (urlString.endsWith(".jar")) {
            urlString = urlString.substring(0, urlString.lastIndexOf("/"));
        } else if (urlString.endsWith(".class")) {
            String javaClassPath = "/" + javaClass.getName().replace(".", "/") + ".class";
            urlString = urlString.replace(javaClassPath, "");
        } else if (urlString.startsWith("jar:") && urlString.endsWith(".jar!")) {
            urlString = urlString.substring(4, urlString.lastIndexOf("/"));
        }
        try {
            classUrl = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
        File classDirectory = null;
        try {
            classDirectory = new File(classUrl.toURI());
        }
        catch (URISyntaxException e) {
            classDirectory = new File(classUrl.getPath());
        }
        if (classDirectory != null && classDirectory.isDirectory()) {
            return classDirectory;
        }
        return null;
    }

    static {
        String osName = System.getProperty("os.name", "n/a").toLowerCase(Locale.ENGLISH);
        String osVendor = System.getProperty("java.vendor", "n/a").toLowerCase(Locale.ENGLISH);
        if (osName.contains("mac os x")) {
            systemType = Platform.MACOSX;
            userPreferenceDir = System.getProperty("user.home") + "/Library/Application Support";
            sharedPreferenceDir = "/Library/Application Support";
        } else if (osVendor.contains("apple") || osName.contains("mac os")) {
            systemType = Platform.MACOS9;
            userPreferenceDir = "System Folder:Preferences";
            sharedPreferenceDir = "System Folder:Preferences";
        } else if (osName.contains("linux")) {
            systemType = Platform.LINUX;
            userPreferenceDir = System.getProperty("user.home") + "/.config";
            sharedPreferenceDir = "/etc";
        } else if (osName.contains("sunos") || osName.contains("sun os") || osName.contains("solaris")) {
            systemType = Platform.SOLARIS;
            userPreferenceDir = System.getProperty("user.home");
            sharedPreferenceDir = "/etc";
        } else if (osName.contains("bsd")) {
            systemType = Platform.BSD;
            userPreferenceDir = System.getProperty("user.home");
            sharedPreferenceDir = "/etc";
        } else if (osName.contains("windows")) {
            systemType = Platform.WINDOWS;
            String prefDir = System.getenv("APPDATA");
            userPreferenceDir = prefDir != null ? prefDir : System.getProperty("user.home");
            prefDir = System.getenv("ALLUSERSPROFILE");
            sharedPreferenceDir = prefDir == null ? prefDir : System.getProperty("user.home");
        } else if (osName.contains("os/2")) {
            systemType = Platform.OS2;
            userPreferenceDir = System.getProperty("user.home");
            sharedPreferenceDir = System.getProperty("user.home");
        } else {
            systemType = Platform.UNKNOWN;
            userPreferenceDir = System.getProperty("user.home");
            sharedPreferenceDir = System.getProperty("user.home");
        }
    }

    private static enum Platform {
        UNKNOWN,
        MACOS9,
        MACOSX,
        LINUX,
        SOLARIS,
        BSD,
        OS2,
        WINDOWS;

    }
}

