/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.math;

public class MathUtils {
    private MathUtils() {
    }

    public static float machineEpsilon(float a) {
        return Float.intBitsToFloat(Float.floatToIntBits(a) + 1) - a;
    }

    public static double machineEpsilon(double a) {
        return Double.longBitsToDouble(Double.doubleToLongBits(a) + 1L) - a;
    }

    public static boolean almostEqualAbsoluteAndRelative(float a, float b, float maxAbsoluteDiff, float maxRelativeDiff) {
        assert (maxAbsoluteDiff >= 0.0f) : "maximum absolute difference must not be negative";
        assert (maxRelativeDiff >= 0.0f) : "maximum relative difference must not be negative";
        if (a == b) {
            return true;
        }
        float diff = Math.abs(a - b);
        if (diff <= maxAbsoluteDiff) {
            return true;
        }
        float largest = Math.max(Math.abs(a), Math.abs(b));
        return diff / largest <= maxRelativeDiff;
    }

    public static boolean almostEqualAbsoluteAndRelative(double a, double b, double maxAbsoluteDiff, double maxRelativeDiff) {
        assert (maxAbsoluteDiff >= 0.0) : "maximum absolute difference must not be negative";
        assert (maxRelativeDiff >= 0.0) : "maximum relative difference must not be negative";
        if (a == b) {
            return true;
        }
        double diff = Math.abs(a - b);
        if (diff <= maxAbsoluteDiff) {
            return true;
        }
        double largest = Math.max(Math.abs(a), Math.abs(b));
        return diff / largest <= maxRelativeDiff;
    }

    public static boolean almostEqualAbsoluteAndUlps(float a, float b, float maxAbsoluteDiff, int maxUlpsDiff) {
        assert (maxAbsoluteDiff >= 0.0f) : "maximum absolute difference must not be negative";
        assert (maxUlpsDiff >= 0) : "maximum ULP difference must not be negative";
        if (a == b) {
            return true;
        }
        float diff = Math.abs(a - b);
        if (diff <= maxAbsoluteDiff) {
            return true;
        }
        if (Math.signum(a) != Math.signum(b)) {
            return false;
        }
        int ulpsDiff = Math.abs(Float.floatToIntBits(a) - Float.floatToIntBits(b));
        return ulpsDiff <= maxUlpsDiff;
    }

    public static boolean almostEqualAbsoluteAndUlps(double a, double b, double maxAbsoluteDiff, long maxUlpsDiff) {
        assert (maxAbsoluteDiff >= 0.0) : "maximum absolute difference must not be negative";
        assert (maxUlpsDiff >= 0L) : "maximum ULP difference must not be negative";
        if (a == b) {
            return true;
        }
        double diff = Math.abs(a - b);
        if (diff <= maxAbsoluteDiff) {
            return true;
        }
        if (Math.signum(a) != Math.signum(b)) {
            return false;
        }
        long ulpsDiff = Math.abs(Double.doubleToLongBits(a) - Double.doubleToLongBits(b));
        return ulpsDiff <= maxUlpsDiff;
    }
}

