/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.math;

public class Function {
    public static double sinc(double t, double T) {
        if (t == 0.0) {
            return 1.0;
        }
        return StrictMath.sin(Math.PI * t / T) / (Math.PI * t / T);
    }

    public static double lanczosWindow(double t, double T, int n) {
        if (t == 0.0) {
            return 1.0;
        }
        if (StrictMath.abs(t) > (double)n * T) {
            return 0.0;
        }
        return StrictMath.sin(Math.PI * t / ((double)n * T)) / (Math.PI * t / ((double)n * T));
    }

    public static double optimalThreeTermWindow(double t, double T, int n) {
        if (StrictMath.abs(t) > (double)n * T) {
            return 0.0;
        }
        return 0.375 + 0.5 * StrictMath.cos(Math.PI * t / ((double)n * T)) + 0.125 * StrictMath.cos(Math.PI * 2 * t / ((double)n * T));
    }

    public static double blackmannNuttallWindow(double t, double T, int n) {
        if (StrictMath.abs(t) > (double)n * T) {
            return 0.0;
        }
        return 0.3635819 + 0.4891775 * StrictMath.cos(Math.PI * t / ((double)n * T)) + 0.1365995 * StrictMath.cos(Math.PI * 2 * t / ((double)n * T)) + 0.0106411 * StrictMath.cos(Math.PI * 3 * t / ((double)n * T));
    }
}

