/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.io;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;

public class IOUtils {
    private IOUtils() {
    }

    public static int cmp(DataInput leftSource, DataInput rightSource) throws IOException {
        assert (leftSource != null) : "Argument 'leftSource' is null.";
        assert (rightSource != null) : "Argument 'rightSource' is null.";
        byte leftValue = 0;
        byte rightValue = 0;
        boolean leftEOF = false;
        boolean rightEOF = false;
        int offset = 0;
        do {
            try {
                leftValue = leftSource.readByte();
            }
            catch (EOFException e) {
                leftEOF = true;
            }
            try {
                rightValue = rightSource.readByte();
            }
            catch (EOFException e) {
                rightEOF = true;
            }
            ++offset;
        } while (!leftEOF && !rightEOF && leftValue == rightValue);
        if (leftEOF && rightEOF) {
            return -1;
        }
        return offset - 1;
    }

    public static int diff(BufferedReader leftReader, BufferedReader rightReader) throws IOException {
        String rightLine;
        String leftLine;
        assert (leftReader != null) : "Argument 'leftReader' is null.";
        assert (rightReader != null) : "Argument 'rightReader' is null.";
        int count = 1;
        do {
            leftLine = leftReader.readLine();
            rightLine = rightReader.readLine();
            ++count;
        } while (leftLine != null && rightLine != null && leftLine.equals(rightLine));
        if (leftLine == null && rightLine == null) {
            return -1;
        }
        return count - 1;
    }

    public static void swapShort(byte[] array, int offset) {
        assert (offset + 1 < array.length) : "The 'offset' does not point at a 2-byte integer number.";
        byte temp = array[offset];
        array[offset] = array[offset + 1];
        array[offset + 1] = temp;
    }

    public static void swapInt(byte[] array, int offset) {
        assert (offset + 3 < array.length) : "The 'offset' does not point at a 4-byte integer number.";
        byte temp = array[offset];
        array[offset] = array[offset + 3];
        array[offset + 3] = temp;
        temp = array[offset + 1];
        array[offset + 1] = array[offset + 2];
        array[offset + 2] = temp;
    }

    public static byte[] longToBytes(long longValue) {
        byte[] byteArray = new byte[8];
        for (int i = byteArray.length - 1; i >= 0; --i) {
            byteArray[i] = (byte)(longValue & 0xFFL);
            longValue >>= 8;
        }
        return byteArray;
    }

    public static long bytesToLong(byte[] byteArray) {
        assert (byteArray.length == 8) : "Input array must be 8 bytes long (was " + byteArray.length + " bytes long).";
        long longValue = 0L;
        for (int i = 0; i < 8; ++i) {
            longValue <<= 8;
            longValue |= (long)(byteArray[i] & 0xFF);
        }
        return longValue;
    }
}

