/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.geo.projection;

import de.gfz_potsdam.gipp.common.geo.Ellipsoid;
import de.gfz_potsdam.gipp.common.geo.LatLonPoint;
import de.gfz_potsdam.gipp.common.geo.UtmPoint;

public class UniversalTransverseMercator {
    private static double k0 = 0.9996;
    private final Ellipsoid ellipsoid;

    public UniversalTransverseMercator(Ellipsoid ellipsoid) {
        assert (ellipsoid != null) : "The parameter 'ellipsoid' must not be null!";
        this.ellipsoid = ellipsoid;
    }

    public UtmPoint project(LatLonPoint point) {
        int id = (int)((point.getLongitude() + 180.0) / 6.0) + 1;
        if (point.getLatitude() >= 56.0 && point.getLatitude() < 64.0 && point.getLongitude() >= 3.0 && point.getLongitude() < 12.0) {
            id = 32;
        }
        if (point.getLatitude() >= 72.0 && point.getLatitude() < 84.0) {
            if (point.getLongitude() >= 0.0 && point.getLongitude() < 9.0) {
                id = 31;
            } else if (point.getLongitude() >= 9.0 && point.getLongitude() < 21.0) {
                id = 33;
            } else if (point.getLongitude() >= 21.0 && point.getLongitude() < 33.0) {
                id = 35;
            } else if (point.getLongitude() >= 33.0 && point.getLongitude() < 42.0) {
                id = 37;
            }
        }
        return this.project(id, point);
    }

    public UtmPoint project(int id, LatLonPoint point) {
        int lonZone = id;
        double eccSquared = this.ellipsoid.squaredEccentricity();
        double LongOrigin = (lonZone - 1) * 6 - 180 + 3;
        double LongOriginRad = Math.toRadians(LongOrigin);
        double radianLat = Math.toRadians(point.getLatitude());
        double radianLon = Math.toRadians(point.getLongitude());
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double N = this.ellipsoid.getSemiMajor() / Math.sqrt(1.0 - eccSquared * Math.sin(radianLat) * Math.sin(radianLat));
        double T = Math.tan(radianLat) * Math.tan(radianLat);
        double C = eccPrimeSquared * Math.cos(radianLat) * Math.cos(radianLat);
        double A = Math.cos(radianLat) * (radianLon - LongOriginRad);
        double M = this.ellipsoid.getSemiMajor() * ((1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0) * radianLat - (3.0 * eccSquared / 8.0 + 3.0 * eccSquared * eccSquared / 32.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(2.0 * radianLat) + (15.0 * eccSquared * eccSquared / 256.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(4.0 * radianLat) - 35.0 * eccSquared * eccSquared * eccSquared / 3072.0 * Math.sin(6.0 * radianLat));
        double easting = k0 * N * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * eccPrimeSquared) * A * A * A * A * A / 120.0) + 500000.0;
        double northing = k0 * (M + N * Math.tan(radianLat) * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * eccPrimeSquared) * A * A * A * A * A * A / 720.0));
        if (point.getLatitude() < 0.0) {
            northing += 1.0E7;
        }
        return new UtmPoint(easting, northing, lonZone);
    }

    public LatLonPoint projectinv(UtmPoint point) {
        double eccSquared = this.ellipsoid.squaredEccentricity();
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double e1 = (1.0 - Math.sqrt(1.0 - eccSquared)) / (1.0 + Math.sqrt(1.0 - eccSquared));
        double x = point.getX() - 500000.0;
        double y = point.getY();
        if (point.getZone() < 0) {
            y -= 1.0E7;
        }
        double LongOrigin = (point.getZone() - 1) * 6 - 180 + 3;
        double M = y / k0;
        double mu = M / (this.ellipsoid.getSemiMajor() * (1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0));
        double phi1Rad = mu + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * mu) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * mu) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * mu);
        double N1 = this.ellipsoid.getSemiMajor() / Math.sqrt(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad));
        double T1 = Math.tan(phi1Rad) * Math.tan(phi1Rad);
        double C1 = eccPrimeSquared * Math.cos(phi1Rad) * Math.cos(phi1Rad);
        double R1 = this.ellipsoid.getSemiMajor() * (1.0 - eccSquared) / Math.pow(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad), 1.5);
        double D = x / (N1 * k0);
        double radianLat = phi1Rad - N1 * Math.tan(phi1Rad) / R1 * (D * D / 2.0 - (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * C1 * C1 - 9.0 * eccPrimeSquared) * D * D * D * D / 24.0 + (61.0 + 90.0 * T1 + 298.0 * C1 + 45.0 * T1 * T1 - 252.0 * eccPrimeSquared - 3.0 * C1 * C1) * D * D * D * D * D * D / 720.0);
        double radianLon = (D - (1.0 + 2.0 * T1 + C1) * D * D * D / 6.0 + (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * C1 * C1 + 8.0 * eccPrimeSquared + 24.0 * T1 * T1) * D * D * D * D * D / 120.0) / Math.cos(phi1Rad);
        return new LatLonPoint(Math.toDegrees(radianLat), LongOrigin + Math.toDegrees(radianLon));
    }
}

