/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.geo;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Locale;

public class UtmPoint
extends Point2D
implements Serializable {
    private static final Locale OUTPUT_LOCALE = Locale.ENGLISH;
    private static final long serialVersionUID = 2L;
    private double easting;
    private double northing;
    private int zone;

    public UtmPoint() {
        this.easting = 0.0;
        this.northing = 0.0;
        this.zone = 0;
    }

    public UtmPoint(double x, double y, int zone) {
        this.easting = x;
        this.northing = y;
        this.zone = zone;
    }

    @Override
    public double getX() {
        return this.easting;
    }

    @Override
    public double getY() {
        return this.northing;
    }

    public int getZone() {
        return this.zone;
    }

    @Override
    public void setLocation(double x, double y) {
        this.easting = x;
        this.northing = y;
    }

    public void setLocation(double x, double y, int zone) {
        this.easting = x;
        this.northing = y;
        this.zone = zone;
    }

    public String toString() {
        return String.format(OUTPUT_LOCALE, "%d %+10.6f %+11.6f", this.zone, this.easting, this.northing);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Double.hashCode(this.easting);
        result = 31 * result + Double.hashCode(this.northing);
        result = 31 * result + this.zone;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UtmPoint other = (UtmPoint)obj;
        return this.zone == other.zone && Double.doubleToLongBits(this.easting) == Double.doubleToLongBits(other.easting) && Double.doubleToLongBits(this.northing) == Double.doubleToLongBits(other.northing);
    }
}

