/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.geo;

import de.gfz_potsdam.gipp.common.geo.GeographicException;
import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LatLonPoint
implements Serializable {
    private static final Locale OUTPUT_LOCALE = Locale.ENGLISH;
    private static final long serialVersionUID = 1L;
    private static final Pattern LONGITUDE_PATTERN = Pattern.compile("([+-]?\\d{1,3}[.,]?\\d*)\\s?([EeWw]?)");
    private static final Pattern LATITUDE_PATTERN = Pattern.compile("([+-]?\\d{1,2}[.,]?\\d*)\\s?([NnSs]?)");
    private double latitude;
    private double longitude;

    public static LatLonPoint parse(String latText, String lonText) {
        if (latText == null || lonText == null) {
            return null;
        }
        Matcher latMatcher = LATITUDE_PATTERN.matcher(latText);
        Matcher lonMatcher = LONGITUDE_PATTERN.matcher(lonText);
        if (!latMatcher.find()) {
            return null;
        }
        if (!lonMatcher.find()) {
            return null;
        }
        try {
            double lat = Double.parseDouble(latMatcher.group(1));
            double lon = Double.parseDouble(lonMatcher.group(1));
            if (latMatcher.groupCount() == 2 && (latMatcher.group(2).startsWith("S") || latMatcher.group(2).startsWith("s"))) {
                lat *= -1.0;
            }
            if (lonMatcher.groupCount() == 2 && (lonMatcher.group(2).startsWith("W") || lonMatcher.group(2).startsWith("w"))) {
                lon *= -1.0;
            }
            return new LatLonPoint(lat, lon);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public LatLonPoint() {
        this.setLocation(0.0, 0.0);
    }

    public LatLonPoint(double lat, double lon) {
        this.setLocation(lat, lon);
    }

    public void setLocation(double lat, double lon) {
        if (lat > 90.0 || lat < -90.0) {
            throw new GeographicException("Latitude must be in range -90.0 to +90.0 degrees but was " + lat);
        }
        this.latitude = lat;
        this.longitude = lon;
        while (this.longitude > 180.0) {
            this.longitude -= 360.0;
        }
        while (this.longitude < -180.0) {
            this.longitude += 360.0;
        }
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String toString() {
        return String.format(OUTPUT_LOCALE, "%+10.6f %+11.6f", this.latitude, this.longitude);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LatLonPoint other = (LatLonPoint)obj;
        return Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(other.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.latitude);
        return (int)(bits ^= Double.doubleToLongBits(this.longitude) * 31L) ^ (int)(bits >> 32);
    }
}

