/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.geo;

import de.gfz_potsdam.gipp.common.geo.GeographicException;
import de.gfz_potsdam.gipp.common.geo.LatLonPoint;

public enum Ellipsoid {
    WGS84(6378137.0, 298.257223563, "WGS-84"),
    GRS80(6378137.0, 298.257222101, "GFS-80"),
    INTER1924(6378388.0, 297.0, "International 1924"),
    CLARKE1866(6378206.4, 294.9786982, "Clarke 1866");

    private final double semiMajorAxis;
    private final double inverseFlattening;
    private final String description;

    private Ellipsoid(double a, double invF, String name) {
        this.semiMajorAxis = a;
        this.inverseFlattening = invF;
        this.description = name;
    }

    public double getSemiMajor() {
        return this.semiMajorAxis;
    }

    public double getSemiMinor() {
        return this.semiMajorAxis * (1.0 - 1.0 / this.inverseFlattening);
    }

    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    public double squaredEccentricity() {
        double minorAxis = this.getSemiMinor();
        return (this.semiMajorAxis * this.semiMajorAxis - minorAxis * minorAxis) / (this.semiMajorAxis * this.semiMajorAxis);
    }

    public String toString() {
        return this.description;
    }

    public double distance(LatLonPoint point1, LatLonPoint point2) {
        double x1 = Math.toRadians(point1.getLongitude());
        double y1 = Math.toRadians(point1.getLatitude());
        double x2 = Math.toRadians(point2.getLongitude());
        double y2 = Math.toRadians(point2.getLatitude());
        int MAX_ITERATIONS = 100;
        double EPS = 5.0E-14;
        double F = 1.0 / this.getInverseFlattening();
        double R = 1.0 - F;
        double tu1 = R * Math.sin(y1) / Math.cos(y1);
        double tu2 = R * Math.sin(y2) / Math.cos(y2);
        double cu1 = 1.0 / Math.sqrt(tu1 * tu1 + 1.0);
        double cu2 = 1.0 / Math.sqrt(tu2 * tu2 + 1.0);
        double su1 = cu1 * tu1;
        double s = cu1 * cu2;
        double baz = s * tu2;
        double faz = baz * tu1;
        double x = x2 - x1;
        for (int i = 0; i < 100; ++i) {
            double sx = Math.sin(x);
            double cx = Math.cos(x);
            tu1 = cu2 * sx;
            tu2 = baz - su1 * cu2 * cx;
            double sy = Math.hypot(tu1, tu2);
            double cy = s * cx + faz;
            double y = Math.atan2(sy, cy);
            double SA = s * sx / sy;
            double c2a = 1.0 - SA * SA;
            double cz = faz + faz;
            if (c2a > 0.0) {
                cz = -cz / c2a + cy;
            }
            double e = cz * cz * 2.0 - 1.0;
            double c = ((-3.0 * c2a + 4.0) * F + 4.0) * c2a * F / 16.0;
            double d = x;
            x = ((e * cy * c + cz) * sy * c + y) * SA;
            if (!(Math.abs(d - (x = (1.0 - c) * x * F + x2 - x1)) <= 5.0E-14)) continue;
            x = Math.sqrt((1.0 / (R * R) - 1.0) * c2a + 1.0) + 1.0;
            x = (x - 2.0) / x;
            c = 1.0 - x;
            c = (x * x / 4.0 + 1.0) / c;
            d = (0.375 * x * x - 1.0) * x;
            x = e * cy;
            s = 1.0 - 2.0 * e;
            s = ((((sy * sy * 4.0 - 3.0) * s * cz * d / 6.0 - x) * d / 4.0 + cz) * sy * d + y) * c * R * this.getSemiMajor();
            return s;
        }
        double LEPS = 1.0E-10;
        if (Math.abs(x1 - x2) <= 1.0E-10 && Math.abs(y1 - y2) <= 1.0E-10) {
            return 0.0;
        }
        if (Math.abs(y1) <= 1.0E-10 && Math.abs(y2) <= 1.0E-10) {
            return Math.abs(x1 - x2) * this.getSemiMajor();
        }
        throw new GeographicException("Distance calculation failed. Cannot calculate distance between (" + point1 + ") and (" + point2 + ").");
    }
}

