/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;

public class SortedFileSet
extends TreeSet<File>
implements Enumeration<InputStream> {
    public static final File STANDARD_ERROR_TOKEN = new File("STDERR");
    public static final File STANDARD_INPUT_TOKEN = new File("STDIN");
    public static final File STANDARD_OUTPUT_TOKEN = new File("STDOUT");
    private static final long serialVersionUID = 1L;
    private final FileFilter fileSetFilter;
    private Iterator<File> fileSetIterator;

    public SortedFileSet() {
        this(null, null);
    }

    public SortedFileSet(Comparator<File> sortOrder) {
        this(sortOrder, null);
    }

    public SortedFileSet(FileFilter fileFilter) {
        this(null, fileFilter);
    }

    public SortedFileSet(Comparator<File> sortOrder, FileFilter fileFilter) {
        super(sortOrder);
        this.fileSetFilter = fileFilter;
        this.fileSetIterator = null;
    }

    @Override
    public boolean add(File path) {
        if (path.exists() && !path.isDirectory() && !path.isHidden()) {
            File file;
            try {
                file = path.getCanonicalFile();
            }
            catch (IOException e) {
                file = path.getAbsoluteFile();
            }
            try {
                if (this.fileSetFilter == null || this.fileSetFilter.accept(file)) {
                    return super.add(file);
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (path.isDirectory() && (!path.isHidden() || path.getName().equals(".") || path.getName().equals(".."))) {
            boolean result = false;
            File[] dirListing = path.listFiles();
            if (dirListing != null) {
                for (File dirEntry : dirListing) {
                    if (!this.add(dirEntry)) continue;
                    result = true;
                }
            }
            return result;
        }
        if (!path.exists() && (path.equals(STANDARD_ERROR_TOKEN) || path.equals(STANDARD_INPUT_TOKEN) || path.equals(STANDARD_OUTPUT_TOKEN))) {
            return super.add(path);
        }
        return false;
    }

    @Override
    public boolean add(String filename) {
        return this.add(new File(filename));
    }

    @Override
    public boolean hasMoreElements() {
        if (this.fileSetIterator == null) {
            this.fileSetIterator = this.iterator();
        }
        return this.fileSetIterator.hasNext();
    }

    @Override
    public InputStream nextElement() {
        try {
            if (this.hasMoreElements()) {
                return new FileInputStream(this.fileSetIterator.next());
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

