/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.file;

import de.gfz_potsdam.gipp.common.file.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;

public class SortByExtension
implements Comparator<File> {
    @Override
    public int compare(File leftFile, File rightFile) throws IllegalArgumentException {
        String rightPathname;
        String leftPathname;
        String rightFilename;
        String rightExtension;
        if (leftFile == null || rightFile == null) {
            throw new IllegalArgumentException("Cannot compare 'null' files");
        }
        String leftExtension = FileUtils.getSuffix(leftFile);
        int result = leftExtension.compareToIgnoreCase(rightExtension = FileUtils.getSuffix(rightFile));
        if (result != 0) {
            return result;
        }
        String leftFilename = FileUtils.getBasename(leftFile);
        result = leftFilename.compareToIgnoreCase(rightFilename = FileUtils.getBasename(rightFile));
        if (result != 0) {
            return result;
        }
        try {
            leftPathname = leftFile.getCanonicalPath();
        }
        catch (IOException e) {
            leftPathname = leftFile.getAbsolutePath();
        }
        try {
            rightPathname = rightFile.getCanonicalPath();
        }
        catch (IOException e) {
            rightPathname = rightFile.getAbsolutePath();
        }
        result = leftPathname.compareToIgnoreCase(rightPathname);
        return result;
    }
}

