/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.file;

import de.gfz_potsdam.gipp.common.file.FileUtils;
import de.gfz_potsdam.gipp.common.seis.cube.CubeUtils;
import de.gfz_potsdam.gipp.common.seis.cube.HeaderBlock;
import de.gfz_potsdam.gipp.common.seis.cube.IntegrityException;
import de.gfz_potsdam.gipp.common.time.TimeMoment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.Comparator;

public class SortByCubeStream
implements Comparator<File> {
    @Override
    public int compare(File leftFile, File rightFile) throws NullPointerException, IllegalArgumentException, IntegrityException {
        TimeMoment rightStart;
        if (leftFile == null || rightFile == null) {
            throw new NullPointerException("Cannot compare 'null' files");
        }
        HeaderBlock leftHeader = null;
        HeaderBlock rightHeader = null;
        RandomAccessFile leftRAF = null;
        RandomAccessFile rightRAF = null;
        try {
            leftRAF = new RandomAccessFile(leftFile, "r");
            rightRAF = new RandomAccessFile(rightFile, "r");
            leftHeader = CubeUtils.getHeader(leftRAF);
            if (leftHeader == null) {
                throw new IntegrityException("'" + leftFile.getName() + "' is not a Cube file.");
            }
            rightHeader = CubeUtils.getHeader(rightRAF);
            if (rightHeader == null) {
                throw new IntegrityException("'" + rightFile.getName() + "' is not a Cube file.");
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                FileUtils.flushClose(leftRAF);
                FileUtils.flushClose(rightRAF);
                throw throwable;
            }
        }
        FileUtils.flushClose(leftRAF);
        FileUtils.flushClose(rightRAF);
        String leftUnit = leftHeader.cubeName();
        String rightUnit = rightHeader.cubeName();
        int result = leftUnit.compareToIgnoreCase(rightUnit);
        if (result != 0) {
            return result;
        }
        TimeMoment leftStart = leftHeader.approxRecorderStartup();
        result = leftStart.compareTo(rightStart = rightHeader.approxRecorderStartup());
        if (result != 0) {
            return result;
        }
        int leftNumber = leftHeader.fileNumber();
        int rightNumber = rightHeader.fileNumber();
        result = Integer.compare(leftNumber, rightNumber);
        return result;
    }
}

