/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.file;

import de.gfz_potsdam.gipp.common.regex.RegexUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class RegexFilenameFilter
implements FileFilter,
FilenameFilter {
    private final List<Pattern> filterList = new ArrayList<Pattern>();

    public boolean addRegex(String regex) {
        if (regex == null || regex.length() == 0) {
            return false;
        }
        return this.filterList.add(Pattern.compile(regex));
    }

    public boolean addGlobbing(String files) {
        if (files == null || files.length() == 0) {
            return false;
        }
        return this.addRegex(RegexUtils.convertWildcards(files));
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname == null) {
            return false;
        }
        for (Pattern p : this.filterList) {
            if (!p.matcher(pathname.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File parent, String filename) {
        if (filename == null) {
            return false;
        }
        for (Pattern p : this.filterList) {
            if (!p.matcher(filename).matches()) continue;
            return true;
        }
        return false;
    }
}

