/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.file;

import de.gfz_potsdam.gipp.common.file.RegexFilenameFilter;

public class GippFilenameFilter
extends RegexFilenameFilter {
    private static final String GIPP_CUBE_REGEX = "(?i)(0[1-9]|[1-9][0-9])(0[1-9]|[12][0-9]|3[01])([01][0-9]|2[0-3])([0-5][0-9])\\.[A-Z0-9]{3}$";
    private static final String GIPP_NUBE_REGEX = "(?i)(\\d{2})(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])_([01][0-9]|2[0-3])([0-5][0-9])([0-5][0-9]|60)\\.\\d{4}$";
    private static final String GIPP_EVENT_RECORDER_REGEX = "(?i)(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])([01][0-9]|2[0-3])([0-5][0-9])\\.Q\\d{2}$";
    private static final String GIPP_MSEED_REGEX = "(?i)(c|e|n|r)\\w{4}(\\d{2})(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])([01][0-9]|2[0-3])([0-5][0-9])([0-5][0-9]|60)\\.(pri|sec)\\d$";

    private GippFilenameFilter() {
    }

    public static RegexFilenameFilter addCubeFilenameFilter(RegexFilenameFilter filter) {
        assert (filter != null) : "Filename filter argument must not be 'null'!";
        filter.addRegex(GIPP_CUBE_REGEX);
        filter.addRegex(GIPP_NUBE_REGEX);
        return filter;
    }

    public static RegexFilenameFilter addEventRecorderFilenameFilter(RegexFilenameFilter filter) {
        assert (filter != null) : "Filename filter argument must not be 'null'!";
        filter.addRegex(GIPP_EVENT_RECORDER_REGEX);
        return filter;
    }

    public static RegexFilenameFilter addMseedFilenameFilter(RegexFilenameFilter filter) {
        assert (filter != null) : "Filename filter argument must not be 'null'!";
        filter.addRegex(GIPP_MSEED_REGEX);
        return filter;
    }
}

