/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;

public class FileUtils {
    private FileUtils() {
    }

    public static List<File> filesFromEnvironmentVar(String environment) throws SecurityException {
        LinkedList<File> result = new LinkedList<File>();
        if (environment == null || environment.length() == 0) {
            return result;
        }
        String envLocation = System.getenv(environment);
        if (envLocation == null) {
            return result;
        }
        for (String path : envLocation.split(File.pathSeparator)) {
            File file = path.startsWith(File.separator) ? new File(path) : new File(System.getProperty("user.dir"), path);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                file = file.getAbsoluteFile();
            }
            result.add(file);
        }
        return result;
    }

    public static String getSuffix(String fileName) {
        int sepPos;
        if (fileName == null) {
            return null;
        }
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos <= (sepPos = fileName.lastIndexOf(File.separator))) {
            return "";
        }
        return fileName.substring(dotPos + 1);
    }

    public static String getSuffix(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getSuffix(file.getName());
    }

    public static String getBasename(String fileName) {
        int sepPos;
        if (fileName == null) {
            return null;
        }
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos < (sepPos = fileName.lastIndexOf(File.separator))) {
            return fileName.substring(sepPos + 1);
        }
        if (dotPos > sepPos) {
            return fileName.substring(sepPos + 1, dotPos);
        }
        return fileName;
    }

    public static String getBasename(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getBasename(file.getName());
    }

    public static void makeDirectory(File directory) throws IOException {
        directory.mkdirs();
        if (!directory.isDirectory()) {
            throw new IOException("Cannot create directory " + directory.getAbsolutePath() + "\".");
        }
    }

    public static void copyFile(File source, File destination) throws IOException {
        FileUtils.copyFile(source, destination, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File destination, boolean overwrite, boolean preserveTime) throws IOException {
        File target = destination.isDirectory() ? new File(destination, source.getName()) : destination;
        if (!source.canRead()) {
            throw new IOException("Cannot copy file. Reason: Can't read from \"" + source.getAbsolutePath() + "\"!");
        }
        if (!target.getParentFile().isDirectory()) {
            throw new IOException("Cannot copy file. Reason: \"" + target.getParent() + "\" is not a directory!");
        }
        if (overwrite && target.exists() && !target.delete()) {
            throw new IOException("Cannot copy file. Reason: Unable to remove already existing file \"" + target.getAbsolutePath() + "\" first!");
        }
        if (!target.createNewFile()) {
            throw new IOException("Cannot copy file. Reason: File \"" + target.getAbsoluteFile() + "\" already exists!");
        }
        if (source.length() == 0L) {
            return;
        }
        long count = 0L;
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            inStream = new FileInputStream(source);
            inChannel = inStream.getChannel();
            outStream = new FileOutputStream(target);
            outChannel = outStream.getChannel();
            count = inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (Throwable throwable) {
            FileUtils.flushClose(inChannel);
            FileUtils.flushClose(inStream);
            FileUtils.flushClose(outChannel);
            FileUtils.flushClose(outStream);
            throw throwable;
        }
        FileUtils.flushClose(inChannel);
        FileUtils.flushClose(inStream);
        FileUtils.flushClose(outChannel);
        FileUtils.flushClose(outStream);
        if (preserveTime) {
            destination.setLastModified(source.lastModified());
        }
        if (count != source.length()) {
            throw new IOException("Cannot copy file. Reason: Incomplete transfer! Only " + count + " of expected " + source.length() + " bytes were transfered!");
        }
    }

    public static void moveFile(File source, File destination) throws IOException {
        FileUtils.moveFile(source, destination, false, true);
    }

    public static void moveFile(File source, File target, boolean forceOverwrite, boolean preserveTime) throws IOException {
        FileUtils.copyFile(source, target, forceOverwrite, preserveTime);
        if (!source.delete()) {
            throw new IOException("Cannot remove source file \"" + source.getAbsolutePath() + "\" after copying!");
        }
    }

    public static void flushClose(Closeable resource) {
        if (resource == null) {
            return;
        }
        try {
            if (resource instanceof Flushable) {
                ((Flushable)((Object)resource)).flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (!(resource.equals(System.out) || resource.equals(System.err) || resource.equals(System.in))) {
                resource.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

