/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.crypto;

import de.gfz_potsdam.gipp.common.string.StringUtils;
import java.security.MessageDigest;

public class Crc64
extends MessageDigest {
    protected static final String ALGORITHM_NAME = "CRC-64";
    private static final long[] LOOKUP_TABLE = new long[256];
    private final long seedValue;
    private long crcValue;

    public Crc64() {
        this(0L);
    }

    public Crc64(long seed) {
        super(ALGORITHM_NAME);
        this.seedValue = seed;
        this.crcValue = seed;
    }

    @Override
    public String toString() {
        return "CRC-64 Message Digest, " + StringUtils.toHexString(this.crcValue);
    }

    @Override
    public int engineGetDigestLength() {
        return 8;
    }

    @Override
    protected byte[] engineDigest() {
        byte[] crc = new byte[]{(byte)(this.crcValue >> 56), (byte)(this.crcValue >> 48), (byte)(this.crcValue >> 40), (byte)(this.crcValue >> 32), (byte)(this.crcValue >> 24), (byte)(this.crcValue >> 16), (byte)(this.crcValue >> 8), (byte)this.crcValue};
        this.engineReset();
        return crc;
    }

    public long getLongValue() {
        return this.crcValue;
    }

    @Override
    protected void engineReset() {
        this.crcValue = this.seedValue;
    }

    @Override
    protected void engineUpdate(byte input) {
        this.crcValue = this.crcValue >>> 8 ^ LOOKUP_TABLE[(int)((this.crcValue ^ (long)input) & 0xFFL)];
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int length) {
        assert (offset >= 0 && offset < input.length) : "Start offset must be inside array.";
        assert (offset + length <= input.length) : "Length extends beyond data array.";
        for (int i = offset; i < offset + length; ++i) {
            this.engineUpdate(input[i]);
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long value = i;
            for (int j = 0; j < 8; ++j) {
                if ((value & 1L) == 1L) {
                    value = value >>> 1 ^ 0xD800000000000000L;
                    continue;
                }
                value >>>= 1;
            }
            Crc64.LOOKUP_TABLE[i] = value;
        }
    }
}

